/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.network.BossDefeatedPacket;
import com.yori3o.boss_checklist.server.BossDefeatedAndLoad;
import com.yori3o.boss_checklist.server.BossDefeatedData;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossChecklist {
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    public static final String MOD_ID = "boss_checklist";

    public void init() {
        LifecycleEvent.SERVER_STARTED.register(this::onServerStarted);
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> BossChecklistClient.OnlyClientInit());
    }

    private void onServerStarted(MinecraftServer server) {
        BossDefeatedAndLoad.load(server);
    }

    private void onPlayerJoin(ServerPlayer player) {
        ServerLevel overworld = player.f_8924_.m_129783_();
        Set<String> data = BossDefeatedData.get(overworld).getDefeatedBosses();
        for (String lineOfInformation : data) {
            FriendlyByteBuf registryBuf = new FriendlyByteBuf(Unpooled.buffer());
            registryBuf.m_130070_(lineOfInformation);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BossDefeatedPacket.BOSS_DEFEATED_PACKET, (FriendlyByteBuf)registryBuf);
        }
    }
}

