/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.yori3o.boss_checklist.client.gui.BossInfoScreen;
import com.yori3o.boss_checklist.client.gui.CustomCheckbox;
import com.yori3o.boss_checklist.client.gui.CustomPageButton;
import com.yori3o.boss_checklist.client.gui.TextUtil;
import com.yori3o.boss_checklist.data.BossData;
import com.yori3o.boss_checklist.data.BossDataClientSaver;
import com.yori3o.boss_checklist.data.BossRegistry;
import com.yori3o.boss_checklist.init.BossChecklistKeyMapping;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossChecklistScreen
extends Screen {
    private static final BossDataClientSaver DATA_SAVER = new BossDataClientSaver();
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final ResourceLocation bar_background = new ResourceLocation("boss_checklist", "textures/gui/white_background.png");
    private static final ResourceLocation bar_progress = new ResourceLocation("boss_checklist", "textures/gui/white_progress.png");
    private static final ResourceLocation background_texture = new ResourceLocation("boss_checklist", "textures/gui/boss_book.png");
    private static final int ELEMENTS_PER_PAGE = 7;
    private int currentSpread = 0;
    private int maxTextWidth = 95;
    private List<BossData> bossDataList = new ArrayList<BossData>();
    private List<CustomCheckbox> currentCheckboxes = new ArrayList<CustomCheckbox>();
    private CustomPageButton nextButton;
    private CustomPageButton prevButton;
    private int leftPage;
    private int rightPage;
    private boolean noBossesLoaded = false;
    private boolean bossesListAreLoaded = false;
    private List<Component> bosses = new ArrayList<Component>();
    private List<String> bossIds = new ArrayList<String>();
    private int defeatedCount;
    private int totalCount;
    private float percent;

    public BossChecklistScreen() {
        super((Component)Component.m_237113_((String)"Checklist"));
    }

    public void m_7856_() {
        super.m_7856_();
        if (!this.bossesListAreLoaded) {
            this.bossesListAreLoaded = true;
            this.bossDataList = BossRegistry.all().stream().toList();
            this.bossIds.addAll(BossRegistry.all().stream().map(BossData::getId).toList());
            for (BossData b : this.bossDataList) {
                String translated = Component.m_237115_((String)("boss_checklist.boss." + b.getId())).getString();
                String truncated = TextUtil.truncateText(translated, this.maxTextWidth).getString();
                this.bosses.add((Component)Component.m_237113_((String)truncated));
            }
        }
        this.updateCounts();
        this.createPageButtons();
        this.updatePage();
    }

    private void updateCounts() {
        this.defeatedCount = DATA_SAVER.defeatedBossesCount();
        this.totalCount = this.bossIds.size();
        this.percent = this.totalCount > 0 ? (float)this.defeatedCount / (float)this.totalCount : 0.0f;
    }

    private void createPageButtons() {
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        double totalPages = Math.ceil((double)this.bosses.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        this.prevButton = new CustomPageButton(bookX + 138, bookY + 190, true, () -> {
            if (this.currentSpread > 0) {
                --this.currentSpread;
                this.updatePage();
            }
        });
        this.nextButton = new CustomPageButton(bookX + 350, bookY + 190, false, () -> {
            if (this.currentSpread < totalSpreads - 1) {
                ++this.currentSpread;
                this.updatePage();
            }
        });
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
    }

    private void updatePage() {
        if (this.bosses.isEmpty()) {
            LOGGER.warn("No bosses loaded at checklist!");
            this.prevButton.f_93624_ = false;
            this.nextButton.f_93624_ = false;
            this.noBossesLoaded = true;
            return;
        }
        for (CustomCheckbox cb : this.currentCheckboxes) {
            this.m_169411_((GuiEventListener)cb);
        }
        this.currentCheckboxes.clear();
        double totalPages = Math.ceil((double)this.bosses.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        int fromIndex = this.currentSpread * 14;
        int toIndex = Math.min(fromIndex + 14, this.bosses.size());
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        int leftX = bookX + 134;
        int rightX = bookX + 266;
        int startY = bookY + 56;
        for (int i = fromIndex; i < toIndex; ++i) {
            String boss = this.bosses.get(i).getString();
            String bossId = this.bossIds.get(i);
            int localIndex = i - fromIndex;
            int x = localIndex < 7 ? leftX : rightX;
            int y = startY + localIndex % 7 * 18;
            CustomCheckbox cb = new CustomCheckbox(x, y, (Component)Component.m_237113_((String)boss), DATA_SAVER.isBossDefeated(bossId), checked -> {
                BossDataClientSaver.BossDefeated(bossId, checked);
                this.updateCounts();
            }, () -> Minecraft.m_91087_().m_91152_((Screen)new BossInfoScreen(this, bossId)));
            this.m_142416_((GuiEventListener)cb);
            this.currentCheckboxes.add(cb);
        }
        this.prevButton.f_93624_ = this.currentSpread > 0;
        this.nextButton.f_93624_ = this.currentSpread < totalSpreads - 1;
        this.leftPage = this.currentSpread * 2 + 1;
        this.rightPage = this.currentSpread * 2 + 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        guiGraphics.m_280163_(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.m_280163_(bar_background, bookX + 165, bookY + 29, 0.0f, 0.0f, 182, 5, 182, 5);
        guiGraphics.m_280163_(bar_progress, bookX + 165, bookY + 29, 0.0f, 0.0f, (int)(this.percent * 182.0f), 5, 182, 5);
        guiGraphics.m_280056_(this.f_96547_, this.defeatedCount + " / " + this.totalCount, (this.f_96543_ - Minecraft.m_91087_().f_91062_.m_92895_(this.defeatedCount + " / " + this.totalCount)) / 2, bookY + 20, 0xFFFFFF, false);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.noBossesLoaded) {
            guiGraphics.m_280056_(this.f_96547_, "No bosses loaded!", bookX + 140, bookY + 53, 0, false);
        } else {
            guiGraphics.m_280056_(this.f_96547_, String.valueOf(this.leftPage), bookX + 187, bookY + 195, 0, false);
            guiGraphics.m_280056_(this.f_96547_, String.valueOf(this.rightPage), bookX + 320, bookY + 195, 0, false);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistKeyMapping.OPEN_CHECKLIST.m_90832_(keyCode, scanCode)) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

