/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.yori3o.boss_checklist.BossChecklist;
import com.yori3o.boss_checklist.network.BossDefeatServerSend;
import com.yori3o.boss_checklist.server.BossDefeatedData;
import com.yori3o.boss_checklist.server.ServerBossIdsLoader;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;

public class BossChecklistCommands {
    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> BossChecklistCommands.registerCommands((CommandDispatcher<CommandSourceStack>)dispatcher));
    }

    private static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"boss_checklist").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"set_defeated").then(Commands.m_82129_((String)"boss_id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(BossChecklistCommands::suggestBossIds).then(Commands.m_82129_((String)"defeated", (ArgumentType)BoolArgumentType.bool()).executes(BossChecklistCommands::executeSetDefeated)))));
    }

    private static CompletableFuture<Suggestions> suggestBossIds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        for (String id : ServerBossIdsLoader.server_bosses_ids_list_only_loaded_mods) {
            builder.suggest(id);
        }
        return builder.buildFuture();
    }

    private static int executeSetDefeated(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String bossId = ResourceLocationArgument.m_107011_(ctx, (String)"boss_id").toString();
        boolean defeated = BoolArgumentType.getBool(ctx, (String)"defeated");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!ServerBossIdsLoader.server_bosses_ids_list_only_loaded_mods.contains(bossId)) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)(Component.m_237115_((String)"command.boss_checklist.boss_marked_successfully").getString() + bossId))).create();
        }
        BossDefeatServerSend.onBossOrMinibossKilled(source.m_81372_(), bossId, "", defeated);
        String value = bossId + "##" + (defeated ? "true" : "false");
        BossDefeatedData data = BossDefeatedData.get(source.m_81372_().m_7654_().m_129783_());
        if (defeated) {
            data.addBoss(value);
            BossChecklist.defeated_bosses_on_server.add(value);
        } else {
            data.removeBoss(value);
            LoggerUtil.LOGGER.info("boss undefeating its value - " + value);
            BossChecklist.removeBossFromDefeated_bosses_on_server(value);
        }
        String[] text = Component.m_237115_((String)"command.boss_checklist.boss_marked_successfully").getString().split("%");
        source.m_288197_(() -> Component.m_237113_((String)(text[0] + bossId + text[1] + (defeated ? "defeated" : "undefeated") + text[2])), true);
        return 1;
    }
}

