/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.yori3o.boss_checklist.data.BossData;
import com.yori3o.boss_checklist.data.BossDataClientSaver;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossRegistry {
    private static final BossDataClientSaver DATA_SAVER = new BossDataClientSaver();
    private static final Map<String, BossData> BOSSES = new LinkedHashMap<String, BossData>();
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    public static List<BossData> bossDataList;
    private static final Gson GSON;

    public static void load() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1478() == null) {
            LOGGER.warn("ResourceManager not ready yet!");
            return;
        }
        BOSSES.clear();
        try {
            class_3300 resourceManager = mc.method_1478();
            class_2960 loc = class_2960.method_60655((String)"boss_checklist", (String)"bosses.json");
            try (BufferedReader reader = resourceManager.openAsReader(loc);){
                Type listType = new TypeToken<List<BossData>>(){}.getType();
                bossDataList = (List)GSON.fromJson((Reader)reader, listType);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to find or open bosses.json at BossRegistry!");
                return;
            }
            bossDataList.sort((b, a) -> Integer.compare(b.getPosition(), a.getPosition()));
            for (BossData data : bossDataList) {
                if (!Platform.isModLoaded((String)data.getModId())) continue;
                data.SetDefeated(DATA_SAVER.isBossDefeated(data.getId()));
                BOSSES.put(data.getId(), data);
            }
            LOGGER.info("Loaded bosses: " + String.valueOf(BOSSES.keySet()));
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred while loading bosses!", (Throwable)e);
        }
    }

    public static BossData get(String id) {
        return BOSSES.get(id);
    }

    public static Collection<BossData> all() {
        return BOSSES.values();
    }

    static {
        GSON = new Gson();
    }
}

