/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.utils.PlatformUtils;
import dev.architectury.platform.Platform;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class CustomCheckbox
extends AbstractWidget {
    private boolean selected;
    private boolean isLabelClickDoingAnything;
    private final Consumer<Boolean> onValueChange;
    private final Runnable onLabelClick;
    private static final ResourceLocation CHECKBOX_TEXTURE = new ResourceLocation("boss_checklist", "textures/gui/checkbox.png");
    private static final ResourceLocation NOTICE = new ResourceLocation("boss_checklist", "textures/gui/notice.png");
    private static final float SCALE = 0.5f;
    private static final float TEXT_SCALE = 1.0f;
    private static final int LOGICAL_BOX = 16;
    private static final int PADDING = 4;
    private boolean renderNotice = false;
    public boolean isAnimating = false;
    public boolean animationPlayed = true;
    public long animationStartTime = 0L;
    private static final int ANIMATION_DURATION_MS = 105;
    private static final int FRAME_COUNT = 6;

    public CustomCheckbox(int x, int y, Component label, boolean selected, boolean isLabelClickDoingAnything, boolean renderNotice, Consumer<Boolean> onValueChange, Runnable onLabelClick) {
        super(x, y, (int)(8.0f + (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)label) * 1.0f + 8.0f), 8, label);
        this.selected = selected;
        this.isLabelClickDoingAnything = isLabelClickDoingAnything;
        this.onValueChange = onValueChange;
        this.onLabelClick = onLabelClick;
        this.renderNotice = renderNotice;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int textColor;
        int sx = this.m_252754_();
        int sy = this.m_252907_();
        int boxScreen = 8;
        boolean hoverBox = mouseX >= sx && mouseY >= sy && mouseX < sx + boxScreen && mouseY < sy + boxScreen;
        int labelStart = sx + boxScreen + 4;
        int labelLen = (int)((float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_6035_()) * 1.0f);
        boolean hoverLabel = mouseX >= labelStart && mouseY >= sy && mouseX < labelStart + labelLen && mouseY < sy + boxScreen;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)sx, (float)sy, 0.0f);
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        if (this.renderNotice) {
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(NOTICE, -19, -19, 0.0f, 0.0f, 54, 54, 54, 54);
        }
        guiGraphics.m_280163_(CHECKBOX_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        int box = 16;
        int inner = hoverBox ? 0x54FFFFFF : 0;
        guiGraphics.m_280509_(0, 0, box, box, inner);
        if (this.selected) {
            if (BossChecklistClient.isAnimationEnabled_dynamic) {
                RenderSystem.enableBlend();
                int frameIndex = 5;
                if (this.isAnimating && !this.animationPlayed) {
                    long elapsed = System.currentTimeMillis() - this.animationStartTime;
                    float progress = (float)elapsed / 105.0f;
                    if (progress >= 1.0f) {
                        progress = 1.0f;
                        this.isAnimating = false;
                        this.animationPlayed = true;
                    }
                    frameIndex = Math.min((int)(progress * 6.0f), 5);
                }
                ResourceLocation frameTexture = new ResourceLocation("boss_checklist", "textures/gui/checkmark/checkmark_" + frameIndex + ".png");
                guiGraphics.m_280163_(frameTexture, -2, -2, 0.0f, 0.0f, 20, 20, 20, 20);
            } else {
                RenderSystem.enableBlend();
                guiGraphics.m_280163_(new ResourceLocation("boss_checklist", "textures/gui/checkmark/checkmark_5.png"), -2, -2, 0.0f, 0.0f, 20, 20, 20, 20);
            }
        }
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)labelStart, (float)sy, 0.0f);
        guiGraphics.m_280168_().m_85841_(1.0f, 1.0f, 1.0f);
        if (this.isLabelClickDoingAnything) {
            int n = textColor = this.selected ? -14640864 : -5614251;
            if (hoverLabel) {
                textColor = this.selected ? -11682483 : -2714476;
            }
        } else {
            textColor = -13486792;
        }
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, this.m_6035_(), 0, 0, textColor, false);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int sx = this.m_252754_();
        int sy = this.m_252907_();
        int boxScreen = 8;
        if (mouseX >= (double)sx && mouseY >= (double)sy && mouseX < (double)(sx + boxScreen) && mouseY < (double)(sy + boxScreen)) {
            boolean bl = this.selected = !this.selected;
            if (this.onValueChange != null) {
                this.onValueChange.accept(this.selected);
            }
            this.renderNotice = false;
            if (this.selected) {
                if (Platform.isForge()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)PlatformUtils.getSound(new ResourceLocation("boss_checklist", "checkmark_added")), (float)1.0f));
                } else {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)BossChecklistClient.CHECKMARK_ADDED, (float)1.0f));
                }
                if (BossChecklistClient.isAnimationEnabled_dynamic) {
                    this.isAnimating = true;
                    this.animationPlayed = false;
                    this.animationStartTime = System.currentTimeMillis();
                }
            } else {
                if (Platform.isForge()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)PlatformUtils.getSound(new ResourceLocation("boss_checklist", "checkmark_deleted")), (float)1.0f));
                } else {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)BossChecklistClient.CHECKMARK_DELETED, (float)1.0f));
                }
                if (BossChecklistClient.isAnimationEnabled_dynamic) {
                    this.isAnimating = false;
                    this.animationPlayed = true;
                }
            }
            return true;
        }
        int labelStart = sx + boxScreen + 4;
        int labelLen = (int)((float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_6035_()) * 1.0f);
        if (mouseX >= (double)labelStart && mouseY >= (double)sy && mouseX < (double)(labelStart + labelLen) && mouseY < (double)(sy + boxScreen) && this.onLabelClick != null) {
            this.renderNotice = false;
            this.onLabelClick.run();
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    protected void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }
}

