/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yori3o.boss_checklist.client.gui.CustomButton;
import com.yori3o.boss_checklist.data.BossData;
import com.yori3o.boss_checklist.data.BossDataClientSaver;
import com.yori3o.boss_checklist.data.BossRegistry;
import com.yori3o.boss_checklist.init.BossChecklistKeyMapping;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossInfoScreen
extends Screen {
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final ResourceLocation background_texture = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/boss_book.png");
    private static final ResourceLocation BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/button.png");
    private static final ResourceLocation BUTTON_TEXTURE_hovered = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/button_hovered.png");
    private static final ResourceLocation BUTTON_TEXTURE_pressed = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/button_pressed.png");
    private static final ResourceLocation BOOKMARK = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/bookmark.png");
    private static final ResourceLocation BOOKMARK_NOT_DEFEATED = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/bookmark_not_defeated.png");
    private static final ResourceLocation BOOKMARK_DEFEATED = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/bookmark_defeated.png");
    private static final ResourceLocation BOOKMARK_INFO = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/bookmark_info.png");
    private static ResourceLocation BOSS;
    private boolean brokenBossModel = false;
    private boolean bossNameIsBig = false;
    private boolean skipNextRenderBackground = false;
    private Component summonText;
    private int bossYCorrection;
    private boolean dropsAreLoaded = false;
    private final Screen parent;
    private final String bossId;
    private final BossData boss;
    private String bossName;
    private final String modName;
    private CustomButton dropButton;
    private CustomButton spawnButton;
    private InfoTab currentTab = InfoTab.NONE;
    private int dropSpacing = 22;
    private int perRow = 5;
    private String itemid;
    private String dropChance;
    private Boolean chance;
    private float rotationY = 0.0f;
    private float rotationX = 0.0f;
    private boolean dragging = false;
    private static final float MOUSE_SENS = 0.7f;
    private boolean allowRotation = true;
    private LivingEntity entity;
    private int bossScale;
    private boolean isBossDefeated_InWorld = false;
    private boolean isLocalServer = false;
    private int boss_health;
    private double boss_armor;
    private boolean additionalInfo = false;
    private String killerName = "";
    private boolean showInfo = true;
    private EntityRenderDispatcher dispatcher;
    private MultiBufferSource.BufferSource buffer;
    private List<Component> tooltip = new ArrayList<Component>();
    private List<Component> tooltip2 = new ArrayList<Component>();
    private List<Component> tooltip3 = new ArrayList<Component>();
    private List<String> drops = new ArrayList<String>();

    public static LivingEntity createEntityFromId(String id) {
        Minecraft mc = Minecraft.getInstance();
        ResourceLocation rl = ResourceLocation.parse((String)id);
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(rl);
        if (type == null) {
            throw new IllegalArgumentException("Not found EntityType by id: " + id);
        }
        Entity entity = type.create((Level)mc.level);
        return (LivingEntity)entity;
    }

    public BossInfoScreen(Screen parent, String bossId) {
        super((Component)Component.literal((String)"Boss Info"));
        this.parent = parent;
        this.bossId = bossId;
        this.boss = BossRegistry.get(bossId);
        this.bossName = Component.translatable((String)("boss_checklist.boss." + bossId)).getString();
        this.modName = Component.translatable((String)("boss_checklist.mod." + this.boss.getModId())).getString();
    }

    public void init() {
        super.init();
        this.bossScale = this.boss.getScale();
        this.summonText = Component.translatable((String)("boss_checklist.summon." + this.bossId));
        this.entity = BossInfoScreen.createEntityFromId(this.boss.getModId() + ":" + this.bossId);
        this.boss_health = (int)this.entity.getAttributeValue(Attributes.MAX_HEALTH);
        this.boss_armor = (int)this.entity.getAttributeValue(Attributes.ARMOR);
        this.dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        this.buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        this.isLocalServer = Minecraft.getInstance().isLocalServer();
        this.isBossDefeated_InWorld = BossDataClientSaver.defeatedBossesIds_InWorld.contains(this.bossId);
        if (this.isBossDefeated_InWorld) {
            this.killerName = BossDataClientSaver.whoKiller(this.bossId);
            this.tooltip3.clear();
            if (this.killerName.length() == 0) {
                this.tooltip3.add((Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.defeated").getString()));
            } else {
                this.tooltip3.add((Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.defeated").getString()));
                this.tooltip3.add((Component)Component.literal((String)(Component.translatable((String)"gui.boss_checklist.killer_name").getString() + this.killerName)));
            }
        }
        if (this.boss.isBrokenModel().booleanValue()) {
            BOSS = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)("textures/gui/bosses/" + this.bossId + ".png"));
            this.brokenBossModel = true;
        }
        if ("sculptor".equals(this.bossId) || "frostmaw".equals(this.bossId) || "malkuth".equals(this.bossId) || "chesed".equals(this.bossId) || "fairkeeper_boros".equals(this.bossId) || "fairkeeper_ouros".equals(this.bossId) || "gundalf".equals(this.bossId)) {
            this.additionalInfo = true;
        }
        if (Minecraft.getInstance().font.width(this.bossName) > 95) {
            this.bossNameIsBig = true;
        }
        this.bossYCorrection = this.boss.getYOffset();
        if (!this.dropsAreLoaded) {
            for (String dropId : this.boss.getDrops()) {
                String modId_fromDrop = dropId.split(":")[0];
                if (!Platform.isModLoaded((String)modId_fromDrop)) continue;
                this.drops.add(dropId);
            }
            this.dropsAreLoaded = true;
        }
        this.tooltip.clear();
        this.tooltip2.clear();
        this.tooltip.add((Component)Component.literal((String)(Component.translatable((String)"gui.boss_checklist.health").getString() + this.boss_health)));
        this.tooltip.add((Component)Component.literal((String)(Component.translatable((String)"gui.boss_checklist.armor").getString() + this.boss_armor)));
        this.tooltip2.add((Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.not_defeated").getString()));
        this.tooltip2.add((Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.server_warning").getString()));
        this.createButtons();
    }

    private void createButtons() {
        int bookX = (this.width - 512) / 2;
        int bookY = (this.height - 256) / 2;
        this.dropButton = this.showInfo ? new CustomButton(bookX + 265, bookY + 51, 50, 18, (Component)Component.translatable((String)"gui.boss_checklist.drop"), BUTTON_TEXTURE, BUTTON_TEXTURE_hovered, BUTTON_TEXTURE_pressed, () -> {
            this.currentTab = InfoTab.DROP;
        }) : new CustomButton(bookX + 265, bookY + 51, 50, 18, (Component)Component.translatable((String)"gui.boss_checklist.drop"), BUTTON_TEXTURE, BUTTON_TEXTURE, BUTTON_TEXTURE, () -> {});
        this.spawnButton = new CustomButton(bookX + 328, bookY + 51, 50, 18, (Component)Component.translatable((String)"gui.boss_checklist.spawn_info"), BUTTON_TEXTURE, BUTTON_TEXTURE_hovered, BUTTON_TEXTURE_pressed, () -> {
            this.currentTab = InfoTab.SPAWN;
        });
        this.addRenderableWidget((GuiEventListener)this.dropButton);
        this.addRenderableWidget((GuiEventListener)this.spawnButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.skipNextRenderBackground = true;
        int bookX = (this.width - 512) / 2;
        int bookY = (this.height - 256) / 2;
        if (this.allowRotation) {
            this.rotationY += 0.5f * partialTick;
        }
        guiGraphics.blit(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.blit(BOOKMARK, bookX + 145, bookY + 210, 0.0f, 0.0f, 16, 27, 16, 27);
        if (this.isBossDefeated_InWorld) {
            guiGraphics.blit(BOOKMARK_DEFEATED, bookX + 172, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        } else {
            guiGraphics.blit(BOOKMARK_NOT_DEFEATED, bookX + 172, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        }
        if (this.additionalInfo && this.showInfo) {
            guiGraphics.blit(BOOKMARK_INFO, bookX + 199, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        }
        if (this.bossNameIsBig) {
            guiGraphics.drawWordWrap(this.font, (FormattedText)Component.literal((String)("\u00a7l" + this.bossName)), bookX + 137, bookY + 53, 110, -16777216);
            guiGraphics.drawWordWrap(this.font, (FormattedText)Component.literal((String)this.modName), bookX + 137, bookY + 73, 110, -10395295);
        } else {
            guiGraphics.drawString(this.font, "\u00a7l" + this.bossName, bookX + 137, bookY + 53, -16777216, false);
            guiGraphics.drawWordWrap(this.font, (FormattedText)Component.literal((String)this.modName), bookX + 137, bookY + 65, 110, -10395295);
        }
        if (this.currentTab == InfoTab.DROP) {
            this.renderDrops(guiGraphics, mouseX, mouseY, bookX + 265, bookY + 80);
        } else if (this.currentTab == InfoTab.SPAWN) {
            this.renderSummon(guiGraphics, bookX + 265, bookY + 80);
        }
        if (this.showInfo) {
            if (this.brokenBossModel) {
                guiGraphics.blit(BOSS, bookX + 137, bookY + 100, 0.0f, 0.0f, 100, 100, 100, 100);
            } else {
                this.renderEntityInGui(guiGraphics, bookX + 132 + 56, bookY + 90 + 85, this.bossScale, partialTick);
            }
        }
        if (mouseX >= bookX + 145 && mouseX < bookX + 145 + 16 && mouseY >= bookY + 209 && mouseY < bookY + 209 + 27) {
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltip, mouseX, mouseY);
        }
        if (this.additionalInfo && mouseX >= bookX + 199 && mouseX < bookX + 199 + 16 && mouseY >= bookY + 210 && mouseY < bookY + 210 + 27) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)Component.translatable((String)("gui.boss_checklist.info_" + this.bossId)).getString()), mouseX, mouseY);
        }
        if (mouseX >= bookX + 172 && mouseX < bookX + 172 + 16 && mouseY >= bookY + 210 && mouseY < bookY + 210 + 27) {
            if (this.isBossDefeated_InWorld) {
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltip3, mouseX, mouseY);
            } else if (this.isLocalServer) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.not_defeated").getString()), mouseX, mouseY);
            } else {
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, this.tooltip2, mouseX, mouseY);
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.showInfo) {
            guiGraphics.fill(bookX + 265, bookY + 51, bookX + 265 + 50, bookY + 51 + 18, -2002081110);
        }
    }

    private void renderDrops(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (this.drops == null || this.drops.isEmpty()) {
            guiGraphics.drawString(this.font, Component.translatable((String)"gui.boss_checklist.no_drop").getString(), x, y, -10395295, false);
            return;
        }
        int i = 0;
        for (String id : this.drops) {
            int row = i / this.perRow;
            int col = i % this.perRow;
            int xPos = x + col * this.dropSpacing;
            int yPos = y + row * this.dropSpacing;
            if (id.split("#").length > 1) {
                this.itemid = id.split("#")[0];
                this.dropChance = id.split("#")[1];
                this.chance = true;
            } else {
                this.itemid = id.split("#")[0];
                this.chance = false;
            }
            ResourceLocation loc = ResourceLocation.parse((String)this.itemid);
            Item item = (Item)BuiltInRegistries.ITEM.get(loc);
            ItemStack stack = new ItemStack((ItemLike)item);
            guiGraphics.renderItem(stack, xPos, yPos);
            if (this.chance.booleanValue()) {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                guiGraphics.pose().scale(0.75f, 0.75f, 1.0f);
                guiGraphics.drawString(this.font, this.dropChance + "%", (int)((double)xPos / 0.75 + 4.0), (int)((double)yPos / 0.75 + 22.0), -10395295, false);
                guiGraphics.pose().popPose();
            }
            if (mouseX >= xPos && mouseX <= xPos + 16 && mouseY >= yPos && mouseY <= yPos + 16) {
                guiGraphics.renderTooltip(this.font, stack, mouseX, mouseY);
            }
            ++i;
        }
    }

    private void renderSummon(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawWordWrap(this.font, (FormattedText)this.summonText, x, y, 117, 0);
    }

    public void renderEntityInGui(GuiGraphics graphics, int x, int y, int scale, float partialTicks) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        this.entity.tickCount = 0;
        poseStack.translate((float)x, (float)(y + this.bossYCorrection), 0.0f);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        poseStack.translate(0.0f, -this.entity.getBbHeight() / 2.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(this.rotationX + 180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-this.rotationY + 180.0f));
        this.dispatcher.render((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, (MultiBufferSource)this.buffer, 0xF000F0);
        this.buffer.endBatch();
        poseStack.popPose();
    }

    private boolean isMouseOverBoss(double mouseX, double mouseY) {
        return mouseX >= (double)((this.width - 512) / 2 + 135) && mouseX <= (double)((this.width - 512) / 2 + 135 + 110) && mouseY >= (double)((this.height - 256) / 2 + 90) && mouseY <= (double)((this.height - 256) / 2 + 90 + 110);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOverBoss(mouseX, mouseY)) {
            this.dragging = true;
            this.allowRotation = false;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == 0) {
            this.rotationY += (float)(dragX * (double)0.7f);
            this.rotationX -= (float)(dragY * (double)0.7f);
            this.rotationX = Mth.clamp((float)this.rotationX, (float)-75.0f, (float)75.0f);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            this.allowRotation = true;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistKeyMapping.OPEN_CHECKLIST.matches(keyCode, scanCode)) {
            Minecraft.getInstance().setScreen(this.parent);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.skipNextRenderBackground) {
            this.skipNextRenderBackground = false;
            return;
        }
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    private static enum InfoTab {
        NONE,
        DROP,
        SPAWN;

    }
}

