/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yori3o.boss_checklist.BossChecklistClient;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class CustomCheckbox
extends AbstractWidget {
    private boolean selected;
    private final Consumer<Boolean> onValueChange;
    private final Runnable onLabelClick;
    private static final ResourceLocation CHECKMARK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/checkmark.png");
    private static final ResourceLocation CHECKBOX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/checkbox.png");
    private static final float SCALE = 0.5f;
    private static final float TEXT_SCALE = 1.0f;
    private static final int LOGICAL_BOX = 16;
    private static final int PADDING = 4;

    public CustomCheckbox(int x, int y, Component label, boolean selected, Consumer<Boolean> onValueChange, Runnable onLabelClick) {
        super(x, y, (int)(8.0f + (float)Minecraft.getInstance().font.width((FormattedText)label) * 1.0f + 8.0f), 8, label);
        this.selected = selected;
        this.onValueChange = onValueChange;
        this.onLabelClick = onLabelClick;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int textColor;
        int sx = this.getX();
        int sy = this.getY();
        int boxScreen = 8;
        boolean hoverBox = mouseX >= sx && mouseY >= sy && mouseX < sx + boxScreen && mouseY < sy + boxScreen;
        int labelStart = sx + boxScreen + 4;
        int labelLen = (int)((float)Minecraft.getInstance().font.width((FormattedText)this.getMessage()) * 1.0f);
        boolean hoverLabel = mouseX >= labelStart && mouseY >= sy && mouseX < labelStart + labelLen && mouseY < sy + boxScreen;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)sx, (float)sy, 0.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        guiGraphics.blit(CHECKBOX_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        int box = 16;
        int inner = hoverBox ? 0x54FFFFFF : 0;
        guiGraphics.fill(0, 0, box, box, inner);
        if (this.selected) {
            RenderSystem.enableBlend();
            guiGraphics.blit(CHECKMARK_TEXTURE, -2, -2, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)labelStart, (float)sy, 0.0f);
        guiGraphics.pose().scale(1.0f, 1.0f, 1.0f);
        int n = textColor = this.selected ? -14640864 : -5614251;
        if (hoverLabel) {
            textColor = this.selected ? -11682483 : -2714476;
        }
        guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), 0, 0, textColor, false);
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int sx = this.getX();
        int sy = this.getY();
        int boxScreen = 8;
        if (mouseX >= (double)sx && mouseY >= (double)sy && mouseX < (double)(sx + boxScreen) && mouseY < (double)(sy + boxScreen)) {
            boolean bl = this.selected = !this.selected;
            if (this.onValueChange != null) {
                this.onValueChange.accept(this.selected);
            }
            if (this.selected) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)BossChecklistClient.CHECKMARK_ADDED, (float)1.0f));
            } else {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)BossChecklistClient.CHECKMARK_DELETED, (float)1.0f));
            }
            return true;
        }
        int labelStart = sx + boxScreen + 4;
        int labelLen = (int)((float)Minecraft.getInstance().font.width((FormattedText)this.getMessage()) * 1.0f);
        if (mouseX >= (double)labelStart && mouseY >= (double)sy && mouseX < (double)(labelStart + labelLen) && mouseY < (double)(sy + boxScreen) && this.onLabelClick != null) {
            this.onLabelClick.run();
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }
}

