/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.network;

import com.yori3o.boss_checklist.network.BossDefeatedPacket;
import com.yori3o.boss_checklist.server.BossDefeatedData;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossDefeatServerSend {
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");

    public static void onBossKilled(ServerLevel level, String bossId, String killer) {
        RegistryAccess.Frozen registryAccess = level.getServer().registryAccess();
        FriendlyByteBuf originalBuf = new FriendlyByteBuf(Unpooled.buffer());
        RegistryFriendlyByteBuf registryBuf = new RegistryFriendlyByteBuf((ByteBuf)originalBuf, (RegistryAccess)registryAccess);
        registryBuf.clear();
        registryBuf.writeUtf(bossId + "#" + killer);
        for (ServerPlayer player : level.players()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BossDefeatedPacket.BOSS_DEFEATED_PACKET, (RegistryFriendlyByteBuf)registryBuf);
        }
        BossDefeatedData data = BossDefeatedData.get(level.getServer().overworld());
        data.addBoss(bossId + "#" + killer);
    }
}

