/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.RegisterEvent;

public class PlatformUtils {
    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static void registerPlatform(ResourceLocation id, SoundEvent event) {
        ModSoundsHolder.addSound(id, event);
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.SOUND_EVENT) {
            event.register(Registries.SOUND_EVENT, helper -> {
                for (ModSoundsHolder.SoundEntry entry : ModSoundsHolder.SOUNDS) {
                    helper.register(entry.id, (Object)entry.sound);
                }
            });
        }
    }

    public static class ModSoundsHolder {
        public static final List<SoundEntry> SOUNDS = new ArrayList<SoundEntry>();

        public static void addSound(ResourceLocation id, SoundEvent sound) {
            SOUNDS.add(new SoundEntry(id, sound));
        }

        public record SoundEntry(ResourceLocation id, SoundEvent sound) {
        }
    }
}

