/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.forge;

import com.yori3o.boss_checklist.BossChecklist;
import com.yori3o.boss_checklist.client.data.BossRegistry;
import com.yori3o.boss_checklist.server.BossDefeated;
import com.yori3o.boss_checklist.utils.PlatformUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="boss_checklist")
public class BossChecklistForge {
    private static final BossDefeated BOSS_DEFEATED = new BossDefeated();

    public BossChecklistForge() {
        BossChecklist bossChecklist = new BossChecklist();
        bossChecklist.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        PlatformUtils.SOUND_EVENTS.register(modEventBus);
        modEventBus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDeath);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        BossRegistry.load();
    }

    private void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_()) {
            Entity source = event.getSource().m_7639_();
            String killerName = "";
            if (source instanceof Player) {
                Player player = (Player)source;
                killerName = player.m_7755_().getString();
            }
            BOSS_DEFEATED.EntityKilled(entity, killerName);
        }
    }
}

