/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist;

import com.mojang.blaze3d.platform.InputConstants;
import com.yori3o.boss_checklist.client.ClientResourceReloader;
import com.yori3o.boss_checklist.client.data.ClientDataSaver;
import com.yori3o.boss_checklist.client.gui.BossChecklistScreen;
import com.yori3o.boss_checklist.config.ClientConfig;
import com.yori3o.boss_checklist.network.BossDefeatedClientPacket;
import com.yori3o.boss_checklist.utils.PlatformUtils;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class BossChecklistClient {
    public static final SoundEvent CHECKMARK_ADDED = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"checkmark_added"));
    public static final SoundEvent CHECKMARK_DELETED = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"checkmark_deleted"));
    public static boolean isProgressionMode_dynamic;
    public static boolean isAnimationEnabled_dynamic;
    public static final KeyMapping OPEN_CHECKLIST;

    public static void OnlyClientInit() {
        ClientConfig cc = new ClientConfig();
        cc.load();
        isProgressionMode_dynamic = cc.isProgressionMode();
        isAnimationEnabled_dynamic = cc.isAnimationEnabled();
        BossDefeatedClientPacket.registerPackets();
        PlatformUtils.registerSound(ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"checkmark_added"), CHECKMARK_ADDED);
        PlatformUtils.registerSound(ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"checkmark_deleted"), CHECKMARK_DELETED);
        KeyMappingRegistry.register((KeyMapping)OPEN_CHECKLIST);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            while (OPEN_CHECKLIST.consumeClick()) {
                Minecraft.getInstance().setScreen((Screen)new BossChecklistScreen(false));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
            }
        });
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(level -> Minecraft.getInstance().execute(() -> ClientDataSaver.UpdateCurrentWorldKey()));
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(level -> {
            ClientDataSaver.defeatedBosses_InWorld.clear();
            ClientDataSaver.defeatedBossesIds_InWorld.clear();
        });
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ClientResourceReloader());
    }

    static {
        OPEN_CHECKLIST = new KeyMapping("key.boss_checklist.open_checklist", InputConstants.Type.KEYSYM, 80, "category.boss_checklist");
    }
}

