/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.yori3o.boss_checklist.BossChecklist;
import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.gui.CustomCheckbox;
import com.yori3o.boss_checklist.config.ClientConfig;
import com.yori3o.boss_checklist.config.ServerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ConfigScreen
extends Screen {
    private static final ResourceLocation background_texture = ResourceLocation.fromNamespaceAndPath((String)"boss_checklist", (String)"textures/gui/boss_book.png");
    private boolean skipNextRenderBackground = false;
    private final Screen parent;
    private boolean isLocalServer;
    private ClientConfig Config = new ClientConfig();
    private ServerConfig ServerConfig = new ServerConfig();

    public ConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Config"));
        this.parent = parent;
    }

    public void init() {
        super.init();
        this.isLocalServer = this.minecraft.isLocalServer();
        this.createButtons();
    }

    private void createButtons() {
        int bookX = (this.width - 512) / 2;
        int bookY = (this.height - 256) / 2;
        CustomCheckbox cb = new CustomCheckbox(bookX + 134, bookY + 70, (Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.settings.progression_mode").getString()), BossChecklistClient.isProgressionMode_dynamic, false, false, checked -> {
            this.Config.setProgressionMode((boolean)checked);
            BossChecklistClient.isProgressionMode_dynamic = checked;
        }, () -> {});
        CustomCheckbox cb3 = new CustomCheckbox(bookX + 134, bookY + 90, (Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.settings.animation_enabled").getString()), BossChecklistClient.isAnimationEnabled_dynamic, false, false, checked -> {
            this.Config.setAnimationEnabled((boolean)checked);
            BossChecklistClient.isAnimationEnabled_dynamic = checked;
        }, () -> {});
        this.addRenderableWidget((GuiEventListener)cb);
        this.addRenderableWidget((GuiEventListener)cb3);
        if (this.isLocalServer) {
            CustomCheckbox cb2 = new CustomCheckbox(bookX + 265, bookY + 70, (Component)Component.literal((String)""), BossChecklist.isSaveBossKiller_dynamic, false, false, checked -> {
                this.ServerConfig.setSaveBossKiller((boolean)checked);
                BossChecklist.isSaveBossKiller_dynamic = checked;
            }, () -> {});
            this.addRenderableWidget((GuiEventListener)cb2);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.skipNextRenderBackground = true;
        int bookX = (this.width - 512) / 2;
        int bookY = (this.height - 256) / 2;
        guiGraphics.blit(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.drawString(this.font, "\u00a7l" + Component.translatable((String)"gui.boss_checklist.settings").getString(), bookX + 137, bookY + 53, -16777216, false);
        if (this.isLocalServer) {
            guiGraphics.drawWordWrap(this.font, (FormattedText)Component.literal((String)Component.translatable((String)"gui.boss_checklist.settings.save_boss_killer").getString()), bookX + 277, bookY + 70, 110, -13486792);
        }
        if (mouseX >= bookX + 134 && mouseX < bookX + 134 + 8 && mouseY >= bookY + 70 && mouseY < bookY + 70 + 8) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.settings.progression_mode_desc").getString()), mouseX, mouseY);
        } else if (mouseX >= bookX + 134 && mouseX < bookX + 134 + 8 && mouseY >= bookY + 90 && mouseY < bookY + 90 + 8) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.settings.animation_enabled_desc").getString()), mouseX, mouseY);
        } else if (this.isLocalServer && mouseX >= bookX + 265 && mouseX < bookX + 265 + 8 && mouseY >= bookY + 70 && mouseY < bookY + 70 + 8) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)Component.translatable((String)"gui.boss_checklist.settings.save_boss_killer_desc").getString()), mouseX, mouseY);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistClient.OPEN_CHECKLIST.matches(keyCode, scanCode)) {
            Minecraft.getInstance().setScreen(this.parent);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.skipNextRenderBackground) {
            this.skipNextRenderBackground = false;
            return;
        }
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }
}

