/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.server;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class BossDefeatedData
extends SavedData {
    private static final String DATA_NAME = "boss_checklist_defeated_data";
    private final Set<String> defeatedBosses = new HashSet<String>();

    public Set<String> getDefeatedBosses() {
        return this.defeatedBosses;
    }

    public void addBoss(String lineOfInformation) {
        if (this.defeatedBosses.add(lineOfInformation)) {
            this.setDirty();
        }
    }

    public void removeBoss(String lineOfInformation) {
        HashSet<String> defeatedBossesCopy = new HashSet<String>();
        for (String boss : this.defeatedBosses) {
            String bossId = boss.split("#")[0];
            if (bossId.equals(lineOfInformation.split("#")[0])) continue;
            defeatedBossesCopy.add(boss);
        }
        this.defeatedBosses.clear();
        this.defeatedBosses.addAll(defeatedBossesCopy);
        this.setDirty();
    }

    public BossDefeatedData(HolderLookup.Provider provider) {
    }

    public BossDefeatedData() {
    }

    public static BossDefeatedData load(CompoundTag tag, HolderLookup.Provider provider) {
        BossDefeatedData data = new BossDefeatedData();
        ListTag bossList = tag.getList("DefeatedBosses", 8);
        for (int i = 0; i < bossList.size(); ++i) {
            data.defeatedBosses.add(bossList.getString(i));
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag bossList = new ListTag();
        for (String bossId : this.defeatedBosses) {
            bossList.add((Object)StringTag.valueOf((String)bossId.toString()));
        }
        tag.put("DefeatedBosses", (Tag)bossList);
        return tag;
    }

    public static BossDefeatedData get(ServerLevel level) {
        DimensionDataStorage storage = level.getServer().overworld().getDataStorage();
        SavedData.Factory factory = new SavedData.Factory(BossDefeatedData::new, BossDefeatedData::load, null);
        return (BossDefeatedData)storage.computeIfAbsent(factory, DATA_NAME);
    }
}

