/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yori3o.boss_checklist.PlatformUtils;
import com.yori3o.boss_checklist.client.gui.CustomButton;
import com.yori3o.boss_checklist.data.BossData;
import com.yori3o.boss_checklist.data.BossDataSaver;
import com.yori3o.boss_checklist.data.BossRegistry;
import com.yori3o.boss_checklist.init.BossChecklistKeyMapping;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossInfoScreen
extends Screen {
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final ResourceLocation background_texture = new ResourceLocation("boss_checklist", "textures/gui/boss_book.png");
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("boss_checklist", "textures/gui/button.png");
    private static final ResourceLocation BUTTON_TEXTURE_hovered = new ResourceLocation("boss_checklist", "textures/gui/button_hovered.png");
    private static final ResourceLocation BUTTON_TEXTURE_pressed = new ResourceLocation("boss_checklist", "textures/gui/button_pressed.png");
    private static final ResourceLocation BOOKMARK = new ResourceLocation("boss_checklist", "textures/gui/bookmark.png");
    private static final ResourceLocation BOOKMARK_NOT_DEFEATED = new ResourceLocation("boss_checklist", "textures/gui/bookmark_not_defeated.png");
    private static final ResourceLocation BOOKMARK_DEFEATED = new ResourceLocation("boss_checklist", "textures/gui/bookmark_defeated.png");
    private static final ResourceLocation BOOKMARK_INFO = new ResourceLocation("boss_checklist", "textures/gui/bookmark_info.png");
    private static ResourceLocation BOSS;
    private boolean brokenBossModel = false;
    private boolean bossNameIsBig = false;
    private Component summonText;
    private int bossYCorrection;
    private boolean dropsAreLoaded = false;
    private final Screen parent;
    private final String bossId;
    private final BossData boss;
    private final String bossName;
    private final String modName;
    private CustomButton dropButton;
    private CustomButton spawnButton;
    private InfoTab currentTab = InfoTab.NONE;
    private int dropSpacing = 22;
    private int perRow = 5;
    private String itemid;
    private String dropChance;
    private Boolean chance;
    private float rotationY = 0.0f;
    private float rotationX = 0.0f;
    private boolean dragging = false;
    private static final float MOUSE_SENS = 0.7f;
    private boolean allowRotation = true;
    private LivingEntity entity;
    private int bossScale;
    private boolean isBossDefeated_InWorld = false;
    private boolean isLocalServer = false;
    private int boss_health;
    private double boss_armor;
    private boolean additionalInfo = false;
    private EntityRenderDispatcher dispatcher;
    private MultiBufferSource.BufferSource buffer;
    private List<Component> tooltip = new ArrayList<Component>();
    private List<Component> tooltip2 = new ArrayList<Component>();
    private List<String> drops = new ArrayList<String>();

    public static LivingEntity createEntityFromId(String id) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation rl = new ResourceLocation(id);
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(rl);
        if (type == null) {
            throw new IllegalArgumentException("Not found EntityType by id: " + id);
        }
        Entity entity = type.m_20615_((Level)mc.f_91073_);
        return (LivingEntity)entity;
    }

    public BossInfoScreen(Screen parent, String bossId) {
        super((Component)Component.m_237113_((String)"Boss Info"));
        this.parent = parent;
        this.bossId = bossId;
        this.boss = BossRegistry.get(bossId);
        this.bossName = Component.m_237115_((String)("boss_checklist.boss." + bossId)).getString();
        this.modName = Component.m_237115_((String)("boss_checklist.mod." + this.boss.getModId())).getString();
    }

    public void m_7856_() {
        super.m_7856_();
        this.bossScale = this.boss.getScale();
        this.summonText = Component.m_237115_((String)("boss_checklist.summon." + this.bossId));
        this.entity = BossInfoScreen.createEntityFromId(this.boss.getModId() + ":" + this.bossId);
        this.boss_health = (int)this.entity.m_21133_(Attributes.f_22276_);
        this.boss_armor = (int)this.entity.m_21133_(Attributes.f_22284_);
        this.dispatcher = Minecraft.m_91087_().m_91290_();
        this.buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        this.isLocalServer = Minecraft.m_91087_().m_91090_();
        this.isBossDefeated_InWorld = BossDataSaver.defeatedBosses_InWorld.contains(this.bossId);
        if ("block_factorys_bosses".equals(this.boss.getModId()) || "void_blossom".equals(this.bossId) || "obsidilith".equals(this.bossId) || "gauntlet".equals(this.bossId)) {
            BOSS = new ResourceLocation("boss_checklist", "textures/gui/bosses/" + this.bossId + ".png");
            this.brokenBossModel = true;
        }
        if ("sculptor".equals(this.bossId) || "frostmaw".equals(this.bossId) || "malkuth".equals(this.bossId) || "chesed".equals(this.bossId)) {
            this.additionalInfo = true;
        }
        if (Minecraft.m_91087_().f_91062_.m_92895_(this.bossName) > 95) {
            this.bossNameIsBig = true;
        }
        this.bossYCorrection = this.boss.getYOffset();
        if (!this.dropsAreLoaded) {
            for (String dropId : this.boss.getDrops()) {
                String modId_fromDrop = dropId.split(":")[0];
                if (!PlatformUtils.isModLoaded(modId_fromDrop)) continue;
                this.drops.add(dropId);
            }
            this.dropsAreLoaded = true;
        }
        this.tooltip.clear();
        this.tooltip2.clear();
        this.tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"gui.boss_checklist.health").getString() + this.boss_health)));
        this.tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"gui.boss_checklist.armor").getString() + this.boss_armor)));
        this.tooltip2.add((Component)Component.m_237113_((String)Component.m_237115_((String)"gui.boss_checklist.not_defeated").getString()));
        this.tooltip2.add((Component)Component.m_237113_((String)Component.m_237115_((String)"gui.boss_checklist.server_warning").getString()));
        this.createButtons();
    }

    private void createButtons() {
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        this.dropButton = new CustomButton(bookX + 265, bookY + 51, 50, 18, (Component)Component.m_237115_((String)"gui.boss_checklist.drop"), BUTTON_TEXTURE, BUTTON_TEXTURE_hovered, BUTTON_TEXTURE_pressed, () -> {
            this.currentTab = InfoTab.DROP;
        });
        this.spawnButton = new CustomButton(bookX + 328, bookY + 51, 50, 18, (Component)Component.m_237115_((String)"gui.boss_checklist.spawn_info"), BUTTON_TEXTURE, BUTTON_TEXTURE_hovered, BUTTON_TEXTURE_pressed, () -> {
            this.currentTab = InfoTab.SPAWN;
        });
        this.m_142416_((GuiEventListener)this.dropButton);
        this.m_142416_((GuiEventListener)this.spawnButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int bookX = (this.f_96543_ - 512) / 2;
        int bookY = (this.f_96544_ - 256) / 2;
        if (this.allowRotation) {
            this.rotationY += 0.5f * partialTick;
        }
        guiGraphics.m_280163_(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.m_280163_(BOOKMARK, bookX + 145, bookY + 210, 0.0f, 0.0f, 16, 27, 16, 27);
        if (this.isBossDefeated_InWorld) {
            guiGraphics.m_280163_(BOOKMARK_DEFEATED, bookX + 172, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        } else {
            guiGraphics.m_280163_(BOOKMARK_NOT_DEFEATED, bookX + 172, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        }
        if (this.additionalInfo) {
            guiGraphics.m_280163_(BOOKMARK_INFO, bookX + 199, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        }
        if (this.bossNameIsBig) {
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)("\u00a7l" + this.bossName)), bookX + 137, bookY + 53, 110, -16777216);
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)this.modName), bookX + 137, bookY + 73, 110, -10395295);
        } else {
            guiGraphics.m_280056_(this.f_96547_, "\u00a7l" + this.bossName, bookX + 137, bookY + 53, -16777216, false);
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)this.modName), bookX + 137, bookY + 65, 110, -10395295);
        }
        if (this.currentTab == InfoTab.DROP) {
            this.renderDrops(guiGraphics, mouseX, mouseY, bookX + 265, bookY + 80);
        } else if (this.currentTab == InfoTab.SPAWN) {
            this.renderSummon(guiGraphics, bookX + 265, bookY + 80);
        }
        if (this.brokenBossModel) {
            guiGraphics.m_280163_(BOSS, bookX + 137, bookY + 100, 0.0f, 0.0f, 100, 100, 100, 100);
        } else {
            this.renderEntityInGui(guiGraphics, bookX + 132 + 56, bookY + 90 + 85, this.bossScale, partialTick);
        }
        if (mouseX >= bookX + 145 && mouseX < bookX + 145 + 16 && mouseY >= bookY + 209 && mouseY < bookY + 209 + 27) {
            guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, this.tooltip, mouseX, mouseY);
        }
        if (this.additionalInfo && mouseX >= bookX + 199 && mouseX < bookX + 199 + 16 && mouseY >= bookY + 210 && mouseY < bookY + 210 + 27) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)Component.m_237115_((String)("gui.boss_checklist.info_" + this.bossId)).getString()), mouseX, mouseY);
        }
        if (mouseX >= bookX + 172 && mouseX < bookX + 172 + 16 && mouseY >= bookY + 210 && mouseY < bookY + 210 + 27) {
            if (this.isBossDefeated_InWorld) {
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)Component.m_237115_((String)"gui.boss_checklist.defeated").getString()), mouseX, mouseY);
            } else if (this.isLocalServer) {
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)Component.m_237115_((String)"gui.boss_checklist.not_defeated").getString()), mouseX, mouseY);
            } else {
                guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, this.tooltip2, mouseX, mouseY);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderDrops(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (this.drops == null || this.drops.isEmpty()) {
            guiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.boss_checklist.no_drop").getString(), x, y, -10395295, false);
            return;
        }
        int i = 0;
        for (String id : this.drops) {
            int row = i / this.perRow;
            int col = i % this.perRow;
            int xPos = x + col * this.dropSpacing;
            int yPos = y + row * this.dropSpacing;
            if (id.split("#").length > 1) {
                this.itemid = id.split("#")[0];
                this.dropChance = id.split("#")[1];
                this.chance = true;
            } else {
                this.itemid = id.split("#")[0];
                this.chance = false;
            }
            ResourceLocation loc = new ResourceLocation(this.itemid);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(loc);
            ItemStack stack = new ItemStack((ItemLike)item);
            guiGraphics.m_280480_(stack, xPos, yPos);
            if (this.chance.booleanValue()) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                guiGraphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
                guiGraphics.m_280056_(this.f_96547_, this.dropChance + "%", (int)((double)xPos / 0.75 + 4.0), (int)((double)yPos / 0.75 + 22.0), -10395295, false);
                guiGraphics.m_280168_().m_85849_();
            }
            if (mouseX >= xPos && mouseX <= xPos + 16 && mouseY >= yPos && mouseY <= yPos + 16) {
                guiGraphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
            }
            ++i;
        }
    }

    private void renderSummon(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)this.summonText, x, y, 117, 0);
    }

    public void renderEntityInGui(GuiGraphics graphics, int x, int y, int scale, float partialTicks) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        this.entity.f_19797_ = 0;
        poseStack.m_252880_((float)x, (float)(y + this.bossYCorrection), 100.0f);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_252880_(0.0f, -this.entity.m_20206_() / 2.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rotationX + 180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-this.rotationY + 180.0f));
        this.dispatcher.m_114384_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, (MultiBufferSource)this.buffer, 0xF000F0);
        this.buffer.m_109911_();
        poseStack.m_85849_();
    }

    private boolean isMouseOverBoss(double mouseX, double mouseY) {
        return mouseX >= (double)((this.f_96543_ - 512) / 2 + 135) && mouseX <= (double)((this.f_96543_ - 512) / 2 + 135 + 110) && mouseY >= (double)((this.f_96544_ - 256) / 2 + 90) && mouseY <= (double)((this.f_96544_ - 256) / 2 + 90 + 110);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOverBoss(mouseX, mouseY)) {
            this.dragging = true;
            this.allowRotation = false;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == 0) {
            this.rotationY += (float)(dragX * (double)0.7f);
            this.rotationX -= (float)(dragY * (double)0.7f);
            this.rotationX = Mth.m_14036_((float)this.rotationX, (float)-75.0f, (float)75.0f);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            this.allowRotation = true;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistKeyMapping.OPEN_CHECKLIST.m_90832_(keyCode, scanCode)) {
            Minecraft.m_91087_().m_91152_(this.parent);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private static enum InfoTab {
        NONE,
        DROP,
        SPAWN;

    }
}

