/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossDataSaver {
    private static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DATA_FOLDER_NAME = "boss\u0421hecklist_data";
    private static final String JSON_FILE_NAME = "defeated_bosses.json";
    public static List<String> defeatedBosses_InWorld = new ArrayList<String>();
    private static String worldKey;

    public void BossDefeated(String bossId, Boolean bool) {
        File dataFolder = new File(Minecraft.m_91087_().f_91069_, DATA_FOLDER_NAME + File.separator + worldKey);
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            LOGGER.error("Failed to create data folder for world key: " + worldKey);
            return;
        }
        File jsonFile = new File(dataFolder, JSON_FILE_NAME);
        List<String> defeatedBosses = new ArrayList<String>();
        if (jsonFile.exists()) {
            try (FileReader reader = new FileReader(jsonFile);){
                Type listType = new TypeToken<List<String>>(){}.getType();
                defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
                if (defeatedBosses == null) {
                    defeatedBosses = new ArrayList();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (bool.booleanValue()) {
            if (!defeatedBosses.contains(bossId)) {
                defeatedBosses.add(bossId);
                try {
                    writer = new FileWriter(jsonFile);
                    try {
                        GSON.toJson(defeatedBosses, (Appendable)writer);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write to JSON file " + jsonFile.getAbsolutePath(), (Throwable)e);
                }
            }
        } else if (defeatedBosses.contains(bossId)) {
            defeatedBosses.remove(bossId);
            try {
                writer = new FileWriter(jsonFile);
                try {
                    GSON.toJson(defeatedBosses, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to write to JSON file " + jsonFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean isBossDefeated(String bossId) {
        File jsonFile = new File(Minecraft.m_91087_().f_91069_, DATA_FOLDER_NAME + File.separator + worldKey + File.separator + JSON_FILE_NAME);
        if (!jsonFile.exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(jsonFile);){
            Type listType = new TypeToken<List<String>>(){}.getType();
            List defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
            if (defeatedBosses == null) return false;
            Boolean bl = defeatedBosses.contains(bossId);
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
        }
        return false;
    }

    public static void UpdateCurrentWorldKey() {
        ServerData serverData;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91090_()) {
            worldKey = "singleplayer_" + minecraft.m_91092_().m_129843_(LevelResource.f_78182_).normalize().getFileName().toString();
            return;
        }
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener != null && (serverData = clientPacketListener.m_245416_()) != null) {
            worldKey = "multiplayer_" + serverData.f_105363_.replace(":", "_");
            return;
        }
        worldKey = "BROKEN_WORLD_KEY";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int defeatedBossesCount() {
        File jsonFile = new File(Minecraft.m_91087_().f_91069_, DATA_FOLDER_NAME + File.separator + worldKey + File.separator + JSON_FILE_NAME);
        if (!jsonFile.exists()) {
            return 0;
        }
        try (FileReader reader = new FileReader(jsonFile);){
            Type listType = new TypeToken<List<String>>(){}.getType();
            List defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
            if (defeatedBosses == null) return 0;
            int n = defeatedBosses.size();
            return n;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
        }
        return 0;
    }
}

