/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yori3o.boss_checklist.network.BossDefeatHandler;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BossDefeated {
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final ResourceLocation JSON_RL = new ResourceLocation("boss_checklist", "server_bosses_ids.json");
    private static final Gson GSON = new Gson();
    private static final Set<String> BOSSES = new HashSet<String>();

    public static void load(MinecraftServer server) {
        block13: {
            BOSSES.clear();
            ResourceManager rm = server.m_177941_();
            try {
                Optional resOpt = rm.m_213713_(JSON_RL);
                if (!resOpt.isPresent()) break block13;
                try (InputStreamReader reader = new InputStreamReader(((Resource)resOpt.get()).m_215507_());){
                    JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                    if (root.isJsonArray()) {
                        for (JsonElement el : root.getAsJsonArray()) {
                            JsonObject obj;
                            if (!el.isJsonObject() || !(obj = el.getAsJsonObject()).has("id")) continue;
                            try {
                                BOSSES.add(obj.get("id").getAsString());
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean isBoss(String bossId) {
        try {
            return BOSSES.contains(bossId);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void EntityKilled(LivingEntity entity) {
        String bossId;
        EntityType type = entity.m_6095_();
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)type);
        ServerLevel level = (ServerLevel)entity.m_9236_();
        if (id != null && BossDefeated.isBoss(bossId = id.toString().split(":")[1])) {
            BossDefeatHandler.onBossKilled(level, bossId);
        }
    }
}

