/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.gui.BossInfoScreen;
import com.yori3o.boss_checklist.client.gui.CustomCheckbox;
import com.yori3o.boss_checklist.client.gui.CustomPageButton;
import com.yori3o.boss_checklist.client.gui.TextUtil;
import com.yori3o.boss_checklist.data.BossData;
import com.yori3o.boss_checklist.data.BossDataClientSaver;
import com.yori3o.boss_checklist.data.BossRegistry;
import com.yori3o.boss_checklist.init.BossChecklistKeyMapping;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossChecklistScreen
extends class_437 {
    private static final BossDataClientSaver DATA_SAVER = new BossDataClientSaver();
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final class_2960 bar_background = new class_2960("boss_checklist", "textures/gui/white_background.png");
    private static final class_2960 bar_progress = new class_2960("boss_checklist", "textures/gui/white_progress.png");
    private static final class_2960 background_texture = new class_2960("boss_checklist", "textures/gui/boss_book.png");
    private static final int ELEMENTS_PER_PAGE = 7;
    private int currentSpread = 0;
    private int maxTextWidth = 95;
    private List<BossData> bossDataList = new ArrayList<BossData>();
    private List<CustomCheckbox> currentCheckboxes = new ArrayList<CustomCheckbox>();
    private CustomPageButton nextButton;
    private CustomPageButton prevButton;
    private int leftPage;
    private int rightPage;
    private boolean noBossesLoaded = false;
    private boolean bossesListAreLoaded = false;
    private List<class_2561> bosses = new ArrayList<class_2561>();
    private List<String> bossIds = new ArrayList<String>();
    private int defeatedCount;
    private int totalCount;
    private float percent;

    public BossChecklistScreen() {
        super((class_2561)class_2561.method_43470((String)"Checklist"));
    }

    public void method_25426() {
        super.method_25426();
        if (!this.bossesListAreLoaded) {
            this.bossesListAreLoaded = true;
            this.bossDataList = BossRegistry.all().stream().toList();
            this.bossIds.addAll(BossRegistry.all().stream().map(BossData::getId).toList());
            for (BossData b : this.bossDataList) {
                if (BossChecklistClient.hideUndefeatedBossInfo.booleanValue() && !BossDataClientSaver.defeatedBossesIds_InWorld.contains(b.getId())) {
                    this.bosses.add((class_2561)class_2561.method_43470((String)"???"));
                    continue;
                }
                String translated = class_2561.method_43471((String)("boss_checklist.boss." + b.getId().replace(":", "_"))).getString();
                String truncated = TextUtil.truncateText(translated, this.maxTextWidth).getString();
                this.bosses.add((class_2561)class_2561.method_43470((String)truncated));
            }
        }
        this.updateCounts();
        this.createPageButtons();
        this.updatePage();
    }

    private void updateCounts() {
        this.defeatedCount = DATA_SAVER.defeatedBossesCount();
        this.totalCount = this.bossIds.size();
        this.percent = this.totalCount > 0 ? (float)this.defeatedCount / (float)this.totalCount : 0.0f;
    }

    private void createPageButtons() {
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        double totalPages = Math.ceil((double)this.bosses.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        this.prevButton = new CustomPageButton(bookX + 138, bookY + 190, true, () -> {
            if (this.currentSpread > 0) {
                --this.currentSpread;
                this.updatePage();
            }
        });
        this.nextButton = new CustomPageButton(bookX + 350, bookY + 190, false, () -> {
            if (this.currentSpread < totalSpreads - 1) {
                ++this.currentSpread;
                this.updatePage();
            }
        });
        this.method_37063((class_364)this.prevButton);
        this.method_37063((class_364)this.nextButton);
    }

    private void updatePage() {
        if (this.bosses.isEmpty()) {
            LOGGER.warn("No bosses loaded at checklist!");
            this.prevButton.field_22764 = false;
            this.nextButton.field_22764 = false;
            this.noBossesLoaded = true;
            return;
        }
        for (CustomCheckbox cb : this.currentCheckboxes) {
            this.method_37066((class_364)cb);
        }
        this.currentCheckboxes.clear();
        double totalPages = Math.ceil((double)this.bosses.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        int fromIndex = this.currentSpread * 14;
        int toIndex = Math.min(fromIndex + 14, this.bosses.size());
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        int leftX = bookX + 134;
        int rightX = bookX + 266;
        int startY = bookY + 56;
        for (int i = fromIndex; i < toIndex; ++i) {
            String boss = this.bosses.get(i).getString();
            String bossId = this.bossIds.get(i);
            int localIndex = i - fromIndex;
            int x = localIndex < 7 ? leftX : rightX;
            int y = startY + localIndex % 7 * 18;
            CustomCheckbox cb = new CustomCheckbox(x, y, (class_2561)class_2561.method_43470((String)boss), DATA_SAVER.isBossDefeated(bossId), checked -> {
                BossDataClientSaver.BossDefeated(bossId, checked);
                this.updateCounts();
            }, () -> class_310.method_1551().method_1507((class_437)new BossInfoScreen(this, bossId)));
            this.method_37063((class_364)cb);
            this.currentCheckboxes.add(cb);
        }
        this.prevButton.field_22764 = this.currentSpread > 0;
        this.nextButton.field_22764 = this.currentSpread < totalSpreads - 1;
        this.leftPage = this.currentSpread * 2 + 1;
        this.rightPage = this.currentSpread * 2 + 2;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        guiGraphics.method_25290(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.method_25290(bar_background, bookX + 165, bookY + 29, 0.0f, 0.0f, 182, 5, 182, 5);
        guiGraphics.method_25290(bar_progress, bookX + 165, bookY + 29, 0.0f, 0.0f, (int)(this.percent * 182.0f), 5, 182, 5);
        guiGraphics.method_51433(this.field_22793, this.defeatedCount + " / " + this.totalCount, (this.field_22789 - class_310.method_1551().field_1772.method_1727(this.defeatedCount + " / " + this.totalCount)) / 2, bookY + 20, 0xFFFFFF, false);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.noBossesLoaded) {
            guiGraphics.method_51433(this.field_22793, "No bosses loaded!", bookX + 140, bookY + 53, 0, false);
        } else {
            guiGraphics.method_51433(this.field_22793, String.valueOf(this.leftPage), bookX + 187, bookY + 195, 0, false);
            guiGraphics.method_51433(this.field_22793, String.valueOf(this.rightPage), bookX + 320, bookY + 195, 0, false);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistKeyMapping.OPEN_CHECKLIST.method_1417(keyCode, scanCode)) {
            this.field_22787.method_1507(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

