/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.data.BossData;
import com.yori3o.boss_checklist.client.data.BossRegistry;
import com.yori3o.boss_checklist.client.data.ClientDataSaver;
import com.yori3o.boss_checklist.client.gui.CustomButton;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_898;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossInfoScreen
extends class_437 {
    public static final Logger LOGGER = LogManager.getLogger((String)"boss_checklist");
    private static final class_2960 background_texture = new class_2960("boss_checklist", "textures/gui/boss_book.png");
    private static final class_2960 BUTTON_TEXTURE = new class_2960("boss_checklist", "textures/gui/button.png");
    private static final class_2960 BUTTON_TEXTURE_hovered = new class_2960("boss_checklist", "textures/gui/button_hovered.png");
    private static final class_2960 BUTTON_TEXTURE_pressed = new class_2960("boss_checklist", "textures/gui/button_pressed.png");
    private static final class_2960 BUTTON_TEXTURE_overlay = new class_2960("boss_checklist", "textures/gui/button_overlay.png");
    private static final class_2960 BOOKMARK = new class_2960("boss_checklist", "textures/gui/bookmark.png");
    private static final class_2960 BOOKMARK_NOT_DEFEATED = new class_2960("boss_checklist", "textures/gui/bookmark_not_defeated.png");
    private static final class_2960 BOOKMARK_DEFEATED = new class_2960("boss_checklist", "textures/gui/bookmark_defeated.png");
    private static final class_2960 BOOKMARK_INFO = new class_2960("boss_checklist", "textures/gui/bookmark_info.png");
    private static final class_2960 BOOKMARK_WIKI = new class_2960("boss_checklist", "textures/gui/bookmark_wiki.png");
    private static final int DropButtonX = 265;
    private static final int DropButtonY = 51;
    private static final int SpawnButtonX = 328;
    private static final int SpawnButtonY = 51;
    private static final int ButtonsHeight = 18;
    private static final int ButtonsWidth = 50;
    private static final int ButtonsOverlayHeight = 40;
    private static final int ButtonsOverlayWidth = 70;
    private static class_2960 BOSS_IMG;
    private boolean brokenBossModel = false;
    private boolean bossNameIsBig = false;
    private class_2561 summonText;
    private int bossYCorrection;
    private boolean dropsAreLoaded = false;
    private final class_437 parent;
    private final String bossId;
    private final BossData boss;
    private String bossName;
    private String modName;
    private CustomButton dropButton;
    private CustomButton spawnButton;
    private InfoTab currentTab = InfoTab.NONE;
    private int dropSpacing = 22;
    private int perRow = 5;
    private String itemid;
    private String dropChance;
    private Boolean chance;
    private long lastTime;
    private float rotationY = 0.0f;
    private float rotationX = 0.0f;
    private boolean dragging = false;
    private static final float MOUSE_SENS = 0.7f;
    private boolean allowRotation = true;
    private class_1309 entity;
    private int bossScale;
    private boolean isBossDefeated_InWorld = false;
    private boolean isLocalServerOrAnyoneBossKilled = false;
    private int boss_health;
    private double boss_armor;
    private boolean additionalInfo = false;
    private boolean showInfo = true;
    private boolean wiki_link_enabled = false;
    private String wiki_link = "";
    private boolean showSpawnInfo = true;
    private class_898 dispatcher;
    private class_4597.class_4598 buffer;
    private List<class_2561> tooltip = new ArrayList<class_2561>();
    private List<class_2561> tooltip2 = new ArrayList<class_2561>();
    private List<class_2561> tooltip3 = new ArrayList<class_2561>();
    private List<String> drops = new ArrayList<String>();

    public static class_1309 createEntityFromId(String id) {
        class_310 mc = class_310.method_1551();
        class_2960 rl = new class_2960(id);
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(rl);
        if (type == null) {
            throw new IllegalArgumentException("Not found EntityType by id: " + id);
        }
        class_1297 entity = type.method_5883((class_1937)mc.field_1687);
        return (class_1309)entity;
    }

    public BossInfoScreen(class_437 parent, String bossId) {
        super((class_2561)class_2561.method_43470((String)"Boss Info"));
        this.lastTime = System.nanoTime();
        this.parent = parent;
        this.bossId = bossId;
        this.boss = BossRegistry.get(bossId);
        if (bossId.equals("minecraft:wither")) {
            this.modName = Platform.isModLoaded((String)"witherreincarnated") ? class_2561.method_43471((String)"boss_checklist.mod.witherreincarnated").getString() : class_2561.method_43471((String)("boss_checklist.mod." + this.boss.getModId())).getString();
        }
        this.modName = bossId.equals("minecraft:ender_dragon") ? (Platform.isModLoaded((String)"endertrigon") ? class_2561.method_43471((String)"boss_checklist.mod.endertrigon").getString() : class_2561.method_43471((String)("boss_checklist.mod." + this.boss.getModId())).getString()) : class_2561.method_43471((String)("boss_checklist.mod." + this.boss.getModId())).getString();
        this.bossName = class_2561.method_43471((String)("boss_checklist.boss." + bossId.replace(":", "_"))).getString();
    }

    public void method_25426() {
        super.method_25426();
        this.bossScale = this.boss.getScale();
        this.bossYCorrection = this.boss.getYOffset();
        this.entity = BossInfoScreen.createEntityFromId(this.bossId);
        this.boss_health = this.boss.getHealth() == -1.0f ? (int)this.entity.method_26825(class_5134.field_23716) : (int)this.boss.getHealth();
        this.boss_armor = this.boss.getArmor() == -1.0f ? (double)((int)this.entity.method_26825(class_5134.field_23724)) : (double)((int)this.boss.getArmor());
        this.dispatcher = class_310.method_1551().method_1561();
        this.buffer = class_310.method_1551().method_22940().method_23000();
        this.isBossDefeated_InWorld = ClientDataSaver.defeatedBossesIds_InWorld.contains(this.bossId);
        boolean bl = this.isLocalServerOrAnyoneBossKilled = ClientDataSaver.defeatedBossesIds_InWorld.size() > 0 || class_310.method_1551().method_1542();
        if (this.isBossDefeated_InWorld) {
            String killerName = ClientDataSaver.whoKiller(this.bossId);
            this.tooltip3.clear();
            if (killerName.length() == 0) {
                this.tooltip3.add((class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"gui.boss_checklist.defeated").getString()));
            } else {
                this.tooltip3.add((class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"gui.boss_checklist.defeated").getString()));
                this.tooltip3.add((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"gui.boss_checklist.killer_name").getString() + killerName)));
            }
        }
        if (BossChecklistClient.isProgressionMode_dynamic && !this.isBossDefeated_InWorld) {
            this.showInfo = false;
            this.bossName = "???";
            if (BossChecklistClient.isProgressionModePlus_dynamic) {
                this.showSpawnInfo = false;
                this.modName = "???";
                this.wiki_link = "";
                this.additionalInfo = false;
            }
        }
        this.summonText = class_2561.method_43471((String)("boss_checklist.summon." + this.bossId.replace(":", "_")));
        if (this.boss.isBrokenModel().booleanValue()) {
            BOSS_IMG = new class_2960("boss_checklist", "textures/gui/bosses/" + this.bossId.replace(":", "_") + ".png");
            this.brokenBossModel = true;
        }
        this.additionalInfo = this.boss.isAdditionalInfo();
        if (!this.boss.getWikiLink().equals("")) {
            this.wiki_link_enabled = true;
            this.wiki_link = this.boss.getWikiLink();
        }
        boolean bl2 = this.bossNameIsBig = class_310.method_1551().field_1772.method_1727(this.bossName) > 95;
        if (!this.dropsAreLoaded) {
            for (String dropId : this.boss.getDrops()) {
                if (!Platform.isModLoaded((String)dropId.split(":")[0])) continue;
                this.drops.add(dropId);
            }
            if (Platform.isModLoaded((String)"endrem_additions") && this.bossId.equals("bosses_of_mass_destruction:void_blossom")) {
                this.drops.add("endrem:blossom_eye");
            }
            this.dropsAreLoaded = true;
        }
        this.tooltip.clear();
        if (this.showInfo) {
            this.tooltip.add((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"gui.boss_checklist.health").getString() + this.boss_health)));
            this.tooltip.add((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"gui.boss_checklist.armor").getString() + this.boss_armor)));
        } else {
            this.tooltip.add((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"gui.boss_checklist.health").getString() + "?")));
            this.tooltip.add((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"gui.boss_checklist.armor").getString() + "?")));
        }
        this.tooltip2.clear();
        this.tooltip2.add((class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"gui.boss_checklist.not_defeated").getString()));
        this.tooltip2.add((class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"gui.boss_checklist.server_warning").getString()));
        this.createButtons();
    }

    private void createButtons() {
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        this.dropButton = this.showInfo ? new CustomButton(bookX + 265, bookY + 51, 50, 18, 70, 40, (class_2561)class_2561.method_43471((String)"gui.boss_checklist.drop"), BUTTON_TEXTURE, BUTTON_TEXTURE_hovered, BUTTON_TEXTURE_pressed, BUTTON_TEXTURE_overlay, () -> {
            this.currentTab = InfoTab.DROP;
        }) : new CustomButton(bookX + 265, bookY + 51, 50, 18, 70, 40, (class_2561)class_2561.method_43471((String)"gui.boss_checklist.drop"), BUTTON_TEXTURE, BUTTON_TEXTURE, BUTTON_TEXTURE, BUTTON_TEXTURE_overlay, () -> {});
        this.spawnButton = this.showSpawnInfo ? new CustomButton(bookX + 328, bookY + 51, 50, 18, 70, 40, (class_2561)class_2561.method_43471((String)"gui.boss_checklist.spawn_info"), BUTTON_TEXTURE, BUTTON_TEXTURE_hovered, BUTTON_TEXTURE_pressed, BUTTON_TEXTURE_overlay, () -> {
            this.currentTab = InfoTab.SPAWN;
        }) : new CustomButton(bookX + 328, bookY + 51, 50, 18, 70, 40, (class_2561)class_2561.method_43471((String)"gui.boss_checklist.spawn_info"), BUTTON_TEXTURE, BUTTON_TEXTURE, BUTTON_TEXTURE, BUTTON_TEXTURE_overlay, () -> {});
        this.method_37063((class_364)this.dropButton);
        this.method_37063((class_364)this.spawnButton);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        long now = System.nanoTime();
        float delta = (float)(now - this.lastTime) / 1.0E9f;
        this.lastTime = now;
        if (this.allowRotation) {
            this.rotationY += 7.5f * delta;
        }
        guiGraphics.method_25290(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.method_25290(BOOKMARK, bookX + 145, bookY + 210, 0.0f, 0.0f, 16, 27, 16, 27);
        if (this.isBossDefeated_InWorld) {
            guiGraphics.method_25290(BOOKMARK_DEFEATED, bookX + 172, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        } else {
            guiGraphics.method_25290(BOOKMARK_NOT_DEFEATED, bookX + 172, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        }
        if (this.additionalInfo && this.showInfo) {
            guiGraphics.method_25290(BOOKMARK_INFO, bookX + 199, bookY + 209, 0.0f, 0.0f, 16, 27, 16, 27);
        }
        if (this.wiki_link_enabled) {
            guiGraphics.method_25290(BOOKMARK_WIKI, bookX + 350, bookY + 210, 0.0f, 0.0f, 16, 27, 16, 27);
        }
        if (this.bossNameIsBig) {
            guiGraphics.method_51440(this.field_22793, (class_5348)class_2561.method_43470((String)("\u00a7l" + this.bossName)), bookX + 137, bookY + 53, 110, -16777216);
            guiGraphics.method_51440(this.field_22793, (class_5348)class_2561.method_43470((String)this.modName), bookX + 137, bookY + 73, 110, -10395295);
        } else {
            guiGraphics.method_51433(this.field_22793, "\u00a7l" + this.bossName, bookX + 137, bookY + 53, -16777216, false);
            guiGraphics.method_51440(this.field_22793, (class_5348)class_2561.method_43470((String)this.modName), bookX + 137, bookY + 65, 110, -10395295);
        }
        if (this.showInfo) {
            if (this.brokenBossModel) {
                guiGraphics.method_25290(BOSS_IMG, bookX + 137, bookY + 100, 0.0f, 0.0f, 100, 100, 100, 100);
            } else {
                this.renderEntityInGui(guiGraphics, bookX + 132 + 56, bookY + 90 + 85, this.bossScale, partialTick);
            }
        }
        if (mouseX >= bookX + 145 && mouseX < bookX + 145 + 16 && mouseY >= bookY + 209 && mouseY < bookY + 209 + 27) {
            guiGraphics.method_51434(class_310.method_1551().field_1772, this.tooltip, mouseX, mouseY);
        } else {
            if (this.additionalInfo && this.showInfo && mouseX >= bookX + 199 && mouseX < bookX + 199 + 16 && mouseY >= bookY + 210 && mouseY < bookY + 210 + 27) {
                guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)class_2561.method_43471((String)("gui.boss_checklist.info_" + this.bossId.replace(":", "_"))).getString()), mouseX, mouseY);
            }
            if (mouseX >= bookX + 172 && mouseX < bookX + 172 + 16 && mouseY >= bookY + 210 && mouseY < bookY + 210 + 27) {
                if (this.isBossDefeated_InWorld) {
                    guiGraphics.method_51434(class_310.method_1551().field_1772, this.tooltip3, mouseX, mouseY);
                } else if (this.isLocalServerOrAnyoneBossKilled) {
                    guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"gui.boss_checklist.not_defeated").getString()), mouseX, mouseY);
                } else {
                    guiGraphics.method_51434(class_310.method_1551().field_1772, this.tooltip2, mouseX, mouseY);
                }
            } else if (this.wiki_link_enabled && mouseX >= bookX + 350 && mouseX < bookX + 350 + 16 && mouseY >= bookY + 210 && mouseY < bookY + 210 + 27) {
                guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"gui.boss_checklist.wiki_link_info").getString()), mouseX, mouseY);
            }
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.currentTab == InfoTab.DROP) {
            this.renderDrops(guiGraphics, mouseX, mouseY, bookX + 265, bookY + 80);
        } else if (this.currentTab == InfoTab.SPAWN) {
            guiGraphics.method_51440(this.field_22793, (class_5348)this.summonText, bookX + 265, bookY + 80, 117, 0);
        }
        if (!this.showInfo) {
            guiGraphics.method_25294(bookX + 265, bookY + 51, bookX + 265 + 50, bookY + 51 + 18, -2002081110);
            if (!this.showSpawnInfo) {
                guiGraphics.method_25294(bookX + 328, bookY + 51, bookX + 328 + 50, bookY + 51 + 18, -2002081110);
            }
        }
    }

    private void renderDrops(class_332 guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (this.drops == null || this.drops.isEmpty()) {
            guiGraphics.method_51433(this.field_22793, class_2561.method_43471((String)"gui.boss_checklist.no_drop").getString(), x, y, -10395295, false);
            return;
        }
        int i = 0;
        for (String id : this.drops) {
            int row = i / this.perRow;
            int col = i % this.perRow;
            int xPos = x + col * this.dropSpacing;
            int yPos = y + row * this.dropSpacing;
            if (id.split("#").length > 1) {
                this.itemid = id.split("#")[0];
                this.dropChance = id.split("#")[1];
                this.chance = true;
            } else {
                this.itemid = id.split("#")[0];
                this.chance = false;
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(this.itemid));
            class_1799 stack = new class_1799((class_1935)item);
            guiGraphics.method_51427(stack, xPos, yPos);
            if (this.chance.booleanValue()) {
                class_4587 poseStack = guiGraphics.method_51448();
                poseStack.method_22903();
                guiGraphics.method_51448().method_22905(0.75f, 0.75f, 1.0f);
                guiGraphics.method_51433(this.field_22793, this.dropChance + "%", (int)((double)xPos / 0.75 + 4.0), (int)((double)yPos / 0.75 + 22.0), -10395295, false);
                guiGraphics.method_51448().method_22909();
            }
            if (mouseX >= xPos && mouseX <= xPos + 16 && mouseY >= yPos && mouseY <= yPos + 16) {
                guiGraphics.method_51446(this.field_22793, stack, mouseX, mouseY);
            }
            ++i;
        }
    }

    public void renderEntityInGui(class_332 graphics, int x, int y, int scale, float partialTicks) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)x, (float)(y + this.bossYCorrection), 100.0f);
        poseStack.method_22905((float)scale, (float)scale, (float)scale);
        poseStack.method_46416(0.0f, -this.entity.method_17682() / 2.0f, 0.0f);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(this.rotationX + 180.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-this.rotationY + 180.0f));
        this.dispatcher.method_3954((class_1297)this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (class_4597)this.buffer, 0xF000F0);
        this.buffer.method_22993();
        poseStack.method_22909();
    }

    private boolean isMouseOverBoss(double mouseX, double mouseY) {
        return mouseX >= (double)((this.field_22789 - 512) / 2 + 135) && mouseX <= (double)((this.field_22789 - 512) / 2 + 135 + 110) && mouseY >= (double)((this.field_22790 - 256) / 2 + 90) && mouseY <= (double)((this.field_22790 - 256) / 2 + 90 + 110);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOverBoss(mouseX, mouseY)) {
            this.dragging = true;
            this.allowRotation = false;
            return true;
        }
        if (this.wiki_link_enabled && mouseX >= (double)((this.field_22789 - 512) / 2 + 350) && mouseX <= (double)((this.field_22789 - 512) / 2 + 350 + 16) && mouseY >= (double)((this.field_22790 - 256) / 2 + 210) && mouseY <= (double)((this.field_22790 - 256) / 2 + 210 + 27)) {
            this.field_22787.method_1507((class_437)new class_407(confirmed -> {
                if (confirmed) {
                    class_156.method_668().method_670(this.wiki_link);
                }
                this.field_22787.method_1507((class_437)this);
            }, this.wiki_link, true));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == 0) {
            this.rotationY += (float)(dragX * (double)0.7f);
            this.rotationX -= (float)(dragY * (double)0.7f);
            this.rotationX = class_3532.method_15363((float)this.rotationX, (float)-75.0f, (float)75.0f);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            this.allowRotation = true;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistClient.OPEN_CHECKLIST.method_1417(keyCode, scanCode)) {
            class_310.method_1551().method_1507(this.parent);
            return true;
        }
        if (keyCode == 263) {
            if (this.showInfo) {
                this.currentTab = InfoTab.DROP;
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.showSpawnInfo) {
                this.currentTab = InfoTab.SPAWN;
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private static enum InfoTab {
        NONE,
        DROP,
        SPAWN;

    }
}

