/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist;

import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.commands.BossChecklistCommands;
import com.yori3o.boss_checklist.config.ServerConfig;
import com.yori3o.boss_checklist.server.BossDefeatedData;
import com.yori3o.boss_checklist.server.ServerBossIdsLoader;
import com.yori3o.boss_checklist.server.ServerResourceReloader;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;

public class BossChecklist {
    public static final String MOD_ID = "boss_checklist";
    public static Set<String> defeated_bosses_on_server;
    public static boolean isSaveBossKiller_dynamic;

    public void init() {
        BossChecklistCommands.register();
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> BossChecklistClient.OnlyClientInit());
        LifecycleEvent.SERVER_STARTED.register(this::onServerStarted);
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerJoin);
    }

    private void onServerStarted(MinecraftServer server) {
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new ServerResourceReloader());
        ServerBossIdsLoader.load(server.m_177941_());
        defeated_bosses_on_server = BossDefeatedData.get(server.m_129783_()).getDefeatedBosses();
        ServerConfig sc = new ServerConfig();
        sc.load();
        isSaveBossKiller_dynamic = sc.isSaveBossKiller();
    }

    private void onPlayerJoin(ServerPlayer player) {
        if (defeated_bosses_on_server != null) {
            for (String lineOfInformation : defeated_bosses_on_server) {
                FriendlyByteBuf registryBuf = new FriendlyByteBuf(Unpooled.buffer());
                registryBuf.m_130070_(lineOfInformation + "#false");
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)new ResourceLocation(MOD_ID, "boss_defeated"), (FriendlyByteBuf)registryBuf);
            }
        }
    }

    public static void removeBossFromDefeated_bosses_on_server(String value) {
        HashSet<String> defeated_bosses_on_serverCopy = new HashSet<String>();
        for (String boss : defeated_bosses_on_server) {
            String bossId = boss.split("#")[0];
            if (bossId.equals(value.split("#")[0])) continue;
            defeated_bosses_on_serverCopy.add(boss);
        }
        defeated_bosses_on_server.clear();
        defeated_bosses_on_server.addAll(defeated_bosses_on_serverCopy);
    }
}

