/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.recipify;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Recipify
extends JavaPlugin
implements Listener,
CommandExecutor {
    private File recipeFile;
    private FileConfiguration recipeConfig;
    private final Map<UUID, Inventory> openInventories = new HashMap<UUID, Inventory>();
    private final Map<String, List<ItemStack>> recipeInputs = new HashMap<String, List<ItemStack>>();
    private final Map<String, ItemStack> recipeOutputs = new HashMap<String, ItemStack>();
    private final Map<UUID, String> editing = new HashMap<UUID, String>();
    private static final int[] inputSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    private static final int outputSlot = 24;

    public void onEnable() {
        this.getCommand("recipify").setExecutor((CommandExecutor)this);
        this.getCommand("deleterecipe").setExecutor((CommandExecutor)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.createRecipeFile();
        this.loadRecipes();
    }

    private void createRecipeFile() {
        this.recipeFile = new File(this.getDataFolder(), "recipes.yml");
        if (!this.recipeFile.exists()) {
            this.recipeFile.getParentFile().mkdirs();
            this.saveResource("recipes.yml", false);
        }
        this.recipeConfig = YamlConfiguration.loadConfiguration((File)this.recipeFile);
    }

    private void saveRecipe(String id, String playerName, List<ItemStack> input, ItemStack output) {
        String path = "recipes." + id;
        for (int i = 0; i < input.size(); ++i) {
            this.recipeConfig.set(path + ".input." + i, (Object)input.get(i));
        }
        this.recipeConfig.set(path + ".output", (Object)output);
        this.recipeConfig.set(path + ".creator", (Object)playerName);
        try {
            this.recipeConfig.save(this.recipeFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.registerRecipe(id, input, output);
        this.recipeInputs.put(id, input);
        this.recipeOutputs.put(id, output);
    }

    private void registerRecipe(String id, List<ItemStack> input, ItemStack output) {
        try {
            NamespacedKey key = new NamespacedKey((Plugin)this, "custom_recipe_" + id);
            ShapedRecipe recipe = new ShapedRecipe(key, output);
            String[] shape = new String[3];
            HashMap<Character, RecipeChoice.ExactChoice> ingredients = new HashMap<Character, RecipeChoice.ExactChoice>();
            char c = 'A';
            for (int row = 0; row < 3; ++row) {
                StringBuilder rowShape = new StringBuilder();
                for (int col = 0; col < 3; ++col) {
                    int index = row * 3 + col;
                    ItemStack item = input.get(index);
                    if (item != null && item.getType() != Material.AIR) {
                        rowShape.append(c);
                        ingredients.put(Character.valueOf(c), new RecipeChoice.ExactChoice(item));
                    } else {
                        rowShape.append(' ');
                    }
                    c = (char)(c + '\u0001');
                }
                shape[row] = rowShape.toString();
            }
            recipe.shape(shape);
            for (Map.Entry entry : ingredients.entrySet()) {
                recipe.setIngredient(((Character)entry.getKey()).charValue(), (RecipeChoice)entry.getValue());
            }
            Bukkit.addRecipe((Recipe)recipe);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to register recipe: " + id);
        }
    }

    private void loadRecipes() {
        if (!this.recipeConfig.contains("recipes")) {
            return;
        }
        ConfigurationSection section = this.recipeConfig.getConfigurationSection("recipes");
        for (String key : section.getKeys(false)) {
            try {
                ArrayList<ItemStack> input = new ArrayList<ItemStack>();
                ConfigurationSection inputSection = section.getConfigurationSection(key + ".input");
                for (int i = 0; i < 9; ++i) {
                    input.add(inputSection.getItemStack(String.valueOf(i)));
                }
                ItemStack output = section.getItemStack(key + ".output");
                if (output == null) continue;
                this.saveRecipe(key, "loader", input, output);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load recipe: " + key);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("recipify")) {
            this.openRecipeGUI(player);
            return true;
        }
        if (command.getName().equalsIgnoreCase("deleterecipe")) {
            ItemStack held = player.getInventory().getItemInMainHand();
            if (held == null || held.getType() == Material.AIR) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must hold an item to delete its recipe.");
                return true;
            }
            String idToRemove = null;
            for (Map.Entry<String, ItemStack> entry : this.recipeOutputs.entrySet()) {
                if (!entry.getValue().isSimilar(held)) continue;
                idToRemove = entry.getKey();
                break;
            }
            if (idToRemove == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No recipe found for the held item.");
                return true;
            }
            NamespacedKey key = new NamespacedKey((Plugin)this, "custom_recipe_" + idToRemove);
            boolean removed = Bukkit.removeRecipe((NamespacedKey)key);
            this.recipeConfig.set("recipes." + idToRemove, null);
            this.recipeInputs.remove(idToRemove);
            this.recipeOutputs.remove(idToRemove);
            try {
                this.recipeConfig.save(this.recipeFile);
                if (removed) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Recipe deleted successfully.");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Recipe removed from config, but could not remove from server registry.");
                }
            }
            catch (IOException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to save recipe deletion.");
            }
            return true;
        }
        return false;
    }

    private void openRecipeGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.GREEN) + "Recipify"));
        ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        glassMeta.setDisplayName(" ");
        glass.setItemMeta(glassMeta);
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, glass);
        }
        for (int i : inputSlots) {
            gui.setItem(i, null);
        }
        gui.setItem(24, null);
        ItemStack createButton = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta createMeta = createButton.getItemMeta();
        createMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Create Recipe");
        createButton.setItemMeta(createMeta);
        gui.setItem(48, createButton);
        ItemStack cancelButton = new ItemStack(Material.BARRIER);
        ItemMeta cancelMeta = cancelButton.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Cancel");
        cancelButton.setItemMeta(cancelMeta);
        gui.setItem(50, cancelButton);
        this.openInventories.put(player.getUniqueId(), gui);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.openInventories.containsKey(player.getUniqueId())) {
            return;
        }
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.GREEN) + "Recipify")) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot >= 0 && slot < event.getInventory().getSize()) {
            if (slot == 48) {
                ArrayList<ItemStack> input = new ArrayList<ItemStack>();
                boolean isEmpty = true;
                for (int i2 : inputSlots) {
                    ItemStack item = event.getInventory().getItem(i2);
                    input.add(item);
                    if (item == null || item.getType() == Material.AIR) continue;
                    isEmpty = false;
                }
                ItemStack output = event.getInventory().getItem(24);
                if (output == null || output.getType() == Material.AIR) {
                    isEmpty = true;
                }
                if (isEmpty) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "There is nothing in the GUI to create a recipe with.");
                    return;
                }
                String id = UUID.randomUUID().toString();
                this.saveRecipe(id, player.getName(), input, output);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Recipe created successfully.");
                player.closeInventory();
            } else if (slot == 50) {
                player.closeInventory();
            } else {
                boolean isOutput;
                boolean isInput = Arrays.stream(inputSlots).anyMatch(i -> i == slot);
                boolean bl = isOutput = slot == 24;
                if (!isInput && !isOutput) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.openInventories.containsKey(player.getUniqueId())) {
            return;
        }
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.GREEN) + "Recipify")) {
            return;
        }
        HashSet<Integer> allowed = new HashSet<Integer>();
        for (int i : inputSlots) {
            allowed.add(i);
        }
        allowed.add(24);
        Object object = event.getRawSlots().iterator();
        while (object.hasNext()) {
            int slot = (Integer)object.next();
            if (allowed.contains(slot)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        this.openInventories.remove(event.getPlayer().getUniqueId());
    }
}

