/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.randomitems999;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RandomItems999
extends JavaPlugin
implements Listener {
    private final Random random = new Random();
    private int intervalSeconds;
    private boolean isRunning = false;
    private BukkitRunnable distributionTask;
    private final Map<UUID, BossBar> playerBossBars = new HashMap<UUID, BossBar>();
    private final Map<UUID, Integer> receivedItems = new HashMap<UUID, Integer>();
    private final Set<UUID> hiddenBossBars = new HashSet<UUID>();
    private List<Material> excludedMaterials;
    private BarColor bossBarColor;
    private BarStyle bossBarStyle;
    private List<String> distributionWorlds;
    private Map<Material, Double> itemRarity;
    private Map<String, String> messages;
    private Map<String, Boolean> sounds;
    private File dataFile;
    private FileConfiguration dataConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupDataFile();
        this.loadConfigValues();
        this.loadData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("RandomItems999 loaded! Use /randomitem start/stop to control distribution.");
    }

    public void onDisable() {
        this.stopDistribution();
        this.saveData();
        this.getLogger().info("RandomItems999 disabled.");
    }

    private void reloadPluginConfig() {
        this.reloadConfig();
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.loadConfigValues();
        if (this.isRunning) {
            this.stopDistribution();
            this.startDistribution();
        }
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.intervalSeconds = config.getInt("interval", 20);
        this.excludedMaterials = config.getStringList("excluded-materials").stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toList());
        this.bossBarColor = BarColor.valueOf((String)config.getString("bossbar.color", "GREEN").toUpperCase());
        this.bossBarStyle = BarStyle.valueOf((String)config.getString("bossbar.style", "SOLID").toUpperCase());
        this.distributionWorlds = config.getStringList("distribution-worlds");
        this.itemRarity = new HashMap<Material, Double>();
        if (config.isConfigurationSection("item-rarity")) {
            for (String key : config.getConfigurationSection("item-rarity").getKeys(false)) {
                Material material = Material.getMaterial((String)key.toUpperCase());
                if (material != null) {
                    this.itemRarity.put(material, config.getDouble("item-rarity." + key));
                    continue;
                }
                this.getLogger().warning("Invalid material name in item-rarity section: " + key);
            }
        }
        this.messages = new HashMap<String, String>();
        if (config.isConfigurationSection("messages")) {
            for (String key : config.getConfigurationSection("messages").getKeys(false)) {
                this.messages.put(key, config.getString("messages." + key));
            }
        }
        this.sounds = new HashMap<String, Boolean>();
        if (config.isConfigurationSection("sounds")) {
            for (String key : config.getConfigurationSection("sounds").getKeys(false)) {
                this.sounds.put(key, config.getBoolean("sounds." + key));
            }
        }
    }

    private void setupDataFile() {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            this.saveResource("data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void loadData() {
        if (this.dataConfig.contains("receivedItems")) {
            for (String key : this.dataConfig.getConfigurationSection("receivedItems").getKeys(false)) {
                this.receivedItems.put(UUID.fromString(key), this.dataConfig.getInt("receivedItems." + key));
            }
        }
        if (this.dataConfig.contains("hiddenBossBars")) {
            for (String key : this.dataConfig.getStringList("hiddenBossBars")) {
                this.hiddenBossBars.add(UUID.fromString(key));
            }
        }
    }

    private void saveData() {
        for (Map.Entry<UUID, Integer> entry : this.receivedItems.entrySet()) {
            this.dataConfig.set("receivedItems." + entry.getKey().toString(), (Object)entry.getValue());
        }
        this.dataConfig.set("hiddenBossBars", this.hiddenBossBars.stream().map(UUID::toString).collect(Collectors.toList()));
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save data to data.yml!");
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("randomitem")) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(this.messages.getOrDefault("usage", "\u00a76Usage: \u00a7f/randomitem \u00a7astart|stop|togglebossbar|setinterval <seconds>|reload"));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "start": {
                if (!sender.hasPermission("randomitems.admin")) {
                    sender.sendMessage(this.messages.getOrDefault("no-permission", "\u00a7cYou do not have permission to use this command."));
                    return true;
                }
                if (this.isRunning) {
                    sender.sendMessage(this.messages.getOrDefault("already-running", "\u00a7cItem distribution is already running!"));
                    return true;
                }
                this.startDistribution();
                sender.sendMessage(this.messages.getOrDefault("started", "\u00a7aStarted giving random items every %interval% seconds!").replace("%interval%", String.valueOf(this.intervalSeconds)));
                break;
            }
            case "stop": {
                if (!sender.hasPermission("randomitems.admin")) {
                    sender.sendMessage(this.messages.getOrDefault("no-permission", "\u00a7cYou do not have permission to use this command."));
                    return true;
                }
                if (!this.isRunning) {
                    sender.sendMessage(this.messages.getOrDefault("not-running", "\u00a7cItem distribution is not currently running!"));
                    return true;
                }
                this.stopDistribution();
                sender.sendMessage(this.messages.getOrDefault("stopped", "\u00a7aStopped item distribution."));
                break;
            }
            case "setinterval": {
                if (!sender.hasPermission("randomitems.admin")) {
                    sender.sendMessage(this.messages.getOrDefault("no-permission", "\u00a7cYou do not have permission to use this command."));
                    return true;
                }
                if (args.length != 2) {
                    sender.sendMessage(this.messages.getOrDefault("invalid-interval", "\u00a7cInvalid interval! Usage: /randomitem setinterval <seconds>"));
                    return true;
                }
                try {
                    int newInterval = Integer.parseInt(args[1]);
                    if (newInterval < 1) {
                        sender.sendMessage(this.messages.getOrDefault("interval-too-low", "\u00a7cInterval must be at least 1 second!"));
                        return true;
                    }
                    this.intervalSeconds = newInterval;
                    this.getConfig().set("interval", (Object)newInterval);
                    this.saveConfig();
                    sender.sendMessage(this.messages.getOrDefault("interval-set", "\u00a7aItem distribution interval set to %interval% seconds!").replace("%interval%", String.valueOf(this.intervalSeconds)));
                    if (!this.isRunning) break;
                    this.stopDistribution();
                    this.startDistribution();
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.messages.getOrDefault("invalid-interval", "\u00a7cInvalid interval! Usage: /randomitem setinterval <seconds>"));
                }
                break;
            }
            case "togglebossbar": {
                BossBar bossBar;
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.messages.getOrDefault("player-only-command", "\u00a7cThis command can only be used by players."));
                    return true;
                }
                Player player = (Player)sender;
                UUID playerUuid = player.getUniqueId();
                if (this.hiddenBossBars.contains(playerUuid)) {
                    this.hiddenBossBars.remove(playerUuid);
                    player.sendMessage(this.messages.getOrDefault("bossbar-enabled", "\u00a7aBoss bar enabled."));
                    if (this.sounds.getOrDefault("bossbar-toggle", true).booleanValue()) {
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    }
                    if (!this.isRunning) break;
                    this.updateBossBar(player);
                    break;
                }
                this.hiddenBossBars.add(playerUuid);
                player.sendMessage(this.messages.getOrDefault("bossbar-disabled", "\u00a7cBoss bar disabled."));
                if (this.sounds.getOrDefault("bossbar-toggle", true).booleanValue()) {
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.5f);
                }
                if ((bossBar = this.playerBossBars.get(playerUuid)) == null) break;
                bossBar.removePlayer(player);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("randomitems.admin")) {
                    sender.sendMessage(this.messages.getOrDefault("no-permission", "\u00a7cYou do not have permission to use this command."));
                    return true;
                }
                this.reloadPluginConfig();
                sender.sendMessage(this.messages.getOrDefault("reloaded", "\u00a7aRandomItems999 configuration reloaded!"));
                break;
            }
            default: {
                sender.sendMessage("\u00a76Usage: \u00a7f/randomitem \u00a7astart|stop|togglebossbar|setinterval <seconds>|reload");
            }
        }
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.isRunning) {
            final Player player = event.getPlayer();
            new BukkitRunnable(){

                public void run() {
                    RandomItems999.this.updateBossBar(player);
                }
            }.runTaskLater((Plugin)this, 20L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        BossBar bossBar = this.playerBossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    private void startDistribution() {
        this.isRunning = true;
        this.distributionTask = new BukkitRunnable(){
            int remainingSeconds;
            {
                this.remainingSeconds = RandomItems999.this.intervalSeconds;
            }

            public void run() {
                if (this.remainingSeconds <= 0) {
                    RandomItems999.this.distributeItems();
                    this.remainingSeconds = RandomItems999.this.intervalSeconds;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    BossBar bossBar;
                    if (RandomItems999.this.hiddenBossBars.contains(player.getUniqueId()) || (bossBar = RandomItems999.this.playerBossBars.get(player.getUniqueId())) == null) continue;
                    bossBar.setTitle("Next item in " + this.remainingSeconds + "s");
                    bossBar.setProgress((double)this.remainingSeconds / (double)RandomItems999.this.intervalSeconds);
                }
                --this.remainingSeconds;
            }
        };
        this.distributionTask.runTaskTimer((Plugin)this, 0L, 20L);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateBossBar(player);
        }
    }

    private void distributeItems() {
        List allItems = Arrays.stream(Material.values()).filter(Material::isItem).filter(m -> m != Material.AIR && !this.excludedMaterials.contains(m)).collect(Collectors.toList());
        if (allItems.isEmpty()) {
            this.getLogger().warning(this.messages.getOrDefault("no-valid-items", "No valid items found for distribution!"));
            return;
        }
        double totalWeight = 0.0;
        for (Material item : allItems) {
            totalWeight += this.itemRarity.getOrDefault(item, 1.0).doubleValue();
        }
        HashSet<Material> distributedItems = new HashSet<Material>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.distributionWorlds.contains(player.getWorld().getName()) || player.getInventory().firstEmpty() == -1) continue;
            Material randomItem = null;
            int attempts = 0;
            int maxAttempts = 100;
            block2: do {
                double randomNumber = this.random.nextDouble() * totalWeight;
                for (Material item : allItems) {
                    if (!((randomNumber -= this.itemRarity.getOrDefault(item, 1.0).doubleValue()) <= 0.0)) continue;
                    randomItem = item;
                    continue block2;
                }
            } while (distributedItems.contains(randomItem) && ++attempts < maxAttempts);
            if (randomItem == null) {
                this.getLogger().warning("Could not find a unique random item for player " + player.getName() + " after " + maxAttempts + " attempts.");
                continue;
            }
            if (!player.isOnline()) continue;
            distributedItems.add(randomItem);
            player.getInventory().addItem(new ItemStack[]{new ItemStack(randomItem, 1)});
            int count = this.receivedItems.getOrDefault(player.getUniqueId(), 0) + 1;
            this.receivedItems.put(player.getUniqueId(), count);
            player.sendMessage(this.messages.getOrDefault("item-received", "\u00a7aYou received a random item: \u00a76%item%").replace("%item%", this.formatItemName(randomItem.name())));
            if (this.sounds.getOrDefault("item-received", true).booleanValue()) {
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            }
            this.updateBossBar(player);
        }
    }

    private void updateBossBar(Player player) {
        if (this.hiddenBossBars.contains(player.getUniqueId())) {
            return;
        }
        BossBar bossBar = this.playerBossBars.get(player.getUniqueId());
        if (bossBar == null) {
            bossBar = Bukkit.createBossBar((String)("Next item in " + this.intervalSeconds + "s"), (BarColor)this.bossBarColor, (BarStyle)this.bossBarStyle, (BarFlag[])new BarFlag[0]);
            this.playerBossBars.put(player.getUniqueId(), bossBar);
        }
        bossBar.addPlayer(player);
    }

    private void stopDistribution() {
        this.isRunning = false;
        if (this.distributionTask != null) {
            this.distributionTask.cancel();
            this.distributionTask = null;
        }
        for (BossBar bossBar : this.playerBossBars.values()) {
            bossBar.removeAll();
        }
        this.playerBossBars.clear();
    }

    private String formatItemName(String materialName) {
        return materialName.toLowerCase().replace('_', ' ').replace("item ", "").replace("minecraft ", "");
    }
}

