/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.client;

import com.mojang.logging.LogUtils;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.option.SpruceCheckboxBooleanOption;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleOption;
import dev.lambdaurora.spruceui.option.SpruceFloatInputOption;
import dev.lambdaurora.spruceui.option.SpruceIntegerInputOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import dev.lambdaurora.spruceui.widget.container.tabbed.SpruceTabbedWidget;
import gay.ampflower.musicmoods.ClientMain;
import gay.ampflower.musicmoods.Config;
import gay.ampflower.musicmoods.Mint;
import gay.ampflower.musicmoods.config.OptionEnum;
import gay.ampflower.musicmoods.mixin.AccessorOptionInstance;
import gay.ampflower.musicmoods.mixin.AccessorTooltip;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import manifold.ext.props.rt.api.auto;
import manifold.ext.props.rt.api.propgen;
import manifold.ext.props.rt.api.val;
import net.minecraft.class_1140;
import net.minecraft.class_1142;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_421;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7172;
import net.minecraft.class_7919;
import org.slf4j.Logger;

public class ConfigurationScreen
extends SpruceScreen {
    private static final Logger logger = LogUtils.getLogger();
    private static final MethodHandles.Lookup SELF = MethodHandles.lookup();
    private final class_437 parent;
    private SpruceTabbedWidget tabbedWidget;
    private boolean committed;

    public ConfigurationScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"music-moods.gui.configuration"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.tabbedWidget = new SpruceTabbedWidget(Position.of((SprucePositioned)this, (int)0, (int)4), this.field_22789, this.field_22790 - 35 - 4, this.field_22785);
        this.addTabEntry("volume", this::buildVolumeList);
        this.addTabEntry("music", this::buildMusicOptionList);
        this.addTabEntry("jukebox", ConfigurationScreen::buildJukeboxOptionList);
        this.addTabEntry("demo", ConfigurationScreen::buildDemoList);
        this.addTabEntry("meta", ConfigurationScreen::buildMetaList);
        this.method_37063((class_364)this.tabbedWidget);
        this.method_37063((class_364)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(this.field_22789 / 2 - 75), (int)(this.field_22790 - 28)), 150, 20, SpruceTexts.GUI_DONE, btn -> this.method_25419()));
    }

    public void method_25432() {
        if (!this.committed) {
            try {
                Config.commit();
                this.field_22787.field_1690.method_1640();
            }
            catch (IOException ioe) {
                logger.error("Failed to save Music Moods config. User not notified.", (Throwable)ioe);
            }
        }
    }

    public void method_25419() {
        try {
            this.committed = true;
            Config.commit();
            this.field_22787.field_1690.method_1640();
            this.field_22787.method_1507(this.parent);
        }
        catch (IOException ioe) {
            logger.error("Failed to save Music Moods config", (Throwable)ioe);
            this.field_22787.method_1507((class_437)new class_421((class_2561)class_2561.method_43471((String)"music-moods.gui.configuration.error"), (class_2561)class_2561.method_43470((String)ioe.getLocalizedMessage())));
        }
    }

    protected void addTabEntry(String name, SpruceTabbedWidget.ContainerFactory factory) {
        String key = "music-moods.gui.configuration." + name;
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43471((String)key), (class_2561)class_2561.method_43471((String)(key + ".description")).method_27692(class_124.field_1080), factory);
    }

    protected SpruceOptionListWidget buildVolumeList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        class_3419 last = null;
        for (class_3419 value : class_3419.values()) {
            if (value == class_3419.field_15250) {
                list.addSingleOptionEntry((SpruceOption)this.toSlider(value));
                continue;
            }
            if (last == null) {
                last = value;
                continue;
            }
            list.addOptionEntry((SpruceOption)this.toSlider(last), (SpruceOption)this.toSlider(value));
            last = null;
        }
        if (last != null) {
            list.addSmallSingleOptionEntry((SpruceOption)this.toSlider(last));
        }
        list.addSingleOptionEntry((SpruceOption)this.getSoundDevices());
        list.addOptionEntry((SpruceOption)ConfigurationScreen.toCheckbox("showSubtitles", (class_7172<Boolean>)this.field_22787.field_1690.method_42443(), (class_2561)class_2561.method_43471((String)"options.showSubtitles.tooltip")), (SpruceOption)ConfigurationScreen.toCheckbox("directionalAudio", (class_7172<Boolean>)this.field_22787.field_1690.method_42444(), (class_2561)class_2561.method_43471((String)"options.directionalAudio.tooltip")));
        list.addOptionEntry((SpruceOption)this.getMusicFrequency(), (SpruceOption)ConfigurationScreen.toCheckbox("showNowPlayingToast", (class_7172<Boolean>)this.field_22787.field_1690.method_71787(), (class_2561)class_2561.method_43471((String)"options.showNowPlayingToast.tooltip")));
        return list;
    }

    protected SpruceOptionListWidget buildMusicOptionList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("situationalMusic"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.cycling("situationalMusicReplacing"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.checkbox("immediatelyPlayOnReplace"), (SpruceOption)this.getMusicFrequency());
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("transitions"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.intInput("fadeInTicks"), (SpruceOption)ConfigurationScreen.intInput("fadeOutTicks"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.checkbox("seamlessTransitions"));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError("Unexpected access violation", roe);
        }
        return list;
    }

    protected static SpruceOptionListWidget buildJukeboxOptionList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("jukebox"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.checkbox("jukeboxEnabled"), (SpruceOption)ConfigurationScreen.checkbox("jukeboxMultiplayer"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("jukeboxRange"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.floatSlider("jukeboxReplaceRange"), (SpruceOption)ConfigurationScreen.floatSlider("jukeboxFadeRange"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("transitions"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.intInput("jukeboxFadeMixTicks"), (SpruceOption)ConfigurationScreen.intInput("jukeboxFadeStopTicks"));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError("Unexpected access violation", roe);
        }
        return list;
    }

    protected static SpruceOptionListWidget buildDemoList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("modfest"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.checkbox("rightClickToPlay"));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError((Object)roe);
        }
        return list;
    }

    protected static SpruceOptionListWidget buildMetaList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("modPack"));
            if (ClientMain.isModMenuPresent) {
                list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.checkbox("injectUiComponents"));
            } else {
                list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("modMenu"));
            }
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError("Unexpected access violation", roe);
        }
        return list;
    }

    private SpruceDoubleOption toSlider(class_3419 source) {
        String key = "soundCategory." + source.method_14840();
        class_7172 option = this.field_22787.field_1690.method_45578(source);
        return new SpruceDoubleOption(key, 0.0, 1.0, 0.01f, () -> ((class_7172)option).method_41753(), arg_0 -> ((class_7172)option).method_41748(arg_0), self -> ConfigurationScreen.genericPercentage(key, self.get()), ConfigurationScreen.translation(key + ".description"));
    }

    private static SpruceCheckboxBooleanOption toCheckbox(String name, class_7172<Boolean> option, class_2561 tooltip) {
        String key = "options." + name;
        return new SpruceCheckboxBooleanOption(key, () -> option.method_41753(), arg_0 -> option.method_41748(arg_0), ConfigurationScreen.adapt(tooltip));
    }

    private SpruceCyclingOption getSoundDevices() {
        String key = "options.soundDevice";
        class_7172 option = this.field_22787.field_1690.method_42477();
        DynamicStepper<String> stepper = new DynamicStepper<String>(() -> {
            List init = this.field_22787.method_1483().method_38565();
            ArrayList<String> list = new ArrayList<String>(init.size() + 1);
            list.add("");
            list.addAll(init);
            return list;
        }, () -> ((class_7172)option).method_41753(), arg_0 -> ((class_7172)option).method_41748(arg_0), str -> {
            if ("".equals(str)) {
                return ConfigurationScreen.genericValue("options.audioDevice", "options.audioDevice.default");
            }
            if (str.startsWith("OpenAL Soft on ")) {
                str = str.substring(class_1140.field_34828);
            }
            return ConfigurationScreen.genericValue((class_2561)class_2561.method_43471((String)"options.audioDevice"), (class_2561)class_2561.method_43470((String)str));
        });
        class_5250 nl = class_2561.method_43470((String)"\n- ");
        class_5250 tooltip = class_2561.method_43471((String)"options.soundDevice.tooltip");
        for (String device : this.field_22787.method_1483().method_38565()) {
            if (device.startsWith("OpenAL Soft on ")) {
                device = device.substring(class_1140.field_34828);
            }
            tooltip.method_10852((class_2561)nl).method_10852((class_2561)class_2561.method_43470((String)device).method_27692(class_124.field_1054));
        }
        return new SpruceCyclingOption("options.soundDevice", stepper, stepper, ConfigurationScreen.adapt((class_2561)tooltip));
    }

    private SpruceCyclingOption getMusicFrequency() {
        String key = "options.music_frequency";
        class_7172 option = this.field_22787.field_1690.method_71788();
        EnumStepper stepper = new EnumStepper((Enum[])class_1142.class_11504.values(), () -> ((class_7172)option).method_41753(), arg_0 -> ((class_7172)option).method_41748(arg_0), value -> ConfigurationScreen.genericValue("options.music_frequency", value.method_7359()));
        return new SpruceCyclingOption("options.music_frequency", (Consumer)stepper, (Function)stepper, ConfigurationScreen.translation("options.music_frequency.tooltip"));
    }

    public static SpruceSeparatorOption separator(String field) {
        String key = "music-moods.option.separator." + field;
        return new SpruceSeparatorOption(key, true, ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceFloatInputOption floatSlider(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = SELF.findStaticVarHandle(Config.class, field, Float.TYPE);
        String key = "music-moods.option." + field;
        return new SpruceFloatInputOption(key, () -> Float.valueOf(handle.get()), (Consumer<Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Float ), (Ljava/lang/Float;)V)((VarHandle)handle), ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceIntegerInputOption intInput(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = SELF.findStaticVarHandle(Config.class, field, Integer.TYPE);
        String key = "music-moods.option." + field;
        return new SpruceIntegerInputOption(key, () -> handle.get(), (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Integer ), (Ljava/lang/Integer;)V)((VarHandle)handle), ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceCheckboxBooleanOption checkbox(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = SELF.findStaticVarHandle(Config.class, field, Boolean.TYPE);
        String key = "music-moods.option." + field;
        return new SpruceCheckboxBooleanOption(key, () -> handle.get(), (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Boolean ), (Ljava/lang/Boolean;)V)((VarHandle)handle), ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceCyclingOption cycling(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = ConfigurationScreen.findEnumField(field);
        Enum[] enums = (Enum[])handle.varType().getEnumConstants();
        String key = "music-moods.option." + field;
        EnumStepper stepper = new EnumStepper(enums, handle, key);
        return new SpruceCyclingOption(key, (Consumer)stepper, (Function)stepper, ConfigurationScreen.translation(key + ".description"));
    }

    private static <T extends Enum<T>> SpruceCyclingOption cycling(String key, Class<T> supplier, Supplier<T> getter, Consumer<T> setter, Function<T, class_2561> toName) {
        EnumStepper stepper = new EnumStepper((Enum[])supplier.getEnumConstants(), getter, setter, toName);
        return new SpruceCyclingOption(key, (Consumer)stepper, (Function)stepper, ConfigurationScreen.translation(key + ".description"));
    }

    private static <T> SpruceCyclingOption cycling(String key, Supplier<List<T>> supplier, Supplier<T> getter, Consumer<T> setter, Function<T, class_2561> toName) {
        DynamicStepper<T> stepper = new DynamicStepper<T>(supplier, getter, setter, toName);
        return new SpruceCyclingOption(key, stepper, stepper, ConfigurationScreen.translation(key + ".description"));
    }

    private static VarHandle findEnumField(String name) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = Config.class.getFields()) {
            if (!name.equals(field.getName())) continue;
            if (Enum.class.isAssignableFrom(field.getType())) {
                return SELF.unreflectVarHandle(field);
            }
            throw new NoSuchFieldException("Incompatible field " + String.valueOf(field));
        }
        throw new NoSuchFieldException("Cannot find " + name + " in Config");
    }

    private static class_2561 genericValue(String key, String value) {
        return ConfigurationScreen.genericValue((class_2561)class_2561.method_43471((String)key), (class_2561)class_2561.method_43471((String)value));
    }

    private static class_2561 genericValue(class_2561 key, class_2561 value) {
        return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{key, value});
    }

    private static class_2561 genericPercentage(String key, double value) {
        return ConfigurationScreen.genericPercentage((class_2561)class_2561.method_43471((String)key), (int)(value * 100.0));
    }

    private static class_2561 genericPercentage(class_2561 key, int value) {
        return class_2561.method_43469((String)"options.percent_value", (Object[])new Object[]{key, value});
    }

    private static TooltipData translation(String key) {
        return ConfigurationScreen.adapt((class_2561)class_2561.method_43471((String)key));
    }

    private static TooltipData adapt(class_2561 component) {
        if (component == null || class_2561.method_43473().equals((Object)component)) {
            return TooltipData.EMPTY;
        }
        return TooltipData.builder().text(component).build();
    }

    private static TooltipData adapt(class_7919 tooltip) {
        if (tooltip == null) {
            return TooltipData.EMPTY;
        }
        return ConfigurationScreen.adapt(((AccessorTooltip)tooltip).getMessage());
    }

    private static <T> TooltipData adapt(class_7172<T> instance) {
        return ConfigurationScreen.adapt(((AccessorOptionInstance)instance).getTooltip().apply(instance.method_41753()));
    }

    private record DynamicStepper<T>(@val @auto(declaredAccess=2) @propgen(name="supplier", flags=0x2000000001000011L) Supplier<List<T>> supplier, @val @auto(declaredAccess=2) @propgen(name="getter", flags=0x2000000001000011L) Supplier<T> getter, @val @auto(declaredAccess=2) @propgen(name="setter", flags=0x2000000001000011L) Consumer<T> setter, @val @auto(declaredAccess=2) @propgen(name="toName", flags=0x2000000001000011L) Function<T, class_2561> toName) implements Consumer<Integer>,
    Function<SpruceCyclingOption, class_2561>
    {
        @Override
        public void accept(Integer integer) {
            List<T> list = this.supplier.get();
            T curr = this.getter.get();
            int index = list.indexOf(curr);
            int newIndex = Mint.wrapPositive(index + integer, list.size());
            this.setter.accept(list.get(newIndex));
        }

        @Override
        public class_2561 apply(SpruceCyclingOption spruceCyclingOption) {
            return this.toName.apply(this.getter.get());
        }
    }

    private record EnumStepper<T extends Enum<T>>(@val @auto(declaredAccess=2) @propgen(name="enums", flags=0x2000000001000011L) T[] enums, @val @auto(declaredAccess=2) @propgen(name="getter", flags=0x2000000001000011L) Supplier<T> getter, @val @auto(declaredAccess=2) @propgen(name="setter", flags=0x2000000001000011L) Consumer<T> setter, @val @auto(declaredAccess=2) @propgen(name="toName", flags=0x2000000001000011L) Function<T, class_2561> toName) implements Consumer<Integer>,
    Function<SpruceCyclingOption, class_2561>
    {
        private EnumStepper(T[] enums, VarHandle handle, String key) {
            this((Enum[])enums, () -> handle.get(), (Consumer<Enum>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Enum ), (Ljava/lang/Enum;)V)((VarHandle)handle), value -> {
                String name = value.name().toLowerCase(Locale.ROOT);
                if (value instanceof OptionEnum) {
                    OptionEnum option = (OptionEnum)((Object)value);
                    return class_2561.method_43469((String)key, (Object[])new Object[]{class_2561.method_43471((String)("music-moods.option.value." + option.localizationClass() + "." + name))});
                }
                return class_2561.method_43469((String)key, (Object[])new Object[]{class_2561.method_43471((String)("music-moods.option.value." + name))});
            });
        }

        @Override
        public void accept(Integer integer) {
            int newIndex = (((Enum)this.getter.get()).ordinal() + integer) % this.enums.length;
            this.setter.accept(this.enums[newIndex]);
        }

        @Override
        public class_2561 apply(SpruceCyclingOption self) {
            return this.toName.apply((Enum)this.getter.get());
        }
    }
}

