/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.mixin;

import gay.ampflower.musicmoods.Config;
import gay.ampflower.musicmoods.Mint;
import gay.ampflower.musicmoods.client.MusicHandler;
import gay.ampflower.musicmoods.client.WeighedSoundEventsQuery;
import gay.ampflower.musicmoods.client.sound.MusicSoundInstance;
import gay.ampflower.musicmoods.client.sound.RecordSoundInstance;
import gay.ampflower.musicmoods.config.Replacing;
import gay.ampflower.musicmoods.extensions.net.minecraft.sounds.Music.ExtMusic;
import gay.ampflower.musicmoods.mixin.AccessorClientLevel;
import gay.ampflower.musicmoods.mixin.AccessorLevelEventHandler;
import gay.ampflower.musicmoods.mixin.AccessorMinecraft;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_10383;
import net.minecraft.class_1113;
import net.minecraft.class_1142;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9959;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1142.class}, priority=500)
public abstract class MixinMusicManager
implements MusicHandler {
    @Shadow
    @Nullable
    private class_1113 field_5574;
    @Shadow
    @Final
    private class_310 field_5575;
    @Shadow
    private int field_5572;
    @Shadow
    @Final
    private class_5819 field_5571;
    @Shadow
    private float field_55164;
    @Unique
    private boolean currentMusicIntruded;
    @Unique
    private RecordSoundInstance focusedJukebox;
    @Unique
    private MusicSoundInstance fadingOutMusic;
    @Unique
    private class_2960 currentCompatibleLocation;

    @Shadow
    private boolean method_65255(float volume) {
        throw new AssertionError();
    }

    @Overwrite
    public void method_18669() {
        MusicSoundInstance fadingOutMusic;
        if (Config.jukeboxEnabled && (Config.jukeboxMultiplayer || !((AccessorMinecraft)this.field_5575).invokeIsMultiplayerServer())) {
            this.handleRecords();
        }
        class_10383 musicInfo = this.field_5575.method_1544();
        class_5195 music = musicInfo.comp_3344();
        class_1144 soundManager = this.field_5575.method_1483();
        if (this.field_5574 != null) {
            boolean playing;
            float volume = musicInfo.comp_3345();
            if (this.field_55164 != volume && !(playing = this.method_65255(volume))) {
                this.stopMusic();
            }
            if (!soundManager.method_4877(this.field_5574)) {
                this.clearCurrent();
                this.field_5572 = this.deriveNextSongDelay(music);
            }
        }
        if ((fadingOutMusic = this.fadingOutMusic) != null && !soundManager.method_4877((class_1113)fadingOutMusic)) {
            fadingOutMusic = null;
            this.fadingOutMusic = null;
        }
        if (music == null) {
            this.handleMissingTrack();
            return;
        }
        class_2960 musicLocation = ExtMusic.getLocation(music);
        if (this.field_5574 != null && !this.currentMusicIntruded && Config.situationalMusicReplacing.replaces() && (this.isLoudAndCompatible(fadingOutMusic, musicLocation) || this.shouldReplace(music))) {
            this.fadeOrStopMusic();
            if (this.isCompatible((class_1113)fadingOutMusic, musicLocation)) {
                this.reset(0);
                this.field_5574 = fadingOutMusic;
                fadingOutMusic.setFadeIn(Config.fadeInTicks);
            } else if (Config.immediatelyPlayOnReplace) {
                this.startPlayingFadeIn(musicInfo);
            } else {
                this.clearCurrent();
                this.field_5572 = class_3532.method_15395((class_5819)this.field_5571, (int)0, (int)(music.method_27280() / 2));
            }
        }
        if (this.focusedJukebox != null) {
            if (soundManager.method_4877((class_1113)this.focusedJukebox)) {
                return;
            }
            this.focusedJukebox = null;
        }
        if ((Config.chaoticallyPlayMusic || this.field_5574 == null) && this.decrementSongDelay(music) <= 0) {
            if (fadingOutMusic != null) {
                this.startPlayingFadeIn(musicInfo);
            } else {
                this.method_4858(musicInfo);
            }
        }
    }

    @Unique
    private int deriveNextSongDelay(class_5195 music) {
        if (music == null) {
            return 100;
        }
        int minDelay = Config.alwaysPlayMusic ? 100 : (Config.chaoticallyPlayMusic ? 600 : music.method_27280());
        return Math.min(this.field_5572, class_3532.method_15395((class_5819)this.field_5571, (int)minDelay, (int)music.method_27281()));
    }

    @Unique
    private void handleMissingTrack() {
        this.field_5572 = Math.max(this.field_5572, 100);
        if (Config.situationalMusicReplacing == Replacing.always) {
            this.fadeOrStopMusic();
        }
    }

    @Unique
    private void handleRecords() {
        if (this.currentMusicIntruded) {
            return;
        }
        class_746 player = this.field_5575.field_1724;
        if (player == null) {
            return;
        }
        float fadeSq = Mint.square(Config.jukeboxFadeRange);
        float replSq = Mint.square(Config.jukeboxReplaceRange);
        float maxSq = Math.max(fadeSq, replSq);
        class_4184 camera = this.field_5575.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_241 cameraRot = Mint.cameraToRotationVector(camera);
        if (maxSq <= 0.0f) {
            if (this.focusedJukebox != null) {
                this.focusedJukebox.centerOnOrigin(cameraPos, cameraRot);
                this.focusedJukebox = null;
            }
            return;
        }
        class_9959 levelEventHandler = ((AccessorClientLevel)this.field_5575.field_1687).getLevelEventHandler();
        Map<class_2338, class_1113> map = ((AccessorLevelEventHandler)levelEventHandler).getPlayingJukeboxSongs();
        if (map.isEmpty() || map.size() > 128) {
            return;
        }
        class_1144 soundManager = this.field_5575.method_1483();
        Iterator<Map.Entry<class_2338, class_1113>> itr = map.entrySet().iterator();
        RecordSoundInstance lastRecord = null;
        double lastDelta = Double.POSITIVE_INFINITY;
        while (itr.hasNext()) {
            Map.Entry<class_2338, class_1113> entry = itr.next();
            if (!soundManager.method_4877(entry.getValue())) {
                itr.remove();
                continue;
            }
            class_1113 class_11132 = entry.getValue();
            if (!(class_11132 instanceof RecordSoundInstance)) continue;
            RecordSoundInstance record = (RecordSoundInstance)class_11132;
            double delta = entry.getKey().method_19770((class_2374)player.method_33571());
            if (delta > (double)maxSq || !(delta < lastDelta)) continue;
            lastRecord = record;
            lastDelta = delta;
        }
        if (this.focusedJukebox != null && this.focusedJukebox != lastRecord) {
            this.focusedJukebox.centerOnOrigin(cameraPos, cameraRot);
        }
        if (lastRecord != null && lastDelta > (double)replSq) {
            lastRecord.centerOnOrigin(cameraPos, cameraRot);
        }
        this.focusedJukebox = lastRecord;
        if (lastRecord == null) {
            return;
        }
        if (lastDelta < (double)replSq) {
            lastRecord.centerOnPlayer(cameraPos, cameraRot);
        }
        this.fadeOrStopMusic(Config.jukeboxFadeMixTicks);
    }

    @Override
    public boolean moods$intrudeJukeboxTrack(@NotNull class_6880<class_3414> soundEvent, @Nullable class_2561 name) {
        if (this.currentMusicIntruded && this.isCompatible(this.field_5574, ((class_3414)soundEvent.comp_349()).comp_3319())) {
            return false;
        }
        this.startPlayingIntruded(soundEvent, name);
        return true;
    }

    @Unique
    private boolean isLoudAndCompatible(MusicSoundInstance instance, class_2960 musicLocation) {
        if (instance == null || instance.getDirectVolume() < 0.75f) {
            return false;
        }
        return this.isCompatible((class_1113)instance, musicLocation);
    }

    @Unique
    private boolean shouldReplace(class_5195 music) {
        return (Config.situationalMusicReplacing == Replacing.always || music.method_27282()) && this.isReplaceable(this.field_5574, ExtMusic.getLocation(music));
    }

    @Unique
    private boolean isReplaceable(class_1113 instance, class_2960 musicLocation) {
        return musicLocation != this.currentCompatibleLocation && !this.isCompatible(instance, musicLocation);
    }

    @Override
    public boolean moods$isCurrentlyPlaying(class_3414 soundEvent) {
        if (!this.currentMusicIntruded) {
            return false;
        }
        return this.isCompatible(this.field_5574, soundEvent.comp_3319());
    }

    @Unique
    private boolean isCompatible(class_1113 instance, class_2960 musicLocation) {
        WeighedSoundEventsQuery query;
        if (instance == null || musicLocation == null) {
            return false;
        }
        if (instance.method_4775().equals((Object)musicLocation)) {
            this.currentCompatibleLocation = musicLocation;
            return true;
        }
        class_1146 weighedSounds = this.field_5575.method_1483().method_4869(musicLocation);
        if (weighedSounds instanceof WeighedSoundEventsQuery && (query = (WeighedSoundEventsQuery)weighedSounds).contains(instance.method_4776())) {
            this.currentCompatibleLocation = musicLocation;
            return true;
        }
        return false;
    }

    @Unique
    private int decrementSongDelay(class_5195 music) {
        int maxDelay = music.method_27281();
        if (Config.alwaysPlayMusic) {
            maxDelay = 100;
        }
        this.field_5572 = Math.min(this.field_5572 - 1, maxDelay);
        return this.field_5572;
    }

    @Unique
    private void startPlayingFadeIn(class_10383 music) {
        if (music.comp_3344() == null || music.comp_3345() <= 0.0f) {
            return;
        }
        this.startPlayingCommon((class_6880<class_3414>)music.comp_3344().method_27279(), null, music.comp_3345(), (float)Config.fadeInTicks);
    }

    @Overwrite
    public void method_4858(class_10383 music) {
        if (music.comp_3344() == null || music.comp_3345() <= 0.0f) {
            return;
        }
        this.startPlayingCommon((class_6880<class_3414>)music.comp_3344().method_27279(), null, music.comp_3345(), 0.0f);
    }

    @Unique
    private void startPlayingIntruded(class_6880<class_3414> soundEventHolder, class_2561 name) {
        this.reset(Config.jukeboxFadeMixTicks);
        this.currentMusicIntruded = true;
        this.startPlayingCommon(soundEventHolder, name, 1.0f, 0.0f);
    }

    @Unique
    private void startPlayingCommon(class_6880<class_3414> soundEvent, @Nullable class_2561 name, float volume, float fadeInTicks) {
        this.startPlayingCommon((class_3414)soundEvent.comp_349(), name, volume, fadeInTicks);
    }

    @Unique
    private void startPlayingCommon(class_3414 soundEvent, @Nullable class_2561 name, float volume, float fadeInTicks) {
        this.field_5574 = new MusicSoundInstance(soundEvent, fadeInTicks);
        this.field_5572 = Integer.MAX_VALUE;
        this.field_55164 = volume;
        if (this.field_5574.method_4776() == class_1144.field_5592) {
            return;
        }
        this.field_5575.method_1483().method_4873(this.field_5574);
    }

    @Unique
    private void reset(int fadeOut) {
        class_4184 camera = this.field_5575.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_241 cameraRot = Mint.cameraToRotationVector(camera);
        if (this.focusedJukebox != null) {
            this.focusedJukebox.centerOnOrigin(cameraPos, cameraRot);
            this.focusedJukebox = null;
        }
        this.fadeOrStopMusic(fadeOut);
    }

    @Unique
    private void fadeOrStopMusic() {
        this.fadeOrStopMusic(Config.fadeOutTicks);
    }

    @Unique
    private void fadeOrStopMusic(float fadeOut) {
        class_1113 class_11132;
        if (fadeOut > 0.0f && (class_11132 = this.field_5574) instanceof MusicSoundInstance) {
            MusicSoundInstance music = (MusicSoundInstance)class_11132;
            music.setFadeOut(fadeOut);
            this.fadingOutMusic = music;
            this.clearCurrent();
        } else {
            this.stopMusic();
        }
    }

    @Unique
    private void stopMusic() {
        this.field_5575.method_1483().method_4870(this.field_5574);
        this.clearCurrent();
    }

    @Unique
    private void clearCurrent() {
        this.field_5574 = null;
        this.currentMusicIntruded = false;
        this.currentCompatibleLocation = null;
    }

    @Inject(method={"stopPlaying()V"}, at={@At(value="RETURN")})
    private void clearOnStopPlaying(CallbackInfo ci) {
        this.clearCurrent();
    }
}

