/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods;

import gay.ampflower.musicmoods.config.Replacing;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;

public final class Config {
    private static final Path configDir = FabricLoader.getInstance().getConfigDir();
    private static final Path config = configDir.resolve("music-moods.properties");
    private static final int fadeDefault = 600;
    private static final float jukeboxReplaceRangeDefault = 0.0f;
    private static final float jukeboxFadeRangeDefault = 48.0f;
    private static final int soundsFadeDefault = 100;
    private static final int jukeboxFadeDefault = 20;
    public static final int version = 1;
    public static int fadeOutTicks = 600;
    public static int fadeInTicks = 600;
    public static Replacing situationalMusicReplacing = Replacing.allow;
    public static boolean immediatelyPlayOnReplace = true;
    @Deprecated(forRemoval=true)
    public static boolean alwaysPlayMusic = false;
    public static boolean seamlessTransitions = true;
    public static int seamlessSoundTransitions = 0;
    public static boolean allowPausingMusic = false;
    public static boolean jukeboxEnabled = true;
    public static boolean jukeboxMultiplayer = true;
    public static float jukeboxReplaceRange = 0.0f;
    public static float jukeboxFadeRange = 48.0f;
    public static int jukeboxFadeMixTicks = 20;
    public static int jukeboxFadeStopTicks = 20;
    public static boolean rightClickToPlay = false;
    public static boolean chaoticallyPlayMusic = false;
    public static boolean injectUiComponents = true;

    public static void read() throws IOException {
        boolean replaces;
        if (Files.notExists(config, new LinkOption[0])) {
            Config.commit();
            return;
        }
        Properties properties = new Properties();
        try (InputStream configStream = Files.newInputStream(config, new OpenOption[0]);){
            properties.load(configStream);
        }
        int version = Config.toInt(properties, "version", 0);
        situationalMusicReplacing = version < 1 ? ((replaces = Config.toBoolean(properties, "allowReplacingCurrentMusic", true)) ? Replacing.allow : Replacing.never) : Config.toEnum(properties, "situationalMusicReplacing", Replacing.allow);
        fadeOutTicks = Config.toInt(properties, "fadeOutTicks", 600);
        fadeInTicks = Config.toInt(properties, "fadeInTicks", 600);
        immediatelyPlayOnReplace = Config.toBoolean(properties, "immediatelyPlayOnReplace", true);
        alwaysPlayMusic = Config.toBoolean(properties, "alwaysPlayMusic", false);
        seamlessTransitions = Config.toBoolean(properties, "seamlessTransitions", true);
        allowPausingMusic = Config.toBoolean(properties, "allowPausingMusic", false);
        jukeboxEnabled = Config.toBoolean(properties, "jukeboxEnabled", true);
        jukeboxMultiplayer = Config.toBoolean(properties, "jukeboxMultiplayer", true);
        jukeboxReplaceRange = Config.toFloat(properties, "jukeboxReplaceRange", 0.0f);
        jukeboxFadeRange = Config.toFloat(properties, "jukeboxFadeRange", 48.0f);
        jukeboxFadeMixTicks = Config.toInt(properties, "jukeboxFadeMixTicks", 20);
        jukeboxFadeStopTicks = Config.toInt(properties, "jukeboxFadeStopTicks", 20);
        rightClickToPlay = Config.toBoolean(properties, "rightClickToPlay", false);
        chaoticallyPlayMusic = Config.toBoolean(properties, "chaoticallyPlayMusic", false);
        injectUiComponents = Config.toBoolean(properties, "injectUiComponents", true);
    }

    public static void commit() throws IOException {
        Properties properties = new Properties();
        for (Field field : Config.class.getFields()) {
            try {
                Object value;
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || (value = field.get(null)) == null) continue;
                properties.setProperty(field.getName(), Objects.toString(value));
            }
            catch (ReflectiveOperationException roe) {
                throw new AssertionError("Unexpected access violation accessing self @ " + String.valueOf(field), roe);
            }
        }
        Files.createDirectories(configDir, new FileAttribute[0]);
        try (OutputStream configStream = Files.newOutputStream(config, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            properties.store(configStream, "Music Moods Config");
        }
    }

    private static <T extends Enum<T>> T toEnum(Properties properties, String key, T def) {
        String str = properties.getProperty(key);
        if (str == null) {
            return def;
        }
        for (Enum t : (Enum[])def.getClass().getEnumConstants()) {
            if (!t.name().equals(str)) continue;
            return (T)t;
        }
        return def;
    }

    private static boolean toBoolean(Properties properties, String key, boolean def) {
        String str = properties.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }

    private static int toInt(Properties properties, String key, int def) {
        String str = properties.getProperty(key);
        if (str == null) {
            return def;
        }
        return Integer.parseInt(str);
    }

    private static float toFloat(Properties properties, String key, float def) {
        String str = properties.getProperty(key);
        if (str == null) {
            return def;
        }
        return Float.parseFloat(str);
    }

    private static <T> T toMaybe(Properties properties, String key, Function<String, T> converter) {
        String str = properties.getProperty(key);
        if (str == null) {
            return null;
        }
        return converter.apply(str);
    }
}

