/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods;

import com.mojang.logging.LogUtils;
import gay.ampflower.musicmoods.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.slf4j.Logger;

public final class Sounds {
    private static final Logger logger = LogUtils.getLogger();
    private static final ResourceLocation id = Constants.id("sounds");
    private static final Map<ResourceLocation, Holder<SoundEvent>> toStereoEvent = new HashMap<ResourceLocation, Holder<SoundEvent>>();
    private static final Map<ResourceLocation, ResourceLocation> toStereo = new HashMap<ResourceLocation, ResourceLocation>();

    public static SoundEvent findStereo(SoundEvent soundEvent) {
        return (SoundEvent)Sounds.findStereo((Holder<SoundEvent>)Holder.direct((Object)soundEvent)).value();
    }

    public static Holder<SoundEvent> findStereo(Holder<SoundEvent> soundEvent) {
        if (soundEvent.value() == null) {
            logger.warn("Something has gone severely wrong, and null was passed in, bailing.");
            return Holder.direct(null);
        }
        return toStereoEvent.computeIfAbsent(((SoundEvent)soundEvent.value()).getLocation(), location -> Sounds.findStereoInternal(soundEvent, location));
    }

    private static Holder<SoundEvent> findStereoInternal(Holder<SoundEvent> soundEvent, ResourceLocation location) {
        ResourceLocation stereo = Sounds.findStereo(location);
        if (stereo.equals((Object)location)) {
            return soundEvent;
        }
        return new Holder.Direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)stereo));
    }

    public static ResourceLocation findStereo(ResourceLocation location) {
        return toStereo.computeIfAbsent(location, Sounds::findStereoInternal);
    }

    private static ResourceLocation findStereoInternal(ResourceLocation location) {
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(location.getPath().split("\\.")));
        ListIterator<String> itr = path.listIterator();
        while (true) {
            itr.add("stereo");
            ResourceLocation trial = location.withPath(String.join((CharSequence)".", path));
            if (soundManager.getSoundEvent(trial) != null) {
                logger.debug("Stereo found: {} => {}", (Object)location, (Object)trial);
                return trial;
            }
            logger.debug("Not present: {} => {}", (Object)location, (Object)trial);
            itr.previous();
            itr.remove();
            if (!itr.hasNext()) break;
            itr.next();
        }
        logger.debug("Stereo missing: {} => ???", (Object)location);
        return location;
    }

    private Sounds() {
    }
}

