/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.client;

import com.mojang.logging.LogUtils;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.option.SpruceCheckboxBooleanOption;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleOption;
import dev.lambdaurora.spruceui.option.SpruceFloatInputOption;
import dev.lambdaurora.spruceui.option.SpruceIntegerInputOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import dev.lambdaurora.spruceui.widget.container.tabbed.SpruceTabbedWidget;
import gay.ampflower.musicmoods.ClientMain;
import gay.ampflower.musicmoods.Config;
import gay.ampflower.musicmoods.Mint;
import gay.ampflower.musicmoods.config.OptionEnum;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import manifold.ext.props.rt.api.auto;
import manifold.ext.props.rt.api.propgen;
import manifold.ext.props.rt.api.val;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import org.slf4j.Logger;

public class ConfigurationScreen
extends SpruceScreen {
    private static final Logger logger = LogUtils.getLogger();
    private static final MethodHandles.Lookup SELF = MethodHandles.lookup();
    private final Screen parent;
    private SpruceTabbedWidget tabbedWidget;
    private boolean committed;

    public ConfigurationScreen(Screen parent) {
        super((Component)Component.translatable((String)"music-moods.gui.configuration"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.tabbedWidget = new SpruceTabbedWidget(Position.of((SprucePositioned)this, (int)0, (int)4), this.width, this.height - 35 - 4, this.title);
        this.addTabEntry("volume", this::buildVolumeList);
        this.addTabEntry("music", this::buildMusicOptionList);
        this.addTabEntry("jukebox", ConfigurationScreen::buildJukeboxOptionList);
        this.addTabEntry("demo", ConfigurationScreen::buildDemoList);
        this.addTabEntry("meta", ConfigurationScreen::buildMetaList);
        this.addRenderableWidget((GuiEventListener)this.tabbedWidget);
        this.addRenderableWidget((GuiEventListener)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(this.width / 2 - 75), (int)(this.height - 28)), 150, 20, SpruceTexts.GUI_DONE, btn -> this.onClose()));
    }

    public void removed() {
        if (!this.committed) {
            try {
                Config.commit();
                this.minecraft.options.save();
            }
            catch (IOException ioe) {
                logger.error("Failed to save Music Moods config. User not notified.", (Throwable)ioe);
            }
        }
    }

    public void onClose() {
        try {
            this.committed = true;
            Config.commit();
            this.minecraft.options.save();
            this.minecraft.setScreen(this.parent);
        }
        catch (IOException ioe) {
            logger.error("Failed to save Music Moods config", (Throwable)ioe);
            this.minecraft.setScreen((Screen)new ErrorScreen((Component)Component.translatable((String)"music-moods.gui.configuration.error"), (Component)Component.literal((String)ioe.getLocalizedMessage())));
        }
    }

    protected void addTabEntry(String name, SpruceTabbedWidget.ContainerFactory factory) {
        String key = "music-moods.gui.configuration." + name;
        this.tabbedWidget.addTabEntry((Component)Component.translatable((String)key), (Component)Component.translatable((String)(key + ".description")).withStyle(ChatFormatting.GRAY), factory);
    }

    protected SpruceOptionListWidget buildVolumeList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        SoundSource last = null;
        for (SoundSource value : SoundSource.values()) {
            if (value == SoundSource.MASTER) {
                list.addSingleOptionEntry((SpruceOption)this.toSlider(value));
                continue;
            }
            if (last == null) {
                last = value;
                continue;
            }
            list.addOptionEntry((SpruceOption)this.toSlider(last), (SpruceOption)this.toSlider(value));
            last = null;
        }
        if (last != null) {
            list.addSmallSingleOptionEntry((SpruceOption)this.toSlider(last));
        }
        list.addSingleOptionEntry((SpruceOption)this.getSoundDevices());
        list.addOptionEntry((SpruceOption)ConfigurationScreen.toCheckbox("showSubtitles", (OptionInstance<Boolean>)this.minecraft.options.showSubtitles(), (Component)Component.translatable((String)"options.showSubtitles.tooltip")), (SpruceOption)ConfigurationScreen.toCheckbox("directionalAudio", (OptionInstance<Boolean>)this.minecraft.options.directionalAudio(), (Component)Component.translatable((String)"options.directionalAudio.tooltip")));
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.checkbox("alwaysPlayMusic"));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError("Unexpected access violation", roe);
        }
        return list;
    }

    protected SpruceOptionListWidget buildMusicOptionList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("situationalMusic"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.cycling("situationalMusicReplacing"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.checkbox("immediatelyPlayOnReplace"), (SpruceOption)ConfigurationScreen.checkbox("alwaysPlayMusic"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("transitions"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.intInput("fadeInTicks"), (SpruceOption)ConfigurationScreen.intInput("fadeOutTicks"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.checkbox("seamlessTransitions"), (SpruceOption)ConfigurationScreen.checkbox("allowPausingMusic"));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError("Unexpected access violation", roe);
        }
        return list;
    }

    protected static SpruceOptionListWidget buildJukeboxOptionList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("jukebox"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.checkbox("jukeboxEnabled"), (SpruceOption)ConfigurationScreen.checkbox("jukeboxMultiplayer"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("jukeboxRange"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.floatSlider("jukeboxReplaceRange"), (SpruceOption)ConfigurationScreen.floatSlider("jukeboxFadeRange"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("transitions"));
            list.addOptionEntry((SpruceOption)ConfigurationScreen.intInput("jukeboxFadeMixTicks"), (SpruceOption)ConfigurationScreen.intInput("jukeboxFadeStopTicks"));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError("Unexpected access violation", roe);
        }
        return list;
    }

    protected static SpruceOptionListWidget buildDemoList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("modfest"));
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.checkbox("rightClickToPlay"));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError((Object)roe);
        }
        return list;
    }

    protected static SpruceOptionListWidget buildMetaList(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        try {
            list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("modPack"));
            if (ClientMain.isModMenuPresent) {
                list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.checkbox("injectUiComponents"));
            } else {
                list.addSingleOptionEntry((SpruceOption)ConfigurationScreen.separator("modMenu"));
            }
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError("Unexpected access violation", roe);
        }
        return list;
    }

    private SpruceDoubleOption toSlider(SoundSource source) {
        String key = "soundCategory." + source.getName();
        OptionInstance option = this.minecraft.options.getSoundSourceOptionInstance(source);
        return new SpruceDoubleOption(key, 0.0, 1.0, 0.01f, () -> ((OptionInstance)option).get(), arg_0 -> ((OptionInstance)option).set(arg_0), self -> ConfigurationScreen.genericPercentage(key, self.get()), ConfigurationScreen.translation(key + ".description"));
    }

    private static SpruceCheckboxBooleanOption toCheckbox(String name, OptionInstance<Boolean> option, Component tooltip) {
        String key = "options." + name;
        return new SpruceCheckboxBooleanOption(key, () -> option.get(), arg_0 -> option.set(arg_0), ConfigurationScreen.adapt(tooltip));
    }

    private SpruceCyclingOption getSoundDevices() {
        String key = "options.soundDevice";
        OptionInstance option = this.minecraft.options.soundDevice();
        DynamicStepper<String> stepper = new DynamicStepper<String>(() -> {
            List init = this.minecraft.getSoundManager().getAvailableSoundDevices();
            ArrayList<String> list = new ArrayList<String>(init.size() + 1);
            list.add("");
            list.addAll(init);
            return list;
        }, () -> ((OptionInstance)option).get(), arg_0 -> ((OptionInstance)option).set(arg_0), str -> {
            if ("".equals(str)) {
                return ConfigurationScreen.genericValue("options.audioDevice", "options.audioDevice.default");
            }
            if (str.startsWith("OpenAL Soft on ")) {
                str = str.substring(SoundEngine.OPEN_AL_SOFT_PREFIX_LENGTH);
            }
            return ConfigurationScreen.genericValue((Component)Component.translatable((String)"options.audioDevice"), (Component)Component.literal((String)str));
        });
        MutableComponent nl = Component.literal((String)"\n- ");
        MutableComponent tooltip = Component.translatable((String)"options.soundDevice.tooltip");
        for (String device : this.minecraft.getSoundManager().getAvailableSoundDevices()) {
            if (device.startsWith("OpenAL Soft on ")) {
                device = device.substring(SoundEngine.OPEN_AL_SOFT_PREFIX_LENGTH);
            }
            tooltip.append((Component)nl).append((Component)Component.literal((String)device).withStyle(ChatFormatting.YELLOW));
        }
        return new SpruceCyclingOption("options.soundDevice", stepper, stepper, ConfigurationScreen.adapt((Component)tooltip));
    }

    public static SpruceSeparatorOption separator(String field) {
        String key = "music-moods.option.separator." + field;
        return new SpruceSeparatorOption(key, true, ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceFloatInputOption floatSlider(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = SELF.findStaticVarHandle(Config.class, field, Float.TYPE);
        String key = "music-moods.option." + field;
        return new SpruceFloatInputOption(key, () -> Float.valueOf(handle.get()), (Consumer<Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Float ), (Ljava/lang/Float;)V)((VarHandle)handle), ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceIntegerInputOption intInput(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = SELF.findStaticVarHandle(Config.class, field, Integer.TYPE);
        String key = "music-moods.option." + field;
        return new SpruceIntegerInputOption(key, () -> handle.get(), (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Integer ), (Ljava/lang/Integer;)V)((VarHandle)handle), ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceCheckboxBooleanOption checkbox(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = SELF.findStaticVarHandle(Config.class, field, Boolean.TYPE);
        String key = "music-moods.option." + field;
        return new SpruceCheckboxBooleanOption(key, () -> handle.get(), (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Boolean ), (Ljava/lang/Boolean;)V)((VarHandle)handle), ConfigurationScreen.translation(key + ".description"));
    }

    public static SpruceCyclingOption cycling(String field) throws IllegalAccessException, NoSuchFieldException {
        VarHandle handle = ConfigurationScreen.findEnumField(field);
        Enum[] enums = (Enum[])handle.varType().getEnumConstants();
        String key = "music-moods.option." + field;
        EnumStepper stepper = new EnumStepper(enums, handle, key);
        return new SpruceCyclingOption(key, (Consumer)stepper, (Function)stepper, ConfigurationScreen.translation(key + ".description"));
    }

    private static <T extends Enum<T>> SpruceCyclingOption cycling(String key, Class<T> supplier, Supplier<T> getter, Consumer<T> setter, Function<T, Component> toName) {
        EnumStepper stepper = new EnumStepper((Enum[])supplier.getEnumConstants(), getter, setter, toName);
        return new SpruceCyclingOption(key, (Consumer)stepper, (Function)stepper, ConfigurationScreen.translation(key + ".description"));
    }

    private static <T> SpruceCyclingOption cycling(String key, Supplier<List<T>> supplier, Supplier<T> getter, Consumer<T> setter, Function<T, Component> toName) {
        DynamicStepper<T> stepper = new DynamicStepper<T>(supplier, getter, setter, toName);
        return new SpruceCyclingOption(key, stepper, stepper, ConfigurationScreen.translation(key + ".description"));
    }

    private static VarHandle findEnumField(String name) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = Config.class.getFields()) {
            if (!name.equals(field.getName())) continue;
            if (Enum.class.isAssignableFrom(field.getType())) {
                return SELF.unreflectVarHandle(field);
            }
            throw new NoSuchFieldException("Incompatible field " + String.valueOf(field));
        }
        throw new NoSuchFieldException("Cannot find " + name + " in Config");
    }

    private static Component genericValue(String key, String value) {
        return ConfigurationScreen.genericValue((Component)Component.translatable((String)key), (Component)Component.translatable((String)value));
    }

    private static Component genericValue(Component key, Component value) {
        return Component.translatable((String)"options.generic_value", (Object[])new Object[]{key, value});
    }

    private static Component genericPercentage(String key, double value) {
        return ConfigurationScreen.genericPercentage((Component)Component.translatable((String)key), (int)(value * 100.0));
    }

    private static Component genericPercentage(Component key, int value) {
        return Component.translatable((String)"options.percent_value", (Object[])new Object[]{key, value});
    }

    private static Component translation(String key) {
        return Component.translatable((String)key);
    }

    private static Component adapt(Component component) {
        return component;
    }

    private record DynamicStepper<T>(@val @auto(declaredAccess=2) @propgen(name="supplier", flags=0x2000000001000011L) Supplier<List<T>> supplier, @val @auto(declaredAccess=2) @propgen(name="getter", flags=0x2000000001000011L) Supplier<T> getter, @val @auto(declaredAccess=2) @propgen(name="setter", flags=0x2000000001000011L) Consumer<T> setter, @val @auto(declaredAccess=2) @propgen(name="toName", flags=0x2000000001000011L) Function<T, Component> toName) implements Consumer<Integer>,
    Function<SpruceCyclingOption, Component>
    {
        @Override
        public void accept(Integer integer) {
            List<T> list = this.supplier.get();
            T curr = this.getter.get();
            int index = list.indexOf(curr);
            int newIndex = Mint.wrapPositive(index + integer, list.size());
            this.setter.accept(list.get(newIndex));
        }

        @Override
        public Component apply(SpruceCyclingOption spruceCyclingOption) {
            return this.toName.apply(this.getter.get());
        }
    }

    private record EnumStepper<T extends Enum<T>>(@val @auto(declaredAccess=2) @propgen(name="enums", flags=0x2000000001000011L) T[] enums, @val @auto(declaredAccess=2) @propgen(name="getter", flags=0x2000000001000011L) Supplier<T> getter, @val @auto(declaredAccess=2) @propgen(name="setter", flags=0x2000000001000011L) Consumer<T> setter, @val @auto(declaredAccess=2) @propgen(name="toName", flags=0x2000000001000011L) Function<T, Component> toName) implements Consumer<Integer>,
    Function<SpruceCyclingOption, Component>
    {
        private EnumStepper(T[] enums, VarHandle handle, String key) {
            this((Enum[])enums, () -> handle.get(), (Consumer<Enum>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(java.lang.Enum ), (Ljava/lang/Enum;)V)((VarHandle)handle), value -> {
                String name = value.name().toLowerCase(Locale.ROOT);
                if (value instanceof OptionEnum) {
                    OptionEnum option = (OptionEnum)((Object)value);
                    return Component.translatable((String)key, (Object[])new Object[]{Component.translatable((String)("music-moods.option.value." + option.localizationClass() + "." + name))});
                }
                return Component.translatable((String)key, (Object[])new Object[]{Component.translatable((String)("music-moods.option.value." + name))});
            });
        }

        @Override
        public void accept(Integer integer) {
            int newIndex = (((Enum)this.getter.get()).ordinal() + integer) % this.enums.length;
            this.setter.accept(this.enums[newIndex]);
        }

        @Override
        public Component apply(SpruceCyclingOption self) {
            return this.toName.apply((Enum)this.getter.get());
        }
    }
}

