/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.client.sound;

import gay.ampflower.musicmoods.client.sound.Fadeable;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import manifold.ext.props.rt.api.auto;
import manifold.ext.props.rt.api.propgen;
import manifold.ext.props.rt.api.set;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;

public class FadeableSoundInstance
extends AbstractTickableSoundInstance
implements Fadeable {
    private static final float JUMP_LIMIT = 0.1f;
    protected final DeltaTracker.Timer timer = new DeltaTracker.Timer(20.0f, System.currentTimeMillis(), FloatUnaryOperator.identity());
    protected float maxVolume = 1.0f;
    @set
    @auto(declaredAccess=4)
    @propgen(name="fadeOut", flags=1L)
    protected float fadeOut;
    @set
    @auto(declaredAccess=4)
    @propgen(name="fadeIn", flags=1L)
    protected float fadeIn;

    protected final void advanceTimer() {
        this.timer.advanceTime(System.currentTimeMillis(), false);
    }

    protected final float getTickDelta() {
        return this.timer.getRealtimeDeltaTicks();
    }

    protected FadeableSoundInstance(SoundEvent soundEvent, SoundSource soundSource, RandomSource randomSource) {
        super(soundEvent, soundSource, randomSource);
    }

    public void tick() {
        float newVolume;
        this.advanceTimer();
        if (this.fadeOut > 0.0f && this.volume > 0.0f) {
            if (this.volume > 1.0f) {
                this.volume /= 2.0f;
            }
            if ((newVolume = Math.max(this.volume - Math.min(this.getTickDelta() / this.fadeOut, 0.1f), 0.0f)) == newVolume) {
                this.volume = newVolume;
            }
        }
        if (this.fadeIn > 0.0f && this.volume < this.maxVolume && (newVolume = Math.min(this.volume + Math.min(this.getTickDelta() / this.fadeIn, 0.1f), this.maxVolume)) == newVolume) {
            this.volume = newVolume;
        }
    }

    public boolean canStartSilent() {
        return this.fadeOut <= 0.0f && this.fadeIn > 0.0f;
    }

    public boolean isStopped() {
        return super.isStopped() || this.fadeOut > 0.0f && this.volume <= 0.0f;
    }

    @Override
    public void setFadeOut(float fadeOut) {
        this.fadeOut = fadeOut;
        this.fadeIn = 0.0f;
    }

    @Override
    public void setFadeIn(float fadeIn) {
        this.fadeIn = fadeIn;
        this.fadeOut = 0.0f;
    }
}

