/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.client.sound;

import gay.ampflower.musicmoods.client.sound.FadeableSoundInstance;
import gay.ampflower.musicmoods.client.sound.Relativeable;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class RecordSoundInstance
extends FadeableSoundInstance
implements Relativeable {
    private final Vec3 origin;
    private boolean relativeDirty;
    private boolean toRelative;
    private Vec3 delta;
    private Vec3 dest;
    private final float duration = 20.0f;

    public RecordSoundInstance(SoundEvent soundEvent, BlockPos origin) {
        this(soundEvent, (double)origin.getX() + 0.5, (double)origin.getY() + 0.5, (double)origin.getZ() + 0.5);
    }

    public RecordSoundInstance(SoundEvent soundEvent, double x, double y, double z) {
        super(soundEvent, SoundSource.RECORDS, SoundInstance.createUnseededRandom());
        this.origin = new Vec3(x, y, z);
        this.volume = 4.0f;
        this.maxVolume = 4.0f;
        this.pitch = 1.0f;
        this.x = x;
        this.y = y;
        this.z = z;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.dest != null && this.delta != null) {
            Vec3 scale = this.delta.scale((double)Math.min(this.getTickDelta(), 1.0f));
            this.x += scale.x();
            this.y += scale.y();
            this.z += scale.z();
            if (this.dest.distanceToSqr(this.x, this.y, this.z) < Math.max(this.delta.lengthSqr(), 0.1)) {
                if (this.toRelative) {
                    this.toRelative(null, null);
                } else {
                    this.x = this.dest.x();
                    this.y = this.dest.y();
                    this.z = this.dest.z();
                }
                this.dest = null;
                this.delta = null;
            }
        }
    }

    public void centerOnPlayer(Vec3 camera, Vec2 rotation) {
        if (this.relative && this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return;
        }
        this.toRelative = true;
        this.startTransition(camera);
    }

    public void centerOnOrigin(Vec3 camera, Vec2 rotation) {
        this.toRelative = false;
        this.fromRelative(camera, rotation);
        this.startTransition(this.origin);
    }

    private void fromRelative(Vec3 camera, Vec2 rotation) {
        if (this.relative) {
            this.x += camera.x();
            this.y += camera.y();
            this.z += camera.z();
            this.relativeDirty = true;
            this.relative = false;
        }
    }

    private void toRelative(Vec3 player, Vec2 rotation) {
        if (!this.relative) {
            this.move(Vec3.ZERO);
            this.relativeDirty = true;
            this.relative = true;
        }
    }

    private void startTransition(Vec3 dest) {
        if (dest.equals((Object)this.dest)) {
            return;
        }
        if (dest.x() == this.x && dest.y() == this.y && dest.z() == this.z) {
            return;
        }
        this.dest = dest;
        this.delta = dest.subtract(this.x, this.y, this.z).scale((double)0.05f);
    }

    public void move(Vec3 vec3) {
        this.x = vec3.x();
        this.y = vec3.y();
        this.z = vec3.z();
    }

    @Override
    public boolean isRelativeDirty() {
        return this.relativeDirty;
    }
}

