/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.mixin;

import gay.ampflower.musicmoods.Config;
import gay.ampflower.musicmoods.Mint;
import gay.ampflower.musicmoods.client.MusicHandler;
import gay.ampflower.musicmoods.client.WeighedSoundEventsQuery;
import gay.ampflower.musicmoods.client.sound.MusicSoundInstance;
import gay.ampflower.musicmoods.client.sound.RecordSoundInstance;
import gay.ampflower.musicmoods.config.Replacing;
import gay.ampflower.musicmoods.extensions.net.minecraft.sounds.Music.ExtMusic;
import gay.ampflower.musicmoods.mixin.AccessorLevelEventHandler;
import gay.ampflower.musicmoods.mixin.AccessorMinecraft;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class}, priority=500)
public abstract class MixinMusicManager
implements MusicHandler {
    @Shadow
    @Nullable
    private SoundInstance currentMusic;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private int nextSongDelay;
    @Shadow
    @Final
    private RandomSource random;
    @Unique
    private boolean currentMusicIntruded;
    @Unique
    private RecordSoundInstance focusedJukebox;
    @Unique
    private MusicSoundInstance fadingOutMusic;
    @Unique
    private ResourceLocation currentCompatibleLocation;

    @Overwrite
    public void tick() {
        MusicSoundInstance fadingOutMusic;
        Music musicInfo;
        if (Config.jukeboxEnabled && (Config.jukeboxMultiplayer || !((AccessorMinecraft)this.minecraft).invokeIsMultiplayerServer())) {
            this.handleRecords();
        }
        Music music = musicInfo = this.minecraft.getSituationalMusic();
        SoundManager soundManager = this.minecraft.getSoundManager();
        if (this.currentMusic != null && !soundManager.isActive(this.currentMusic)) {
            this.clearCurrent();
            this.nextSongDelay = this.deriveNextSongDelay(music);
        }
        if ((fadingOutMusic = this.fadingOutMusic) != null && !soundManager.isActive((SoundInstance)fadingOutMusic)) {
            fadingOutMusic = null;
            this.fadingOutMusic = null;
        }
        if (music == null) {
            this.handleMissingTrack();
            return;
        }
        ResourceLocation musicLocation = ExtMusic.getLocation(music);
        if (this.currentMusic != null && !this.currentMusicIntruded && Config.situationalMusicReplacing.replaces() && (this.isLoudAndCompatible(fadingOutMusic, musicLocation) || this.shouldReplace(music))) {
            this.fadeOrStopMusic();
            if (this.isCompatible((SoundInstance)fadingOutMusic, musicLocation)) {
                this.reset(0);
                this.currentMusic = fadingOutMusic;
                fadingOutMusic.setFadeIn(Config.fadeInTicks);
            } else if (Config.immediatelyPlayOnReplace) {
                this.startPlayingFadeIn(musicInfo);
            } else {
                this.clearCurrent();
                this.nextSongDelay = Mth.nextInt((RandomSource)this.random, (int)0, (int)(music.getMinDelay() / 2));
            }
        }
        if (this.focusedJukebox != null) {
            if (soundManager.isActive((SoundInstance)this.focusedJukebox)) {
                return;
            }
            this.focusedJukebox = null;
        }
        if ((Config.chaoticallyPlayMusic || this.currentMusic == null) && this.decrementSongDelay(music) <= 0) {
            if (fadingOutMusic != null) {
                this.startPlayingFadeIn(musicInfo);
            } else {
                this.startPlaying(musicInfo);
            }
        }
    }

    @Unique
    private int deriveNextSongDelay(Music music) {
        if (music == null) {
            return 100;
        }
        int minDelay = Config.alwaysPlayMusic ? 100 : (Config.chaoticallyPlayMusic ? 600 : music.getMinDelay());
        return Math.min(this.nextSongDelay, Mth.nextInt((RandomSource)this.random, (int)minDelay, (int)music.getMaxDelay()));
    }

    @Unique
    private void handleMissingTrack() {
        this.nextSongDelay = Math.max(this.nextSongDelay, 100);
        if (Config.situationalMusicReplacing == Replacing.always) {
            this.fadeOrStopMusic();
        }
    }

    @Unique
    private void handleRecords() {
        if (this.currentMusicIntruded) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        float fadeSq = Mint.square(Config.jukeboxFadeRange);
        float replSq = Mint.square(Config.jukeboxReplaceRange);
        float maxSq = Math.max(fadeSq, replSq);
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        Vec2 cameraRot = Mint.cameraToRotationVector(camera);
        if (maxSq <= 0.0f) {
            if (this.focusedJukebox != null) {
                this.focusedJukebox.centerOnOrigin(cameraPos, cameraRot);
                this.focusedJukebox = null;
            }
            return;
        }
        LevelRenderer levelEventHandler = this.minecraft.levelRenderer;
        Map<BlockPos, SoundInstance> map = ((AccessorLevelEventHandler)levelEventHandler).getPlayingJukeboxSongs();
        if (map.isEmpty() || map.size() > 128) {
            return;
        }
        SoundManager soundManager = this.minecraft.getSoundManager();
        Iterator<Map.Entry<BlockPos, SoundInstance>> itr = map.entrySet().iterator();
        RecordSoundInstance lastRecord = null;
        double lastDelta = Double.POSITIVE_INFINITY;
        while (itr.hasNext()) {
            Map.Entry<BlockPos, SoundInstance> entry = itr.next();
            if (!soundManager.isActive(entry.getValue())) {
                itr.remove();
                continue;
            }
            SoundInstance soundInstance = entry.getValue();
            if (!(soundInstance instanceof RecordSoundInstance)) continue;
            RecordSoundInstance record = (RecordSoundInstance)soundInstance;
            double delta = entry.getKey().distToCenterSqr((Position)player.getEyePosition());
            if (delta > (double)maxSq || !(delta < lastDelta)) continue;
            lastRecord = record;
            lastDelta = delta;
        }
        if (this.focusedJukebox != null && this.focusedJukebox != lastRecord) {
            this.focusedJukebox.centerOnOrigin(cameraPos, cameraRot);
        }
        if (lastRecord != null && lastDelta > (double)replSq) {
            lastRecord.centerOnOrigin(cameraPos, cameraRot);
        }
        this.focusedJukebox = lastRecord;
        if (lastRecord == null) {
            return;
        }
        if (lastDelta < (double)replSq) {
            lastRecord.centerOnPlayer(cameraPos, cameraRot);
        }
        this.fadeOrStopMusic(Config.jukeboxFadeMixTicks);
    }

    @Override
    public boolean moods$intrudeJukeboxTrack(@NotNull Holder<SoundEvent> soundEvent, @Nullable Component name) {
        if (this.currentMusicIntruded && this.isCompatible(this.currentMusic, ((SoundEvent)soundEvent.value()).getLocation())) {
            return false;
        }
        this.startPlayingIntruded(soundEvent, name);
        return true;
    }

    @Unique
    private boolean isLoudAndCompatible(MusicSoundInstance instance, ResourceLocation musicLocation) {
        if (instance == null || instance.getDirectVolume() < 0.75f) {
            return false;
        }
        return this.isCompatible((SoundInstance)instance, musicLocation);
    }

    @Unique
    private boolean shouldReplace(Music music) {
        return (Config.situationalMusicReplacing == Replacing.always || music.replaceCurrentMusic()) && this.isReplaceable(this.currentMusic, ExtMusic.getLocation(music));
    }

    @Unique
    private boolean isReplaceable(SoundInstance instance, ResourceLocation musicLocation) {
        return musicLocation != this.currentCompatibleLocation && !this.isCompatible(instance, musicLocation);
    }

    @Override
    public boolean moods$isCurrentlyPlaying(SoundEvent soundEvent) {
        if (!this.currentMusicIntruded) {
            return false;
        }
        return this.isCompatible(this.currentMusic, soundEvent.getLocation());
    }

    @Unique
    private boolean isCompatible(SoundInstance instance, ResourceLocation musicLocation) {
        WeighedSoundEventsQuery query;
        if (instance == null || musicLocation == null) {
            return false;
        }
        if (instance.getLocation().equals((Object)musicLocation)) {
            this.currentCompatibleLocation = musicLocation;
            return true;
        }
        WeighedSoundEvents weighedSounds = this.minecraft.getSoundManager().getSoundEvent(musicLocation);
        if (weighedSounds instanceof WeighedSoundEventsQuery && (query = (WeighedSoundEventsQuery)weighedSounds).contains(instance.getSound())) {
            this.currentCompatibleLocation = musicLocation;
            return true;
        }
        return false;
    }

    @Unique
    private int decrementSongDelay(Music music) {
        int maxDelay = music.getMaxDelay();
        if (Config.alwaysPlayMusic) {
            maxDelay = 100;
        }
        this.nextSongDelay = Math.min(this.nextSongDelay - 1, maxDelay);
        return this.nextSongDelay;
    }

    @Unique
    private void startPlayingFadeIn(Music music) {
        if (music == null) {
            return;
        }
        this.startPlayingCommon((Holder<SoundEvent>)music.getEvent(), null, 1.0f, (float)Config.fadeInTicks);
    }

    @Overwrite
    public void startPlaying(Music music) {
        if (music == null) {
            return;
        }
        this.startPlayingCommon((Holder<SoundEvent>)music.getEvent(), null, 1.0f, 0.0f);
    }

    @Unique
    private void startPlayingIntruded(Holder<SoundEvent> soundEventHolder, Component name) {
        this.reset(Config.jukeboxFadeMixTicks);
        this.currentMusicIntruded = true;
        this.startPlayingCommon(soundEventHolder, name, 1.0f, 0.0f);
    }

    @Unique
    private void startPlayingCommon(Holder<SoundEvent> soundEvent, @Nullable Component name, float volume, float fadeInTicks) {
        this.startPlayingCommon((SoundEvent)soundEvent.value(), name, volume, fadeInTicks);
    }

    @Unique
    private void startPlayingCommon(SoundEvent soundEvent, @Nullable Component name, float volume, float fadeInTicks) {
        this.currentMusic = new MusicSoundInstance(soundEvent, fadeInTicks);
        this.nextSongDelay = Integer.MAX_VALUE;
        if (this.currentMusic.getSound() == SoundManager.EMPTY_SOUND) {
            return;
        }
        this.minecraft.getSoundManager().play(this.currentMusic);
    }

    @Unique
    private void reset(int fadeOut) {
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        Vec2 cameraRot = Mint.cameraToRotationVector(camera);
        if (this.focusedJukebox != null) {
            this.focusedJukebox.centerOnOrigin(cameraPos, cameraRot);
            this.focusedJukebox = null;
        }
        this.fadeOrStopMusic(fadeOut);
    }

    @Unique
    private void fadeOrStopMusic() {
        this.fadeOrStopMusic(Config.fadeOutTicks);
    }

    @Unique
    private void fadeOrStopMusic(float fadeOut) {
        SoundInstance soundInstance;
        if (fadeOut > 0.0f && (soundInstance = this.currentMusic) instanceof MusicSoundInstance) {
            MusicSoundInstance music = (MusicSoundInstance)soundInstance;
            music.setFadeOut(fadeOut);
            this.fadingOutMusic = music;
            this.clearCurrent();
        } else {
            this.stopMusic();
        }
    }

    @Unique
    private void stopMusic() {
        this.minecraft.getSoundManager().stop(this.currentMusic);
        this.clearCurrent();
    }

    @Unique
    private void clearCurrent() {
        this.currentMusic = null;
        this.currentMusicIntruded = false;
        this.currentCompatibleLocation = null;
    }

    @Inject(method={"stopPlaying()V"}, at={@At(value="RETURN")})
    private void clearOnStopPlaying(CallbackInfo ci) {
        this.clearCurrent();
    }
}

