/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.audio.Channel;
import gay.ampflower.musicmoods.Config;
import gay.ampflower.musicmoods.client.SoundHandler;
import gay.ampflower.musicmoods.client.sound.MusicSoundInstance;
import gay.ampflower.musicmoods.client.sound.Relativeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public abstract class MixinSoundEngine
implements SoundHandler {
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;
    @Shadow
    @Final
    private Map<SoundInstance, Integer> queuedSounds;
    @Shadow
    @Final
    private List<TickableSoundInstance> queuedTickableSounds;
    @Shadow
    private boolean loaded;
    @Unique
    private final List<TickableSoundInstance> tickingWhilePaused = new ArrayList<TickableSoundInstance>();

    @Shadow
    public abstract void stop(SoundInstance var1);

    @Shadow
    protected abstract float calculateVolume(SoundInstance var1);

    @Shadow
    protected abstract float calculatePitch(SoundInstance var1);

    @ModifyArg(method={"tickNonPaused()V", "tickInGameSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/ChannelAccess$ChannelHandle;execute(Ljava/util/function/Consumer;)V"))
    private Consumer<Channel> consumerAudioEquipmentIsQuiteNeatIsntIt(Consumer<Channel> original, @Local TickableSoundInstance sound) {
        Relativeable relativeable;
        if (!(sound instanceof Relativeable) || !(relativeable = (Relativeable)sound).isRelativeDirty()) {
            return original;
        }
        boolean relative = sound.isRelative();
        return channel -> {
            original.accept((Channel)channel);
            channel.setRelative(relative);
        };
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="TAIL")})
    private void tickHook(boolean paused, CallbackInfo ci) {
        if (!paused) {
            return;
        }
        Iterator<TickableSoundInstance> iterator = this.tickingWhilePaused.iterator();
        while (iterator.hasNext()) {
            TickableSoundInstance sound = iterator.next();
            if (!sound.canPlaySound()) {
                this.stop((SoundInstance)sound);
                iterator.remove();
                continue;
            }
            sound.tick();
            if (sound.isStopped()) {
                this.stop((SoundInstance)sound);
                iterator.remove();
                continue;
            }
            ChannelAccess.ChannelHandle handle = this.instanceToChannel.get(sound);
            if (handle == null) continue;
            this.tickSound((SoundInstance)sound, handle);
        }
    }

    @Inject(method={"pause()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPause(CallbackInfo ci) {
        if (Config.allowPausingMusic) {
            return;
        }
        ci.cancel();
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry : this.instanceToChannel.entrySet()) {
            if (entry.getKey() instanceof MusicSoundInstance) {
                this.tickingWhilePaused.add((TickableSoundInstance)entry.getKey());
                continue;
            }
            entry.getValue().execute(Channel::pause);
        }
    }

    @Inject(method={"resume()V"}, at={@At(value="HEAD")})
    private void onResume(CallbackInfo ci) {
        this.tickingWhilePaused.clear();
    }

    @Inject(method={"stopAll()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/sounds/SoundEngine;tickingSounds:Ljava/util/List;", shift=At.Shift.AFTER)})
    private void onStopAll(CallbackInfo ci) {
        this.tickingWhilePaused.clear();
    }

    @Unique
    private void tickSound(SoundInstance sound, ChannelAccess.ChannelHandle handle) {
        boolean relative;
        boolean relativeDirty;
        float v = this.calculateVolume(sound);
        float p = this.calculatePitch(sound);
        Vec3 pos = new Vec3(sound.getX(), sound.getY(), sound.getZ());
        if (sound instanceof Relativeable) {
            Relativeable relativeable = (Relativeable)sound;
            relativeDirty = relativeable.isRelativeDirty();
            relative = sound.isRelative();
        } else {
            relativeDirty = false;
            relative = false;
        }
        handle.execute(channel -> {
            channel.setVolume(v);
            channel.setPitch(p);
            channel.setSelfPosition(pos);
            if (relativeDirty) {
                channel.setRelative(relative);
            }
        });
    }

    @Override
    public void moods$stopMusic() {
        if (!this.loaded) {
            return;
        }
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry : this.instanceToChannel.entrySet()) {
            if (!MixinSoundEngine.isMusic(entry.getKey())) continue;
            entry.getValue().execute(Channel::stop);
        }
    }

    @Override
    public void moods$stopSounds() {
        if (!this.loaded) {
            return;
        }
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry : this.instanceToChannel.entrySet()) {
            if (!MixinSoundEngine.isNotMusic(entry.getKey())) continue;
            entry.getValue().execute(Channel::stop);
        }
    }

    @Override
    public void moods$fadeSounds(float ticks) {
        if (!this.loaded) {
            return;
        }
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void moods$clearQueued() {
        this.queuedSounds.clear();
        this.queuedTickableSounds.clear();
    }

    @Unique
    private static boolean isMusic(SoundInstance instance) {
        return instance instanceof MusicSoundInstance;
    }

    @Unique
    private static boolean isNotMusic(SoundInstance instance) {
        return !(instance instanceof MusicSoundInstance);
    }
}

