/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.mixin;

import gay.ampflower.musicmoods.client.WeighedSoundEventsQuery;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import manifold.ext.props.rt.api.auto;
import manifold.ext.props.rt.api.propgen;
import manifold.ext.props.rt.api.val;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WeighedSoundEvents.class})
public class MixinWeighedSoundEvents
implements WeighedSoundEventsQuery {
    @Unique
    private static final Logger logger = LoggerFactory.getLogger((String)"Music Moods Weighed Sounds Query");
    @Shadow
    @Final
    private List<Weighted<Sound>> list;
    @Unique
    @val
    @auto(declaredAccess=2)
    @propgen(name="set", flags=262146L)
    private Set<ResourceLocation> set = Set.of();

    @Override
    public boolean contains(Sound sound) {
        Set<ResourceLocation> set2 = this.getSet();
        return set2.contains(sound.getLocation());
    }

    @Unique
    private Set<ResourceLocation> getSet() {
        Set<ResourceLocation> soundSet;
        int size = this.list.size();
        if (size != (soundSet = this.set).size()) {
            HashSet<ResourceLocation> newSoundSet = new HashSet<ResourceLocation>(size);
            for (Weighted<Sound> weightedSound : this.list) {
                MixinWeighedSoundEvents subWeighed;
                if (weightedSound instanceof Sound) {
                    Sound subSound = (Sound)weightedSound;
                    newSoundSet.add(subSound.getLocation());
                    continue;
                }
                if (!(weightedSound instanceof MixinWeighedSoundEvents) || this == (subWeighed = (MixinWeighedSoundEvents)weightedSound)) continue;
                newSoundSet.addAll(subWeighed.getSet());
            }
            this.set = Set.of(newSoundSet.toArray(new ResourceLocation[newSoundSet.size()]));
            return this.set;
        }
        return soundSet;
    }
}

