/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.musicmoods.util;

import gay.ampflower.musicmoods.Config;
import gay.ampflower.musicmoods.Constants;
import gay.ampflower.musicmoods.client.MusicHandler;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;

public final class JukeboxUtil {
    public static void appendRightClickToPlay(Consumer<Component> tooltipConsumer, Function<RegistryAccess, Optional<JukeboxSong>> song) {
        if (!Config.rightClickToPlay) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        Optional<JukeboxSong> optionalSong = song.apply(level.registryAccess());
        if (optionalSong.isEmpty()) {
            return;
        }
        MusicHandler musicHandler = (MusicHandler)minecraft.getMusicManager();
        tooltipConsumer.accept(musicHandler.moods$isCurrentlyPlaying(optionalSong.get()) ? Constants.rightClickToStopTooltip : Constants.rightClickToPlayTooltip);
    }

    public static Optional<JukeboxSong> toStereoElseMono(RegistryAccess access, EitherHolder<JukeboxSong> mono) {
        return JukeboxUtil.toStereoElseMono(access, mono.unwrap((HolderLookup.Provider)access));
    }

    public static Optional<JukeboxSong> toStereoElseMono(RegistryAccess access, ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return Optional.empty();
        }
        return JukeboxUtil.toStereoElseMono(access, JukeboxSong.fromStack((HolderLookup.Provider)access, (ItemStack)itemStack));
    }

    public static Optional<JukeboxSong> toStereoElseMono(RegistryAccess access, Optional<Holder<JukeboxSong>> optionalMono) {
        if (optionalMono.isEmpty()) {
            return Optional.empty();
        }
        Holder<JukeboxSong> mono = optionalMono.get();
        return mono.unwrapKey().flatMap(k -> ((HolderLookup.RegistryLookup)access.lookup(Registries.JUKEBOX_SONG).orElseThrow()).get(ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)Constants.toStereo(k.location()))).map(Holder.Reference::value)).or(() -> Optional.of((JukeboxSong)mono.value()));
    }
}

