/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.archeological.block;

import java.util.List;
import net.mcreator.archeological.procedures.StatuePlacementConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CuriousStatueBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public CuriousStatueBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.MUD_BRICKS).strength(1.0f, 2.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.archeological.curious_statue.description_0"));
        list.add((Component)Component.translatable((String)"block.archeological.curious_statue.description_1"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)CuriousStatueBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0), (VoxelShape[])new VoxelShape[]{CuriousStatueBlock.box((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)12.0, (double)16.0), CuriousStatueBlock.box((double)14.0, (double)3.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0), CuriousStatueBlock.box((double)0.0, (double)3.0, (double)4.0, (double)2.0, (double)7.0, (double)12.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)CuriousStatueBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0), (VoxelShape[])new VoxelShape[]{CuriousStatueBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)12.0, (double)2.0), CuriousStatueBlock.box((double)0.0, (double)3.0, (double)4.0, (double)2.0, (double)7.0, (double)12.0), CuriousStatueBlock.box((double)14.0, (double)3.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)CuriousStatueBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0), (VoxelShape[])new VoxelShape[]{CuriousStatueBlock.box((double)14.0, (double)6.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0), CuriousStatueBlock.box((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)7.0, (double)2.0), CuriousStatueBlock.box((double)4.0, (double)3.0, (double)14.0, (double)12.0, (double)7.0, (double)16.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)CuriousStatueBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0), (VoxelShape[])new VoxelShape[]{CuriousStatueBlock.box((double)0.0, (double)6.0, (double)6.0, (double)2.0, (double)12.0, (double)10.0), CuriousStatueBlock.box((double)4.0, (double)3.0, (double)14.0, (double)12.0, (double)7.0, (double)16.0), CuriousStatueBlock.box((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)7.0, (double)2.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return StatuePlacementConditionProcedure.execute(world, x, y, z);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }
}

