/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.fabric.network;

import com.google.auto.service.AutoService;
import dev.corgitaco.dataanchor.DataAnchor;
import dev.corgitaco.dataanchor.fabric.network.FabricPacketBroadcaster;
import dev.corgitaco.dataanchor.network.C2SNetworkContainer;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.C2SPacketBroadcaster;
import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@AutoService(value={C2SPacketBroadcaster.class})
public class C2SFabricPacketBroadcaster
extends FabricPacketBroadcaster
implements C2SPacketBroadcaster {
    @Override
    public void registerPackets() {
        C2SNetworkContainer.C2S_NAMESPACED_CONTAINERS.forEach((modId, networkContainer) -> networkContainer.registerMessages(this::register));
    }

    @Override
    public class_2960 channelName(Class<? extends Packet> packetClass) {
        return (class_2960)this.packetIds.get(packetClass);
    }

    @Override
    public <T extends Packet> void registerReceiver(class_2960 id, Function<class_2540, T> decode, Packet.Handle<T> handler) {
        C2SFabricPacketBroadcaster.registerServerReceiver(id, decode, handler);
    }

    @Override
    public <MSG extends Packet> void sendToServer(MSG packet) {
        class_2960 packetId = (class_2960)this.packetIds.get(packet.getClass());
        BiConsumer encoder = (BiConsumer)this.encoders.get(packet.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(packet, buf);
        ClientPlayNetworking.send((class_2960)packetId, (class_2540)buf);
    }

    protected static <T extends Packet> void registerServerReceiver(class_2960 id, Function<class_2540, T> decode, Packet.Handle<T> handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (server, player, handler1, buf, responseSender) -> {
            buf.retain();
            server.execute(() -> {
                Packet packet = (Packet)decode.apply(buf);
                class_1937 level = player.method_37908();
                try {
                    handler.handle(packet, level, (class_1657)player);
                }
                catch (Throwable throwable) {
                    DataAnchor.LOGGER.error("Packet \"%s\" failed: ".formatted(id.toString()), throwable);
                    throw throwable;
                }
                buf.release();
            });
        });
    }
}

