/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.fabric.network;

import com.google.auto.service.AutoService;
import dev.corgitaco.dataanchor.DataAnchor;
import dev.corgitaco.dataanchor.fabric.DataAnchorFabric;
import dev.corgitaco.dataanchor.fabric.network.FabricPacketBroadcaster;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.S2CNetworkContainer;
import dev.corgitaco.dataanchor.network.broadcast.S2CPacketBroadcaster;
import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_5321;
import net.minecraft.class_5629;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;

@AutoService(value={S2CPacketBroadcaster.class})
public class S2CFabricPacketBroadcaster
extends FabricPacketBroadcaster
implements S2CPacketBroadcaster {
    @Override
    public void registerPackets() {
        S2CNetworkContainer.S2C_NAMESPACED_CONTAINERS.forEach((modId, networkContainer) -> networkContainer.registerMessages(this::register));
    }

    @Override
    public class_2960 channelName(Class<? extends Packet> packetClass) {
        return (class_2960)this.packetIds.get(packetClass);
    }

    @Override
    public <T extends Packet> void registerReceiver(class_2960 id, Function<class_2540, T> decode, Packet.Handle<T> handler) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.registerClientReceiver(id, decode, handler);
        }
    }

    @Override
    public <MSG extends Packet> void sendToPlayer(MSG msg, class_3222 player) {
        class_2960 packetId = (class_2960)this.packetIds.get(msg.getClass());
        BiConsumer encoder = (BiConsumer)this.encoders.get(msg.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(msg, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf);
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayers(MSG msg) {
        MinecraftServer server = DataAnchorFabric.server;
        for (class_3222 player : server.method_3760().method_14571()) {
            this.sendToPlayer(msg, player);
        }
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayersInDimension(MSG msg, class_5321<class_1937> dimensionKey) {
        MinecraftServer server = DataAnchorFabric.server;
        for (class_3222 player : server.method_3847(dimensionKey).method_18456()) {
            this.sendToPlayer(msg, player);
        }
    }

    @Override
    public <MSG extends Packet> void sendNearPositionInDimension(MSG msg, class_5321<class_1937> dimensionKey, double x, double y, double z, double radius) {
        MinecraftServer server = DataAnchorFabric.server;
        for (class_3222 player : server.method_3847(dimensionKey).method_18456()) {
            if (!(player.method_5649(x, y, z) <= class_3532.method_33723((double)radius))) continue;
            this.sendToPlayer(msg, player);
        }
    }

    @Override
    public <MSG extends Packet> void trackingEntity(MSG msg, class_1297 entity) {
        MinecraftServer server = DataAnchorFabric.server;
        class_3218 level = server.method_3847(entity.method_37908().method_27983());
        class_3898.class_3208 trackedEntity = (class_3898.class_3208)level.method_14178().field_17254.field_18242.get(entity.method_5628());
        if (trackedEntity != null) {
            for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                class_3222 player = serverPlayerConnection.method_32311();
                this.sendToPlayer(msg, player);
            }
        }
    }

    @Override
    public <MSG extends Packet> void trackingEntityAndSelf(MSG msg, class_1297 entity) {
        MinecraftServer server = DataAnchorFabric.server;
        class_3218 level = server.method_3847(entity.method_37908().method_27983());
        class_3898.class_3208 trackedEntity = (class_3898.class_3208)level.method_14178().field_17254.field_18242.get(entity.method_5628());
        if (trackedEntity != null) {
            for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                class_3222 player = serverPlayerConnection.method_32311();
                this.sendToPlayer(msg, player);
            }
            class_1297 class_12972 = trackedEntity.field_18247;
            if (class_12972 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_12972;
                this.sendToPlayer(msg, serverPlayer);
            }
        }
    }

    @Override
    public <MSG extends Packet> void trackingChunk(MSG msg, class_2818 chunk) {
        MinecraftServer server = DataAnchorFabric.server;
        class_3218 level = server.method_3847(chunk.method_12200().method_27983());
        class_3898 chunkMap = level.method_14178().field_17254;
        chunkMap.method_17210(chunk.method_12004(), false).forEach(serverPlayer -> this.sendToPlayer(msg, (class_3222)serverPlayer));
    }

    public record ClientProxy() {
        public static <T extends Packet> void registerClientReceiver(class_2960 id, Function<class_2540, T> decode, Packet.Handle<T> handler) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, listener, buf, responseSender) -> {
                buf.retain();
                client.execute(() -> {
                    Packet packet = (Packet)decode.apply(buf);
                    class_638 level = client.field_1687;
                    if (level != null) {
                        try {
                            handler.handle(packet, (class_1937)level, (class_1657)class_310.method_1551().field_1724);
                        }
                        catch (Throwable throwable) {
                            DataAnchor.LOGGER.error("Packet \"%s\" failed: ".formatted(id.toString()), throwable);
                            throw throwable;
                        }
                    }
                    buf.release();
                });
            });
        }
    }
}

