/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.network;

import dev.corgitaco.dataanchor.network.Packet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;

public abstract class NetworkContainer {
    private final Map<class_2960, Packet.Handler<? extends Packet>> packets = new HashMap<class_2960, Packet.Handler<? extends Packet>>();
    private final String nameSpace;
    private boolean locked = false;

    public NetworkContainer(String namespace) {
        this.nameSpace = namespace;
    }

    public <T extends Packet> void registerPacketHandler(String name, Packet.Handler<T> packetHandle) {
        if (this.locked) {
            throw new IllegalArgumentException("Network Container for namespace \"%s\" is already locked, try registering earlier!".formatted(this.nameSpace));
        }
        this.packets.put(new class_2960(this.nameSpace, name), packetHandle);
    }

    public void registerMessages(BiConsumer<class_2960, Packet.Handler<? extends Packet>> handlerConsumer) {
        this.packets.forEach(handlerConsumer);
        this.locked = true;
    }
}

