/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.network;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public abstract class NetworkContainer
implements PacketBroadcaster {
    private final Map<ResourceLocation, Packet.Handler<? extends Packet>> packets = new HashMap<ResourceLocation, Packet.Handler<? extends Packet>>();
    private final String nameSpace;
    private boolean locked = false;

    public NetworkContainer(String namespace) {
        this.nameSpace = namespace;
    }

    public <T extends Packet> void registerPacketHandler(String name, Class<T> packet) {
        this.registerPacketHandler(name, new Packet.Handler<T>(packet));
    }

    public <T extends Packet> void registerPacketHandler(String name, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> write, Function<FriendlyByteBuf, T> read, Packet.Handle<T> handle) {
        this.registerPacketHandler(name, new Packet.Handler<T>(clazz, write, read, handle));
    }

    public <T extends Packet> void registerPacketHandler(String name, Packet.Handler<T> packetHandle) {
        if (this.locked) {
            throw new IllegalArgumentException("Network Container for namespace \"%s\" is already locked, try registering earlier!".formatted(this.nameSpace));
        }
        this.packets.put(new ResourceLocation(this.nameSpace, name), packetHandle);
    }

    public void registerMessages(BiConsumer<ResourceLocation, Packet.Handler<? extends Packet>> handlerConsumer) {
        this.packets.forEach(handlerConsumer);
        this.locked = true;
    }
}

