/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.mixin;

import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import dev.corgitaco.dataanchor.data.type.blockentity.BlockEntityTrackedData;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntity.class})
public class BlockEntityMixin
implements TrackedDataContainer<BlockEntity, BlockEntityTrackedData> {
    @Shadow
    @Nullable
    protected Level level;
    @Unique
    @Nullable
    private TrackedDataContainer<BlockEntity, BlockEntityTrackedData> dataAnchor$container;

    @Inject(method={"setLevel(Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void dataAnchor$setLevel(Level level, CallbackInfo ci) {
        this.dataAnchor$createTrackedData();
    }

    @Override
    public <E extends BlockEntityTrackedData> Optional<E> dataAnchor$getTrackedData(TrackedDataKey<E> key) {
        if (this.dataAnchor$container == null) {
            return Optional.empty();
        }
        return this.dataAnchor$container.dataAnchor$getTrackedData(key);
    }

    @Override
    public void dataAnchor$createTrackedData() {
        if (this.dataAnchor$container == null) {
            this.dataAnchor$container = TrackedDataContainer.makeBasicContainer(TrackedDataRegistries.BLOCK_ENTITY, (BlockEntity)this, this.level != null && this.level.isClientSide());
            this.dataAnchor$container.dataAnchor$createTrackedData();
        }
    }

    @Override
    public Collection<TrackedDataKey<BlockEntityTrackedData>> dataAnchor$getTrackedDataKeys() {
        if (this.dataAnchor$container == null) {
            return Collections.emptyList();
        }
        return this.dataAnchor$container.dataAnchor$getTrackedDataKeys();
    }

    @Inject(method={"loadStatic(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/level/block/entity/BlockEntity;"}, at={@At(value="RETURN")})
    private static void dataAnchor$loadStatic(BlockPos pos, BlockState state, CompoundTag tag, HolderLookup.Provider registries, CallbackInfoReturnable<BlockEntity> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof TrackedDataContainer) {
            TrackedDataContainer container = (TrackedDataContainer)object;
            container.dataAnchor$createTrackedData();
            if (tag.contains("TrackedData")) {
                CompoundTag trackedData = tag.getCompoundOrEmpty("TrackedData");
                Collection keys = container.dataAnchor$getTrackedDataKeys();
                for (TrackedDataKey key : keys) {
                    container.dataAnchor$getTrackedData(key).ifPresent(data -> {
                        if (data instanceof BlockEntityTrackedData) {
                            BlockEntityTrackedData blockEntityTrackedData = (BlockEntityTrackedData)data;
                            String idString = key.getId().toString();
                            if (trackedData.contains(idString)) {
                                blockEntityTrackedData.load(trackedData.getCompoundOrEmpty(idString));
                            }
                        }
                    });
                }
            }
        }
    }

    @Inject(method={"saveWithFullMetadata(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    private void dataAnchor$saveWithFullMetadata(CallbackInfoReturnable<CompoundTag> cir) {
        if (this.dataAnchor$container != null) {
            CompoundTag trackedData = new CompoundTag();
            for (TrackedDataKey<BlockEntityTrackedData> key : this.dataAnchor$container.dataAnchor$getTrackedDataKeys()) {
                this.dataAnchor$container.dataAnchor$getTrackedData(key).ifPresent(data -> {
                    CompoundTag save = data.save();
                    if (save != null) {
                        trackedData.put(key.getId().toString(), (Tag)save);
                    }
                });
            }
            ((CompoundTag)cir.getReturnValue()).put("TrackedData", (Tag)trackedData);
        }
    }
}

