/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.mixin;

import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.chunk.ChunkTrackedData;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SerializableChunkData.class})
public class SerializableChunkDataMixin {
    @Shadow
    @Final
    private CompoundTag structureData;

    @Inject(method={"copyOf(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;)Lnet/minecraft/world/level/chunk/storage/SerializableChunkData;"}, at={@At(value="RETURN")})
    private static void dataAnchor$write(ServerLevel level, ChunkAccess chunk, CallbackInfoReturnable<SerializableChunkData> cir) {
        if (chunk instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)chunk;
            CompoundTag tag = ((SerializableChunkData)cir.getReturnValue()).structureData();
            CompoundTag trackedDataTag = new CompoundTag();
            Collection keys = trackedDataContainer.dataAnchor$getTrackedDataKeys();
            for (TrackedDataKey key : keys) {
                trackedDataContainer.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                    ChunkTrackedData chunkTrackedData;
                    CompoundTag save;
                    if (trackedData instanceof ChunkTrackedData && (save = (chunkTrackedData = (ChunkTrackedData)trackedData).save()) != null) {
                        trackedDataTag.put(key.getId().toString(), (Tag)save);
                    }
                });
            }
            tag.put("TrackedData", (Tag)trackedDataTag);
        }
    }

    @Inject(method={"read(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/ai/village/poi/PoiManager;Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Lnet/minecraft/world/level/ChunkPos;)Lnet/minecraft/world/level/chunk/ProtoChunk;"}, at={@At(value="RETURN")})
    private void dataAnchor$read(ServerLevel level, PoiManager poiManager, RegionStorageInfo regionStorageInfo, ChunkPos pos, CallbackInfoReturnable<ProtoChunk> cir) {
        ChunkAccess returnValue = (ChunkAccess)cir.getReturnValue();
        CompoundTag tag = this.structureData;
        if (returnValue instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposterProtoChunk = (ImposterProtoChunk)returnValue;
            returnValue = imposterProtoChunk.getWrapped();
        }
        if (returnValue instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)returnValue;
            tag.getCompound("TrackedData").ifPresent(trackedDataTag -> {
                for (TrackedDataKey key : trackedDataContainer.dataAnchor$getTrackedDataKeys()) {
                    trackedDataContainer.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                        if (trackedData instanceof ChunkTrackedData) {
                            ChunkTrackedData chunkTrackedData = (ChunkTrackedData)trackedData;
                            String idString = key.getId().toString();
                            if (trackedDataTag.contains(idString)) {
                                chunkTrackedData.load((CompoundTag)trackedDataTag.getCompound(idString).orElseThrow());
                            }
                        }
                    });
                }
            });
        }
    }
}

