/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.neoforge.network;

import com.google.auto.service.AutoService;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.S2CPacketBroadcaster;
import dev.corgitaco.dataanchor.network.register.S2CPacketRegister;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@AutoService(value={S2CPacketBroadcaster.class, S2CPacketRegister.class})
public class S2CNeoForgePacketBroadcaster
implements S2CPacketBroadcaster,
S2CPacketRegister {
    @Override
    public <MSG extends Packet> void sendToPlayer(MSG msg, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayers(MSG msg) {
        PacketDistributor.sendToServer(msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayersInDimension(MSG msg, ResourceKey<Level> dimension) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        PacketDistributor.sendToPlayersInDimension((ServerLevel)server.getLevel(dimension), msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <MSG extends Packet> void sendNearPositionInDimension(MSG msg, ResourceKey<Level> dimension, double x, double y, double z, double radius) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        PacketDistributor.sendToPlayersNear((ServerLevel)server.getLevel(dimension), null, (double)x, (double)y, (double)z, (double)radius, msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <MSG extends Packet> void trackingEntity(MSG msg, Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <MSG extends Packet> void trackingEntityAndSelf(MSG msg, Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <MSG extends Packet> void trackingChunk(MSG msg, LevelChunk chunk) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)chunk.getLevel()), (ChunkPos)chunk.getPos(), msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void registerPackets() {
    }
}

