/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public interface TrackedData<T>
extends Supplier<T> {
    @Nullable
    default public CompoundTag save() {
        try {
            return (CompoundTag)TrackedData.toTag(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    default public void load(CompoundTag tag) {
        try {
            TrackedData.updateExistingFromTag((Tag)tag, this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Tag toTag(Object obj) throws IllegalAccessException {
        if (obj instanceof Integer) {
            return IntTag.valueOf((int)((Integer)obj));
        }
        if (obj instanceof Boolean) {
            return ByteTag.valueOf((byte)((Boolean)obj != false ? (byte)1 : 0));
        }
        if (obj instanceof Long) {
            return LongTag.valueOf((long)((Long)obj));
        }
        if (obj instanceof Float) {
            return FloatTag.valueOf((float)((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return DoubleTag.valueOf((double)((Double)obj));
        }
        if (obj instanceof Byte) {
            return ByteTag.valueOf((byte)((Byte)obj));
        }
        if (obj instanceof Short) {
            return ShortTag.valueOf((short)((Short)obj));
        }
        if (obj instanceof String) {
            return StringTag.valueOf((String)((String)obj));
        }
        if (obj instanceof int[]) {
            return new IntArrayTag((int[])obj);
        }
        if (obj instanceof long[]) {
            return new LongArrayTag((long[])obj);
        }
        if (obj instanceof byte[]) {
            return new ByteArrayTag((byte[])obj);
        }
        if (obj instanceof float[]) {
            float[] floats = (float[])obj;
            ListTag list = new ListTag();
            for (float aFloat : floats) {
                list.add((Object)FloatTag.valueOf((float)aFloat));
            }
            return list;
        }
        if (obj instanceof double[]) {
            ListTag list = new ListTag();
            for (double aDouble : (double[])obj) {
                list.add((Object)DoubleTag.valueOf((double)aDouble));
            }
            return list;
        }
        if (obj instanceof boolean[]) {
            ListTag list = new ListTag();
            for (boolean b : (boolean[])obj) {
                list.add((Object)ByteTag.valueOf((byte)(b ? (byte)1 : 0)));
            }
            return list;
        }
        if (obj instanceof short[]) {
            ListTag list = new ListTag();
            for (short s : (short[])obj) {
                list.add((Object)ShortTag.valueOf((short)s));
            }
            return list;
        }
        if (obj instanceof char[]) {
            return StringTag.valueOf((String)new String((char[])obj));
        }
        if (obj instanceof Collection) {
            ListTag listTag = new ListTag();
            for (Object o : (Collection)obj) {
                listTag.add((Object)TrackedData.toTag(o));
            }
            return listTag;
        }
        if (obj instanceof Map) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                compoundTag.put(entry.getKey().toString(), TrackedData.toTag(entry.getValue()));
            }
            return compoundTag;
        }
        if (obj instanceof Enum) {
            return StringTag.valueOf((String)((Enum)obj).name());
        }
        CompoundTag tag = new CompoundTag();
        for (Field declaredField : obj.getClass().getDeclaredFields()) {
            int modifiers = declaredField.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            declaredField.setAccessible(true);
            Object obj1 = declaredField.get(obj);
            if (obj1 == null) continue;
            tag.put(declaredField.getName(), TrackedData.toTag(obj1));
        }
        return tag;
    }

    public static <T> T updateExistingFromTag(Tag tag, T obj) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            for (Field declaredField : obj.getClass().getDeclaredFields()) {
                int i;
                ListTag list;
                Class<?> declaringClass;
                SerializedName annotation;
                int modifiers = declaredField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                declaredField.setAccessible(true);
                String name = declaredField.getName();
                if (declaredField.isAnnotationPresent(SerializedName.class) && !compoundTag.contains(name = (annotation = declaredField.getAnnotation(SerializedName.class)).value()) && annotation.alternate().length > 0) {
                    for (String string : annotation.alternate()) {
                        if (!compoundTag.contains(string)) continue;
                        name = string;
                        break;
                    }
                }
                if ((declaringClass = declaredField.getType()).isPrimitive()) {
                    if (declaringClass == Boolean.TYPE || declaringClass == Boolean.class) {
                        declaredField.set(obj, (boolean)((Boolean)compoundTag.getBoolean(name).get()));
                    }
                    if (declaringClass == Integer.TYPE || declaringClass == Integer.class) {
                        declaredField.set(obj, (int)((Integer)compoundTag.getInt(name).get()));
                    }
                    if (declaringClass == Long.TYPE || declaringClass == Long.class) {
                        declaredField.set(obj, (long)((Long)compoundTag.getLong(name).get()));
                    }
                    if (declaringClass == Float.TYPE || declaringClass == Float.class) {
                        declaredField.set(obj, Float.valueOf(((Float)compoundTag.getFloat(name).get()).floatValue()));
                    }
                    if (declaringClass == Double.TYPE || declaringClass == Double.class) {
                        declaredField.set(obj, (double)((Double)compoundTag.getDouble(name).get()));
                    }
                    if (declaringClass == Byte.TYPE || declaringClass == Byte.class) {
                        declaredField.set(obj, (byte)((Byte)compoundTag.getByte(name).get()));
                    }
                    if (declaringClass == Short.TYPE || declaringClass == Short.class) {
                        declaredField.set(obj, (short)((Short)compoundTag.getShort(name).get()));
                    }
                    if (declaringClass == Character.TYPE || declaringClass == Character.class) {
                        declaredField.set(obj, Character.valueOf((char)((Integer)compoundTag.getInt(name).get()).intValue()));
                    }
                }
                if (declaringClass == String.class) {
                    declaredField.set(obj, compoundTag.getString(name));
                }
                if (declaringClass.isInstance(Collection.class)) {
                    Object o = declaredField.get(obj);
                    if (o instanceof Collection) {
                        Collection collection = (Collection)o;
                        collection.clear();
                        ListTag list2 = compoundTag.getListOrEmpty(name);
                        for (Tag tag12 : list2) {
                            collection.add(TrackedData.fromTag(tag12, null));
                        }
                    }
                    declaredField.set(obj, compoundTag.getListOrEmpty(name));
                }
                if (declaredField.getType().isEnum()) {
                    declaredField.set(obj, Enum.valueOf(declaredField.getType(), (String)compoundTag.getString(name).get()));
                }
                if (!declaredField.getType().isArray()) continue;
                if (declaringClass == int[].class) {
                    declaredField.set(obj, compoundTag.getIntArray(name));
                }
                if (declaringClass == long[].class) {
                    declaredField.set(obj, compoundTag.getLongArray(name));
                }
                if (declaringClass == byte[].class) {
                    declaredField.set(obj, compoundTag.getByteArray(name));
                }
                if (declaringClass == float[].class) {
                    list = compoundTag.getListOrEmpty(name);
                    float[] result = new float[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        FloatTag floatTag = (FloatTag)list.get(i);
                        result[i] = floatTag.floatValue();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == double[].class) {
                    list = compoundTag.getListOrEmpty(name);
                    double[] result = new double[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        DoubleTag doubleTag = (DoubleTag)list.get(i);
                        result[i] = doubleTag.doubleValue();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == boolean[].class) {
                    list = compoundTag.getListOrEmpty(name);
                    boolean[] result = new boolean[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        ByteTag byteTag = (ByteTag)list.get(i);
                        result[i] = byteTag.byteValue() == 1;
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == short[].class) {
                    list = compoundTag.getListOrEmpty(name);
                    short[] result = new short[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        ShortTag shortTag = (ShortTag)list.get(i);
                        result[i] = shortTag.shortValue();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == char[].class) {
                    list = compoundTag.getListOrEmpty(name);
                    char[] result = new char[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        IntTag intTag = (IntTag)list.get(i);
                        result[i] = (char)intTag.intValue();
                    }
                    declaredField.set(obj, result);
                }
                if (!declaringClass.isInstance(Map.class)) continue;
                declaredField.set(obj, TrackedData.fromTag(compoundTag.get(name), declaredField.getType()));
            }
        }
        return obj;
    }

    public static <T> T fromTag(Tag tag, Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return (T)Integer.valueOf(intTag.intValue());
        }
        if (tag instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            return (T)Long.valueOf(longTag.longValue());
        }
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            return (T)Float.valueOf(floatTag.floatValue());
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return (T)Double.valueOf(doubleTag.doubleValue());
        }
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return (T)Byte.valueOf(byteTag.byteValue());
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            return (T)Short.valueOf(shortTag.shortValue());
        }
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, stringTag.value());
            }
            return (T)stringTag.value();
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            return (T)intArrayTag.getAsIntArray();
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            return (T)longArrayTag.getAsLongArray();
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            return (T)byteArrayTag.getAsByteArray();
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            HashMap<String, Tag> entries = new HashMap<String, Tag>();
            for (String key : compoundTag.keySet()) {
                entries.put(key, compoundTag.get(key));
            }
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field declaredField : clazz.getDeclaredFields()) {
                int modifiers = declaredField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                declaredField.setAccessible(true);
                String name = TrackedData.getName(declaredField, entries);
                Tag tag1 = (Tag)entries.get(name);
                if (tag1 == null) continue;
                declaredField.set(t, TrackedData.fromTag(tag1, declaredField.getType()));
            }
            return t;
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (t instanceof Collection) {
                Collection collection = (Collection)t;
                for (Tag tag1 : listTag) {
                    collection.add(TrackedData.fromTag(tag1, clazz));
                }
            }
            return t;
        }
        return null;
    }

    private static String getName(Field declaredField, Map<String, Tag> entries) {
        SerializedName annotation;
        String name = declaredField.getName();
        if (declaredField.isAnnotationPresent(SerializedName.class) && !entries.containsKey(name = (annotation = declaredField.getAnnotation(SerializedName.class)).value()) && annotation.alternate().length > 0) {
            for (String s : annotation.alternate()) {
                if (!entries.containsKey(s)) continue;
                name = s;
                break;
            }
        }
        return name;
    }
}

