/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.mixin;

import dev.corgitaco.dataanchor.data.TickableTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.entity.PlayerTrackedData;
import dev.corgitaco.dataanchor.data.type.entity.SyncedPlayerTrackedData;
import dev.corgitaco.dataanchor.data.type.level.SyncedLevelTrackedData;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level {
    protected ServerLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"}, at={@At(value="RETURN")})
    private void dataAnchor$onTickChunk(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        if (chunk instanceof TrackedDataContainer) {
            TrackedDataContainer access = (TrackedDataContainer)chunk;
            Collection keys = access.dataAnchor$getTrackedDataKeys();
            for (TrackedDataKey key : keys) {
                access.dataAnchor$getTrackedData(key).ifPresent(data -> {
                    if (data instanceof TickableTrackedData) {
                        TickableTrackedData tickableData = (TickableTrackedData)data;
                        tickableData.tick();
                    }
                });
            }
        }
        if (chunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING)) {
            for (BlockEntity value : chunk.getBlockEntities().values()) {
                if (!(value instanceof TrackedDataContainer)) continue;
                TrackedDataContainer access = (TrackedDataContainer)value;
                Collection keys = access.dataAnchor$getTrackedDataKeys();
                for (TrackedDataKey key : keys) {
                    access.dataAnchor$getTrackedData(key).ifPresent(data -> {
                        if (data instanceof TickableTrackedData) {
                            TickableTrackedData tickableData = (TickableTrackedData)data;
                            tickableData.tick();
                        }
                    });
                }
            }
        }
    }

    @Inject(method={"addRespawnedPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="RETURN")})
    private void dataAnchor$addRespawnTeleport(ServerPlayer player, CallbackInfo ci) {
        if (player instanceof TrackedDataContainer) {
            TrackedDataContainer access = (TrackedDataContainer)player;
            Collection keys = access.dataAnchor$getTrackedDataKeys();
            for (TrackedDataKey key : keys) {
                access.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                    if (trackedData instanceof PlayerTrackedData) {
                        PlayerTrackedData data = (PlayerTrackedData)trackedData;
                        data.addRespawnedPlayer();
                    }
                });
            }
        }
    }

    @Inject(method={"addDuringTeleport(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="RETURN")})
    private void dataAnchor$addDuringPortalTeleport(Entity entity, CallbackInfo ci) {
        if (entity instanceof TrackedDataContainer) {
            TrackedDataContainer access = (TrackedDataContainer)entity;
            Collection keys = access.dataAnchor$getTrackedDataKeys();
            for (TrackedDataKey key : keys) {
                access.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                    if (trackedData instanceof PlayerTrackedData) {
                        PlayerTrackedData data = (PlayerTrackedData)trackedData;
                        data.addDuringPortalTeleport();
                    }
                });
            }
        }
    }

    @Inject(method={"addPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="RETURN")})
    private void dataAnchor$onPlayerAddToWorld(ServerPlayer player, CallbackInfo ci) {
        TrackedDataKey key;
        Iterator iterator;
        Object keys;
        TrackedDataContainer access;
        if (player instanceof TrackedDataContainer) {
            access = (TrackedDataContainer)player;
            keys = access.dataAnchor$getTrackedDataKeys();
            iterator = keys.iterator();
            while (iterator.hasNext()) {
                key = (TrackedDataKey)iterator.next();
                access.dataAnchor$getTrackedData(key).ifPresent(data -> {
                    if (data instanceof PlayerTrackedData) {
                        PlayerTrackedData playerTrackedData = (PlayerTrackedData)data;
                        playerTrackedData.playerAddedToWorld();
                        if (data instanceof SyncedPlayerTrackedData) {
                            SyncedPlayerTrackedData syncedData = (SyncedPlayerTrackedData)data;
                            syncedData.syncToPlayer(player);
                        }
                    }
                });
            }
        }
        if ((keys = this) instanceof TrackedDataContainer) {
            access = (TrackedDataContainer)keys;
            keys = access.dataAnchor$getTrackedDataKeys();
            iterator = keys.iterator();
            while (iterator.hasNext()) {
                key = (TrackedDataKey)iterator.next();
                access.dataAnchor$getTrackedData(key).ifPresent(data -> {
                    if (data instanceof SyncedLevelTrackedData) {
                        SyncedLevelTrackedData syncedData = (SyncedLevelTrackedData)data;
                        syncedData.syncToPlayer(player);
                    }
                });
            }
        }
    }
}

