/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.core.BlockBox;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NearestPoint<T> {
    public static final int[][][] SPIRAL_FAST_2D = NearestPoint.spiral2D(32);
    public static final int[][][] SPIRAL_FAST_3D = NearestPoint.spiral3D(32);

    public void setPoint(Vec3i var1, T var2);

    public void removePoint(Vec3i var1);

    @Nullable
    public PointData<T> getNearestPointData(Vec3i var1, DistanceFunction var2);

    public Collection<PointData<T>> getPointDataWithinRange(Vec3i var1, double var2, DistanceFunction var4);

    default public void removePointsWithinRange(PointData<T> point, int range, DistanceFunction distanceFunction) {
        Collection<PointData<T>> pointsWithinRange = this.getPointDataWithinRange(point.point, range, distanceFunction);
        for (PointData<T> vec3i : pointsWithinRange) {
            this.removePoint(vec3i.point);
        }
    }

    public boolean isEmpty();

    public Collection<PointData<T>> getAllPointData();

    public void clear();

    default public Collection<PointData<T>> getPointDataInBox(Vec3i min, Vec3i max) {
        return this.getPointDataWithinRange(NearestPoint.getCenter(min, max), (double)NearestPoint.chebyshevDistance(min.getX(), min.getY(), max.getX(), max.getY()) / 2.0, NearestPoint::chebyshevDistance);
    }

    default public Collection<PointData<T>> getPointDataInBox(BlockBox box) {
        return this.getPointDataInBox((Vec3i)box.min(), (Vec3i)box.max());
    }

    default public Collection<PointData<T>> getPointDataInBox(BoundingBox box) {
        return this.getPointDataInBox(new Vec3i(box.minX(), box.minY(), box.minZ()), new Vec3i(box.maxX(), box.maxY(), box.maxZ()));
    }

    default public Collection<PointData<T>> getPointDataInBox(Vec3i center, int radius) {
        return this.getPointDataInBox(new Vec3i(center.getX() - radius, center.getY() - radius, center.getZ() - radius), new Vec3i(center.getX() + radius, center.getY() + radius, center.getZ() + radius));
    }

    default public void removePointsInBox(Vec3i min, Vec3i max) {
        Collection<PointData<T>> pointsWithinRange = this.getPointDataInBox(min, max);
        for (PointData<T> vec3i : pointsWithinRange) {
            this.removePoint(vec3i.point);
        }
    }

    default public void removePointsInBox(BlockBox box) {
        this.removePointsInBox((Vec3i)box.min(), (Vec3i)box.max());
    }

    default public void removePointsInBox(BoundingBox box) {
        this.removePointsInBox(new Vec3i(box.minX(), box.minY(), box.minZ()), new Vec3i(box.maxX(), box.maxY(), box.maxZ()));
    }

    default public void removePointsInBox(Vec3i center, int radius) {
        this.removePointsInBox(new Vec3i(center.getX() - radius, center.getY() - radius, center.getZ() - radius), new Vec3i(center.getX() + radius, center.getY() + radius, center.getZ() + radius));
    }

    @Nullable
    default public Vec3i getNearestPoint(Vec3i point, DistanceFunction distanceFunction) {
        PointData<T> nearestPointData = this.getNearestPointData(point, distanceFunction);
        if (nearestPointData == null) {
            return null;
        }
        return nearestPointData.point();
    }

    default public Collection<Vec3i> getPointsInBox(Vec3i min, Vec3i max) {
        return this.getVec3is(this.getPointDataInBox(min, max));
    }

    default public Collection<Vec3i> getPointsInBox(Vec3i center, int radius) {
        return this.getVec3is(this.getPointDataInBox(center, radius));
    }

    default public Collection<Vec3i> getPointsInBox(BlockBox box) {
        return this.getVec3is(this.getPointDataInBox(box));
    }

    default public Collection<Vec3i> getPointsInBox(BoundingBox box) {
        return this.getVec3is(this.getPointDataInBox(box));
    }

    public static int chebyshevDistance(Vec3i min, Vec3i max) {
        return NearestPoint.chebyshevDistance(min.getX(), min.getZ(), max.getX(), max.getZ());
    }

    public static int chebyshevDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        return Math.max(dx, Math.max(dy, dz));
    }

    public static int chebyshevDistance(int x1, int y1, int x2, int y2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        return Math.max(dx, dy);
    }

    private static Vec3i getCenter(Vec3i point1, Vec3i point2) {
        int centerX = (point1.getX() + point2.getX()) / 2;
        int centerY = (point1.getY() + point2.getY()) / 2;
        int centerZ = (point1.getZ() + point2.getZ()) / 2;
        return new Vec3i(centerX, centerY, centerZ);
    }

    @NotNull
    private List<Vec3i> getVec3is(Collection<PointData<T>> pointsInBox) {
        ArrayList<Vec3i> points = new ArrayList<Vec3i>();
        for (PointData<T> inBox : pointsInBox) {
            points.add(inBox.point());
        }
        return Collections.unmodifiableList(points);
    }

    public static int[][][] spiral2D(int size) {
        TreeMap<Integer, List> distanceMap = new TreeMap<Integer, List>();
        for (int x = -size; x <= size; ++x) {
            int z = -size;
            while (z <= size) {
                int distance = NearestPoint.chebyshevDistance(0, 0, x, z);
                distanceMap.computeIfAbsent(distance, dist -> new ArrayList()).add(new int[]{x, z++});
            }
        }
        ArrayList<int[][]> offsets = new ArrayList<int[][]>();
        for (List value : distanceMap.values()) {
            offsets.add((int[][])value.toArray(x$0 -> new int[x$0][]));
        }
        return (int[][][])offsets.toArray((T[])new int[offsets.size()][][]);
    }

    public static int[][][] spiral3D(int size) {
        TreeMap<Integer, List> distanceMap = new TreeMap<Integer, List>();
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                int z = -size;
                while (z <= size) {
                    int distance = NearestPoint.chebyshevDistance(0, 0, 0, x, y, z);
                    distanceMap.computeIfAbsent(distance, dist -> new ArrayList()).add(new int[]{x, y, z++});
                }
            }
        }
        ArrayList<int[][]> offsets = new ArrayList<int[][]>();
        for (List value : distanceMap.values()) {
            offsets.add((int[][])value.toArray(x$0 -> new int[x$0][]));
        }
        return (int[][][])offsets.toArray((T[])new int[offsets.size()][][]);
    }

    public record PointData<T>(T value, Vec3i point) {
    }

    @FunctionalInterface
    public static interface DistanceFunction {
        public double apply(Vec3i var1, Vec3i var2);
    }
}

