/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.storage._2D;

import dev.corgitaco.dataanchor.DataAnchor;
import dev.corgitaco.dataanchor.storage.NearestPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;

public class QuadTreeNearestPointData<T>
implements NearestPoint<T> {
    private final NearestPoint<T>[] leafs;
    private final byte bitShiftScale;
    private final byte highestShiftScale;

    public QuadTreeNearestPointData(int highestShiftScale) {
        this(0, (byte)highestShiftScale, 2);
    }

    public static <T> QuadTreeNearestPointData<T> fromSize(int xzSize) {
        return new QuadTreeNearestPointData<T>((byte)(32 - Integer.numberOfLeadingZeros(xzSize)));
    }

    public QuadTreeNearestPointData() {
        this(0, 31, 2);
    }

    public QuadTreeNearestPointData(byte bitShiftScale, byte highestShiftScale, int rowSize) {
        this.bitShiftScale = bitShiftScale;
        this.highestShiftScale = highestShiftScale;
        if (bitShiftScale < 0 || bitShiftScale > 31) {
            throw new IllegalArgumentException("bitShiftScale must be between 0 and 31");
        }
        if (rowSize < 2) {
            throw new IllegalArgumentException("rowSize must be greater than 1");
        }
        int smallestEncompassingPowerOfTwo = Mth.smallestEncompassingPowerOfTwo((int)rowSize);
        if (smallestEncompassingPowerOfTwo != rowSize) {
            DataAnchor.LOGGER.warn("rowSize is not a power of two, rounding up to the nearest power of two...");
            rowSize = smallestEncompassingPowerOfTwo;
        }
        this.leafs = new NearestPoint[rowSize * rowSize];
    }

    @Override
    public void setPoint(Vec3i point, T o) {
        int x = point.getX();
        int z = point.getZ();
        int xIndex = this.getXZIndex(x);
        int zIndex = this.getXZIndex(z);
        this.setPointRecursively(point, o, this.getIndex(xIndex, zIndex));
    }

    private void setPointRecursively(Vec3i point, T o, int index) {
        if (this.bitShiftScale == this.highestShiftScale) {
            if (this.leafs[index] == null) {
                this.leafs[index] = new Target<T>(new NearestPoint.PointData<T>(o, point));
            }
            return;
        }
        if (this.leafs[index] == null) {
            this.leafs[index] = new QuadTreeNearestPointData<T>((byte)(this.bitShiftScale + 1), this.highestShiftScale, this.rowSize());
        }
        this.leafs[index].setPoint(point, o);
    }

    @Override
    public NearestPoint.PointData<T> getNearestPointData(Vec3i point, NearestPoint.DistanceFunction distanceFunction) {
        int x = point.getX();
        int z = point.getZ();
        int xIndex = this.getXZIndex(x);
        int zIndex = this.getXZIndex(z);
        NearestPoint.PointData<T> nearest = null;
        for (int i = 0; i < this.rowSize(); ++i) {
            int[][] distance;
            for (int[] position : distance = SPIRAL_FAST_2D[i]) {
                NearestPoint.PointData<T> offsetNearest;
                NearestPoint<T> offsetNearestPoint;
                int offsetX = position[0];
                int offsetZ = position[1];
                int offsetXIndex = offsetX + xIndex;
                int offsetZIndex = offsetZ + zIndex;
                int index = this.getIndex(offsetXIndex, offsetZIndex);
                if (offsetXIndex < 0 || offsetXIndex >= this.rowSize() || offsetZIndex < 0 || offsetZIndex >= this.rowSize() || (offsetNearestPoint = this.leafs[index]) == null || (offsetNearest = offsetNearestPoint.getNearestPointData(point, distanceFunction)) == null) continue;
                if (nearest == null) {
                    nearest = offsetNearest;
                    continue;
                }
                if (!(distanceFunction.apply(nearest.point(), point) > distanceFunction.apply(offsetNearest.point(), point))) continue;
                nearest = offsetNearest;
            }
            if (i <= 0 || nearest == null) continue;
            return nearest;
        }
        return nearest;
    }

    @Override
    public Collection<NearestPoint.PointData<T>> getPointDataWithinRange(Vec3i point, double radius, NearestPoint.DistanceFunction distanceFunction) {
        int x = point.getX();
        int z = point.getZ();
        TreeSet<NearestPoint.PointData<T>> points = new TreeSet<NearestPoint.PointData<T>>(Comparator.comparing(pointData -> distanceFunction.apply(point, pointData.point())));
        int xIndex = this.getXZIndex(x);
        int zIndex = this.getXZIndex(z);
        for (int i = 0; i < this.rowSize(); ++i) {
            int[][] distance;
            for (int[] position : distance = SPIRAL_FAST_2D[i]) {
                NearestPoint.PointData<T> offsetNearest;
                NearestPoint<T> offsetNearestPoint;
                int offsetX = position[0];
                int offsetZ = position[1];
                int offsetXIndex = offsetX + xIndex;
                int offsetZIndex = offsetZ + zIndex;
                if (offsetXIndex < 0 || offsetXIndex >= this.rowSize() || offsetZIndex < 0 || offsetZIndex >= this.rowSize() || (offsetNearestPoint = this.leafs[this.getIndex(offsetXIndex, offsetZIndex)]) == null || !(distanceFunction.apply((offsetNearest = offsetNearestPoint.getNearestPointData(point, distanceFunction)).point(), point) <= radius)) continue;
                points.add(offsetNearest);
            }
        }
        return points;
    }

    private int getXZIndex(int coord) {
        return coord >> this.highestShiftScale - this.bitShiftScale & this.rowSize() - 1;
    }

    public int rowSize() {
        return this.leafs.length >> 1;
    }

    private int getIndex(int x, int z) {
        return x * this.rowSize() + z;
    }

    @Override
    public boolean isEmpty() {
        for (NearestPoint<T> leaf : this.leafs) {
            if (leaf == null || leaf.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<NearestPoint.PointData<T>> getAllPointData() {
        ArrayList<NearestPoint.PointData<T>> points = new ArrayList<NearestPoint.PointData<T>>();
        for (NearestPoint<T> leaf : this.leafs) {
            if (leaf == null || leaf.isEmpty()) continue;
            points.addAll(leaf.getAllPointData());
        }
        return Collections.unmodifiableList(points);
    }

    @Override
    public void clear() {
        Arrays.fill(this.leafs, null);
    }

    @Override
    public void removePoint(Vec3i point) {
        int x = point.getX();
        int z = point.getZ();
        int xIndex = this.getXZIndex(x);
        int zIndex = this.getXZIndex(z);
        this.removePointRecursively(point, this.getIndex(xIndex, zIndex));
    }

    private void removePointRecursively(Vec3i point, int index) {
        NearestPoint<T> nearestPoint = this.leafs[index];
        if (this.bitShiftScale == this.highestShiftScale) {
            if (nearestPoint != null) {
                this.leafs[index] = null;
            }
            return;
        }
        if (nearestPoint != null) {
            nearestPoint.removePoint(point);
            if (nearestPoint.isEmpty()) {
                this.leafs[index] = null;
            }
        }
    }

    public record Target<T>(NearestPoint.PointData<T> pointData) implements NearestPoint<T>
    {
        @Override
        public void setPoint(Vec3i point, T o) {
            throw new IllegalArgumentException("Cannot set lowest level point, use constructor.");
        }

        @Override
        public NearestPoint.PointData<T> getNearestPointData(Vec3i point, NearestPoint.DistanceFunction distanceFunction) {
            return this.pointData;
        }

        @Override
        public Collection<NearestPoint.PointData<T>> getPointDataWithinRange(Vec3i point, double radius, NearestPoint.DistanceFunction distanceFunction) {
            return distanceFunction.apply(point, this.pointData.point()) <= radius ? Collections.singleton(this.pointData) : Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Collection<NearestPoint.PointData<T>> getAllPointData() {
            return Collections.singleton(this.pointData);
        }

        @Override
        public void clear() {
            throw new IllegalArgumentException("Cannot clear lowest level point");
        }

        @Override
        public void removePoint(Vec3i point) {
            throw new IllegalArgumentException("Cannot remove lowest level point");
        }
    }
}

