/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.network;

import dev.corgitaco.dataanchor.network.Packet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;

public abstract class NetworkContainer {
    private final Map<ResourceLocation, Packet.Handler<? extends Packet>> packets = new HashMap<ResourceLocation, Packet.Handler<? extends Packet>>();
    private final String nameSpace;
    private boolean locked = false;

    public NetworkContainer(String namespace) {
        this.nameSpace = namespace;
    }

    public <T extends Packet> void registerPacketHandler(String name, Packet.Handler<T> packetHandle) {
        if (this.locked) {
            throw new IllegalArgumentException("Network Container for namespace \"%s\" is already locked, try registering earlier!".formatted(this.nameSpace));
        }
        this.packets.put(new ResourceLocation(this.nameSpace, name), packetHandle);
    }

    public void registerMessages(BiConsumer<ResourceLocation, Packet.Handler<? extends Packet>> handlerConsumer) {
        this.packets.forEach(handlerConsumer);
        this.locked = true;
    }
}

