/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public interface TrackedData<T>
extends Supplier<T> {
    @Nullable
    default public class_2487 save() {
        try {
            return (class_2487)TrackedData.toTag(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    default public void load(class_2487 tag) {
        try {
            TrackedData.updateExistingFromTag((class_2520)tag, this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_2520 toTag(Object obj) throws IllegalAccessException {
        if (obj instanceof Integer) {
            return class_2497.method_23247((int)((Integer)obj));
        }
        if (obj instanceof Boolean) {
            return class_2481.method_23233((byte)((Boolean)obj != false ? (byte)1 : 0));
        }
        if (obj instanceof Long) {
            return class_2503.method_23251((long)((Long)obj));
        }
        if (obj instanceof Float) {
            return class_2494.method_23244((float)((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return class_2489.method_23241((double)((Double)obj));
        }
        if (obj instanceof Byte) {
            return class_2481.method_23233((byte)((Byte)obj));
        }
        if (obj instanceof Short) {
            return class_2516.method_23254((short)((Short)obj));
        }
        if (obj instanceof String) {
            return class_2519.method_23256((String)((String)obj));
        }
        if (obj instanceof int[]) {
            return new class_2495((int[])obj);
        }
        if (obj instanceof long[]) {
            return new class_2501((long[])obj);
        }
        if (obj instanceof byte[]) {
            return new class_2479((byte[])obj);
        }
        if (obj instanceof float[]) {
            float[] floats = (float[])obj;
            class_2499 list = new class_2499();
            for (float aFloat : floats) {
                list.add((Object)class_2494.method_23244((float)aFloat));
            }
            return list;
        }
        if (obj instanceof double[]) {
            class_2499 list = new class_2499();
            for (double aDouble : (double[])obj) {
                list.add((Object)class_2489.method_23241((double)aDouble));
            }
            return list;
        }
        if (obj instanceof boolean[]) {
            class_2499 list = new class_2499();
            for (boolean b : (boolean[])obj) {
                list.add((Object)class_2481.method_23233((byte)(b ? (byte)1 : 0)));
            }
            return list;
        }
        if (obj instanceof short[]) {
            class_2499 list = new class_2499();
            for (short s : (short[])obj) {
                list.add((Object)class_2516.method_23254((short)s));
            }
            return list;
        }
        if (obj instanceof char[]) {
            return class_2519.method_23256((String)new String((char[])obj));
        }
        if (obj instanceof Collection) {
            class_2499 listTag = new class_2499();
            for (Object o : (Collection)obj) {
                listTag.add((Object)TrackedData.toTag(o));
            }
            return listTag;
        }
        if (obj instanceof Map) {
            class_2487 compoundTag = new class_2487();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                compoundTag.method_10566(entry.getKey().toString(), TrackedData.toTag(entry.getValue()));
            }
            return compoundTag;
        }
        if (obj instanceof Enum) {
            return class_2519.method_23256((String)((Enum)obj).name());
        }
        class_2487 tag = new class_2487();
        for (Field declaredField : obj.getClass().getDeclaredFields()) {
            int modifiers = declaredField.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            declaredField.setAccessible(true);
            Object obj1 = declaredField.get(obj);
            if (obj1 == null) continue;
            tag.method_10566(declaredField.getName(), TrackedData.toTag(obj1));
        }
        return tag;
    }

    public static <T> T updateExistingFromTag(class_2520 tag, T obj) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        if (tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            for (Field declaredField : obj.getClass().getDeclaredFields()) {
                int i;
                class_2499 list;
                Class<?> declaringClass;
                SerializedName annotation;
                int modifiers = declaredField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                declaredField.setAccessible(true);
                String name = declaredField.getName();
                if (declaredField.isAnnotationPresent(SerializedName.class) && !compoundTag.method_10545(name = (annotation = declaredField.getAnnotation(SerializedName.class)).value()) && annotation.alternate().length > 0) {
                    for (String string : annotation.alternate()) {
                        if (!compoundTag.method_10545(string)) continue;
                        name = string;
                        break;
                    }
                }
                if ((declaringClass = declaredField.getType()).isPrimitive()) {
                    if (declaringClass == Boolean.TYPE || declaringClass == Boolean.class) {
                        declaredField.set(obj, (boolean)((Boolean)compoundTag.method_10577(name).get()));
                    }
                    if (declaringClass == Integer.TYPE || declaringClass == Integer.class) {
                        declaredField.set(obj, (int)((Integer)compoundTag.method_10550(name).get()));
                    }
                    if (declaringClass == Long.TYPE || declaringClass == Long.class) {
                        declaredField.set(obj, (long)((Long)compoundTag.method_10537(name).get()));
                    }
                    if (declaringClass == Float.TYPE || declaringClass == Float.class) {
                        declaredField.set(obj, Float.valueOf(((Float)compoundTag.method_10583(name).get()).floatValue()));
                    }
                    if (declaringClass == Double.TYPE || declaringClass == Double.class) {
                        declaredField.set(obj, (double)((Double)compoundTag.method_10574(name).get()));
                    }
                    if (declaringClass == Byte.TYPE || declaringClass == Byte.class) {
                        declaredField.set(obj, (byte)((Byte)compoundTag.method_10571(name).get()));
                    }
                    if (declaringClass == Short.TYPE || declaringClass == Short.class) {
                        declaredField.set(obj, (short)((Short)compoundTag.method_10568(name).get()));
                    }
                    if (declaringClass == Character.TYPE || declaringClass == Character.class) {
                        declaredField.set(obj, Character.valueOf((char)((Integer)compoundTag.method_10550(name).get()).intValue()));
                    }
                }
                if (declaringClass == String.class) {
                    declaredField.set(obj, compoundTag.method_10558(name));
                }
                if (declaringClass.isInstance(Collection.class)) {
                    Object o = declaredField.get(obj);
                    if (o instanceof Collection) {
                        Collection collection = (Collection)o;
                        collection.clear();
                        class_2499 list2 = compoundTag.method_68569(name);
                        for (class_2520 tag12 : list2) {
                            collection.add(TrackedData.fromTag(tag12, null));
                        }
                    }
                    declaredField.set(obj, compoundTag.method_68569(name));
                }
                if (declaredField.getType().isEnum()) {
                    declaredField.set(obj, Enum.valueOf(declaredField.getType(), (String)compoundTag.method_10558(name).get()));
                }
                if (!declaredField.getType().isArray()) continue;
                if (declaringClass == int[].class) {
                    declaredField.set(obj, compoundTag.method_10561(name));
                }
                if (declaringClass == long[].class) {
                    declaredField.set(obj, compoundTag.method_10565(name));
                }
                if (declaringClass == byte[].class) {
                    declaredField.set(obj, compoundTag.method_10547(name));
                }
                if (declaringClass == float[].class) {
                    list = compoundTag.method_68569(name);
                    float[] result = new float[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        class_2494 class_24942 = (class_2494)list.method_10534(i);
                        result[i] = class_24942.method_10700();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == double[].class) {
                    list = compoundTag.method_68569(name);
                    double[] result = new double[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        class_2489 class_24892 = (class_2489)list.method_10534(i);
                        result[i] = class_24892.method_10697();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == boolean[].class) {
                    list = compoundTag.method_68569(name);
                    boolean[] result = new boolean[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        class_2481 class_24812 = (class_2481)list.method_10534(i);
                        result[i] = class_24812.method_10698() == 1;
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == short[].class) {
                    list = compoundTag.method_68569(name);
                    short[] result = new short[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        class_2516 class_25162 = (class_2516)list.method_10534(i);
                        result[i] = class_25162.method_10696();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == char[].class) {
                    list = compoundTag.method_68569(name);
                    char[] result = new char[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        class_2497 class_24972 = (class_2497)list.method_10534(i);
                        result[i] = (char)class_24972.method_10701();
                    }
                    declaredField.set(obj, result);
                }
                if (!declaringClass.isInstance(Map.class)) continue;
                declaredField.set(obj, TrackedData.fromTag(compoundTag.method_10580(name), declaredField.getType()));
            }
        }
        return obj;
    }

    public static <T> T fromTag(class_2520 tag, Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (tag instanceof class_2497) {
            class_2497 intTag = (class_2497)tag;
            return (T)Integer.valueOf(intTag.method_10701());
        }
        if (tag instanceof class_2503) {
            class_2503 longTag = (class_2503)tag;
            return (T)Long.valueOf(longTag.method_10699());
        }
        if (tag instanceof class_2494) {
            class_2494 floatTag = (class_2494)tag;
            return (T)Float.valueOf(floatTag.method_10700());
        }
        if (tag instanceof class_2489) {
            class_2489 doubleTag = (class_2489)tag;
            return (T)Double.valueOf(doubleTag.method_10697());
        }
        if (tag instanceof class_2481) {
            class_2481 byteTag = (class_2481)tag;
            return (T)Byte.valueOf(byteTag.method_10698());
        }
        if (tag instanceof class_2516) {
            class_2516 shortTag = (class_2516)tag;
            return (T)Short.valueOf(shortTag.method_10696());
        }
        if (tag instanceof class_2519) {
            class_2519 stringTag = (class_2519)tag;
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, stringTag.comp_3831());
            }
            return (T)stringTag.comp_3831();
        }
        if (tag instanceof class_2495) {
            class_2495 intArrayTag = (class_2495)tag;
            return (T)intArrayTag.method_10588();
        }
        if (tag instanceof class_2501) {
            class_2501 longArrayTag = (class_2501)tag;
            return (T)longArrayTag.method_10615();
        }
        if (tag instanceof class_2479) {
            class_2479 byteArrayTag = (class_2479)tag;
            return (T)byteArrayTag.method_10521();
        }
        if (tag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)tag;
            HashMap<String, class_2520> entries = new HashMap<String, class_2520>();
            for (String key : compoundTag.method_10541()) {
                entries.put(key, compoundTag.method_10580(key));
            }
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field declaredField : clazz.getDeclaredFields()) {
                int modifiers = declaredField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                declaredField.setAccessible(true);
                String name = TrackedData.getName(declaredField, entries);
                class_2520 tag1 = (class_2520)entries.get(name);
                if (tag1 == null) continue;
                declaredField.set(t, TrackedData.fromTag(tag1, declaredField.getType()));
            }
            return t;
        }
        if (tag instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (t instanceof Collection) {
                Collection collection = (Collection)t;
                for (class_2520 tag1 : listTag) {
                    collection.add(TrackedData.fromTag(tag1, clazz));
                }
            }
            return t;
        }
        return null;
    }

    private static String getName(Field declaredField, Map<String, class_2520> entries) {
        SerializedName annotation;
        String name = declaredField.getName();
        if (declaredField.isAnnotationPresent(SerializedName.class) && !entries.containsKey(name = (annotation = declaredField.getAnnotation(SerializedName.class)).value()) && annotation.alternate().length > 0) {
            for (String s : annotation.alternate()) {
                if (!entries.containsKey(s)) continue;
                name = s;
                break;
            }
        }
        return name;
    }
}

