/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data.type.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.dataanchor.data.InternalDirtyMarker;
import dev.corgitaco.dataanchor.data.ServerTrackedData;
import dev.corgitaco.dataanchor.data.TickableTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import dev.corgitaco.dataanchor.data.type.level.LevelTrackedData;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4284;

public class TrackedLevelSavedData
extends class_18
implements TrackedDataContainer<class_1937, LevelTrackedData> {
    public static final String DATA_NAME = "dataanchor_saved_tracked_data";
    private final Map<TrackedDataKey<LevelTrackedData>, LevelTrackedData> trackedDataMap = new Reference2ReferenceOpenHashMap();
    private final List<TickableTrackedData> tickableData = new ArrayList<TickableTrackedData>();
    private final class_3218 serverLevel;

    public void method_78(boolean dirty) {
        class_3218 class_32182;
        super.method_78(dirty);
        if (!dirty && (class_32182 = this.serverLevel) instanceof InternalDirtyMarker) {
            InternalDirtyMarker dirtyMarker = (InternalDirtyMarker)class_32182;
            dirtyMarker.dataAnchor$clearDirty();
        }
    }

    private TrackedLevelSavedData(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
        this.dataAnchor$createTrackedData();
    }

    public static TrackedLevelSavedData get(class_3218 world) {
        class_26 data = world.method_17983();
        Codec codec = RecordCodecBuilder.create(trackedLevelSavedDataInstance -> trackedLevelSavedDataInstance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_2487.field_25128).fieldOf("map").forGetter(trackedLevelData -> {
            HashMap<String, class_2487> map = new HashMap<String, class_2487>();
            for (Map.Entry<TrackedDataKey<LevelTrackedData>, LevelTrackedData> entry : trackedLevelData.trackedDataMap.entrySet()) {
                map.put(entry.getKey().getId().toString(), entry.getValue().save());
            }
            return map;
        })).apply((Applicative)trackedLevelSavedDataInstance, map -> {
            TrackedLevelSavedData trackedLevelSavedData = new TrackedLevelSavedData(world);
            for (Map.Entry entry : map.entrySet()) {
                trackedLevelSavedData.trackedDataMap.forEach((key, value) -> {
                    if (key.getId().toString().equals(entry.getKey())) {
                        value.load((class_2487)entry.getValue());
                    }
                });
            }
            return trackedLevelSavedData;
        }));
        return (TrackedLevelSavedData)data.method_17924(new class_10741(DATA_NAME, () -> new TrackedLevelSavedData(world), codec, class_4284.field_19212));
    }

    @Override
    public <E extends LevelTrackedData> Optional<E> dataAnchor$getTrackedData(TrackedDataKey<E> key) {
        LevelTrackedData levelTrackedData = this.trackedDataMap.get(key);
        if (levelTrackedData == null) {
            return Optional.empty();
        }
        return Optional.of(levelTrackedData);
    }

    @Override
    public void dataAnchor$createTrackedData() {
        TrackedDataRegistries.LEVEL.factories().forEach((key, factory) -> {
            LevelTrackedData trackedData = (LevelTrackedData)factory.create(key, this.serverLevel);
            if (trackedData instanceof ServerTrackedData) {
                if (trackedData instanceof TickableTrackedData) {
                    TickableTrackedData tickableData = (TickableTrackedData)((Object)trackedData);
                    this.tickableData.add(tickableData);
                }
                this.trackedDataMap.put((TrackedDataKey<LevelTrackedData>)key, trackedData);
            }
        });
    }

    @Override
    public Collection<TrackedDataKey<LevelTrackedData>> dataAnchor$getTrackedDataKeys() {
        return this.trackedDataMap.keySet();
    }
}

