/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.class_2382;
import net.minecraft.class_3341;
import net.minecraft.class_9380;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NearestPoint<T> {
    public static final int[][][] SPIRAL_FAST_2D = NearestPoint.spiral2D(32);
    public static final int[][][] SPIRAL_FAST_3D = NearestPoint.spiral3D(32);

    public void setPoint(class_2382 var1, T var2);

    public void removePoint(class_2382 var1);

    @Nullable
    public PointData<T> getNearestPointData(class_2382 var1, DistanceFunction var2);

    public Collection<PointData<T>> getPointDataWithinRange(class_2382 var1, double var2, DistanceFunction var4);

    default public void removePointsWithinRange(PointData<T> point, int range, DistanceFunction distanceFunction) {
        Collection<PointData<T>> pointsWithinRange = this.getPointDataWithinRange(point.point, range, distanceFunction);
        for (PointData<T> vec3i : pointsWithinRange) {
            this.removePoint(vec3i.point);
        }
    }

    public boolean isEmpty();

    public Collection<PointData<T>> getAllPointData();

    public void clear();

    default public Collection<PointData<T>> getPointDataInBox(class_2382 min, class_2382 max) {
        return this.getPointDataWithinRange(NearestPoint.getCenter(min, max), (double)NearestPoint.chebyshevDistance(min.method_10263(), min.method_10264(), max.method_10263(), max.method_10264()) / 2.0, NearestPoint::chebyshevDistance);
    }

    default public Collection<PointData<T>> getPointDataInBox(class_9380 box) {
        return this.getPointDataInBox((class_2382)box.comp_2466(), (class_2382)box.comp_2467());
    }

    default public Collection<PointData<T>> getPointDataInBox(class_3341 box) {
        return this.getPointDataInBox(new class_2382(box.method_35415(), box.method_35416(), box.method_35417()), new class_2382(box.method_35418(), box.method_35419(), box.method_35420()));
    }

    default public Collection<PointData<T>> getPointDataInBox(class_2382 center, int radius) {
        return this.getPointDataInBox(new class_2382(center.method_10263() - radius, center.method_10264() - radius, center.method_10260() - radius), new class_2382(center.method_10263() + radius, center.method_10264() + radius, center.method_10260() + radius));
    }

    default public void removePointsInBox(class_2382 min, class_2382 max) {
        Collection<PointData<T>> pointsWithinRange = this.getPointDataInBox(min, max);
        for (PointData<T> vec3i : pointsWithinRange) {
            this.removePoint(vec3i.point);
        }
    }

    default public void removePointsInBox(class_9380 box) {
        this.removePointsInBox((class_2382)box.comp_2466(), (class_2382)box.comp_2467());
    }

    default public void removePointsInBox(class_3341 box) {
        this.removePointsInBox(new class_2382(box.method_35415(), box.method_35416(), box.method_35417()), new class_2382(box.method_35418(), box.method_35419(), box.method_35420()));
    }

    default public void removePointsInBox(class_2382 center, int radius) {
        this.removePointsInBox(new class_2382(center.method_10263() - radius, center.method_10264() - radius, center.method_10260() - radius), new class_2382(center.method_10263() + radius, center.method_10264() + radius, center.method_10260() + radius));
    }

    @Nullable
    default public class_2382 getNearestPoint(class_2382 point, DistanceFunction distanceFunction) {
        PointData<T> nearestPointData = this.getNearestPointData(point, distanceFunction);
        if (nearestPointData == null) {
            return null;
        }
        return nearestPointData.point();
    }

    default public Collection<class_2382> getPointsInBox(class_2382 min, class_2382 max) {
        return this.getVec3is(this.getPointDataInBox(min, max));
    }

    default public Collection<class_2382> getPointsInBox(class_2382 center, int radius) {
        return this.getVec3is(this.getPointDataInBox(center, radius));
    }

    default public Collection<class_2382> getPointsInBox(class_9380 box) {
        return this.getVec3is(this.getPointDataInBox(box));
    }

    default public Collection<class_2382> getPointsInBox(class_3341 box) {
        return this.getVec3is(this.getPointDataInBox(box));
    }

    public static int chebyshevDistance(class_2382 min, class_2382 max) {
        return NearestPoint.chebyshevDistance(min.method_10263(), min.method_10260(), max.method_10263(), max.method_10260());
    }

    public static int chebyshevDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        return Math.max(dx, Math.max(dy, dz));
    }

    public static int chebyshevDistance(int x1, int y1, int x2, int y2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        return Math.max(dx, dy);
    }

    private static class_2382 getCenter(class_2382 point1, class_2382 point2) {
        int centerX = (point1.method_10263() + point2.method_10263()) / 2;
        int centerY = (point1.method_10264() + point2.method_10264()) / 2;
        int centerZ = (point1.method_10260() + point2.method_10260()) / 2;
        return new class_2382(centerX, centerY, centerZ);
    }

    @NotNull
    private List<class_2382> getVec3is(Collection<PointData<T>> pointsInBox) {
        ArrayList<class_2382> points = new ArrayList<class_2382>();
        for (PointData<T> inBox : pointsInBox) {
            points.add(inBox.point());
        }
        return Collections.unmodifiableList(points);
    }

    public static int[][][] spiral2D(int size) {
        TreeMap<Integer, List> distanceMap = new TreeMap<Integer, List>();
        for (int x = -size; x <= size; ++x) {
            int z = -size;
            while (z <= size) {
                int distance = NearestPoint.chebyshevDistance(0, 0, x, z);
                distanceMap.computeIfAbsent(distance, dist -> new ArrayList()).add(new int[]{x, z++});
            }
        }
        ArrayList<int[][]> offsets = new ArrayList<int[][]>();
        for (List value : distanceMap.values()) {
            offsets.add((int[][])value.toArray(x$0 -> new int[x$0][]));
        }
        return (int[][][])offsets.toArray((T[])new int[offsets.size()][][]);
    }

    public static int[][][] spiral3D(int size) {
        TreeMap<Integer, List> distanceMap = new TreeMap<Integer, List>();
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                int z = -size;
                while (z <= size) {
                    int distance = NearestPoint.chebyshevDistance(0, 0, 0, x, y, z);
                    distanceMap.computeIfAbsent(distance, dist -> new ArrayList()).add(new int[]{x, y, z++});
                }
            }
        }
        ArrayList<int[][]> offsets = new ArrayList<int[][]>();
        for (List value : distanceMap.values()) {
            offsets.add((int[][])value.toArray(x$0 -> new int[x$0][]));
        }
        return (int[][][])offsets.toArray((T[])new int[offsets.size()][][]);
    }

    public record PointData<T>(T value, class_2382 point) {
    }

    @FunctionalInterface
    public static interface DistanceFunction {
        public double apply(class_2382 var1, class_2382 var2);
    }
}

