/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.forge.network;

import com.google.auto.service.AutoService;
import dev.corgitaco.dataanchor.forge.network.ForgeNetworkHandler;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.S2CNetworkContainer;
import dev.corgitaco.dataanchor.network.broadcast.S2CPacketBroadcaster;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.PacketDistributor;

@AutoService(value={S2CPacketBroadcaster.class})
public class S2CForgeNetworkHandler
extends ForgeNetworkHandler
implements S2CPacketBroadcaster {
    public S2CForgeNetworkHandler() {
        super(ForgeNetworkHandler.NetworkDirection.S2C);
    }

    @Override
    public void registerPackets() {
        S2CNetworkContainer.S2C_NAMESPACED_CONTAINERS.forEach((s, networkContainer) -> networkContainer.registerMessages(this::registerMessage));
    }

    @Override
    public <MSG extends Packet> void sendToPlayer(MSG msg, ServerPlayer player) {
        ((Channel)this.channels.get(msg.getClass())).send(msg, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayers(MSG msg) {
        ((Channel)this.channels.get(msg.getClass())).send(msg, PacketDistributor.ALL.noArg());
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayersInDimension(MSG msg, ServerLevel dimension) {
        ((Channel)this.channels.get(msg.getClass())).send(msg, PacketDistributor.DIMENSION.with((Object)dimension.dimension()));
    }

    @Override
    public <MSG extends Packet> void sendNearPositionInDimension(MSG msg, ServerLevel dimension, double x, double y, double z, double radius) {
        ((Channel)this.channels.get(msg.getClass())).send(msg, PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint(x, y, z, radius, dimension.dimension())));
    }

    @Override
    public <MSG extends Packet> void trackingEntity(MSG msg, Entity entity) {
        ((Channel)this.channels.get(msg.getClass())).send(msg, PacketDistributor.TRACKING_ENTITY.with((Object)entity));
    }

    @Override
    public <MSG extends Packet> void trackingEntityAndSelf(MSG msg, Entity entity) {
        ((Channel)this.channels.get(msg.getClass())).send(msg, PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity));
    }

    @Override
    public <MSG extends Packet> void trackingChunk(MSG msg, LevelChunk chunk) {
        ((Channel)this.channels.get(msg.getClass())).send(msg, PacketDistributor.TRACKING_CHUNK.with((Object)chunk));
    }
}

