/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.mixin.client;

import dev.corgitaco.dataanchor.data.TickableTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements LevelAccessor {
    @Shadow
    @Final
    public boolean isClientSide;

    @Inject(method={"tickBlockEntities()V"}, at={@At(value="RETURN")})
    private void tickClient(CallbackInfo ci) {
        ChunkSource chunkSource;
        if (this.isClientSide && (chunkSource = this.getChunkSource()) instanceof ClientChunkCache) {
            ClientChunkCache clientChunkCache = (ClientChunkCache)chunkSource;
            AtomicReferenceArray<LevelChunk> chunks = this.dataAnchor$getChunks(clientChunkCache);
            int length = chunks.length();
            for (int i = 0; i < length; ++i) {
                LevelChunk levelChunk = chunks.get(i);
                if (levelChunk == null) continue;
                if (levelChunk instanceof TrackedDataContainer) {
                    TrackedDataContainer dataContainer = (TrackedDataContainer)levelChunk;
                    Collection keys = dataContainer.dataAnchor$getTrackedDataKeys();
                    for (TrackedDataKey key : keys) {
                        Object t;
                        Optional optional = dataContainer.dataAnchor$getTrackedData(key);
                        if (!optional.isPresent() || !((t = optional.get()) instanceof TickableTrackedData)) continue;
                        TickableTrackedData trackedData = (TickableTrackedData)t;
                        trackedData.tick();
                    }
                }
                for (BlockEntity value : levelChunk.getBlockEntities().values()) {
                    if (!(value instanceof TrackedDataContainer)) continue;
                    TrackedDataContainer container = (TrackedDataContainer)value;
                    Collection keys = container.dataAnchor$getTrackedDataKeys();
                    for (TrackedDataKey key : keys) {
                        container.dataAnchor$getTrackedData(key).ifPresent(data -> {
                            if (data instanceof TickableTrackedData) {
                                TickableTrackedData tickableData = (TickableTrackedData)data;
                                tickableData.tick();
                            }
                        });
                    }
                }
            }
        }
    }

    @Unique
    private synchronized AtomicReferenceArray<LevelChunk> dataAnchor$getChunks(ClientChunkCache clientChunkCache) {
        return clientChunkCache.storage.chunks;
    }
}

